/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.store;
import java.util.*;

import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.pim.*;

public class Exch2kScheduleDTO extends BasicScheduleDTO {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private boolean isnew=true;
/* urn:schemas:calendar */
	private boolean alldayevent;
	private String busystatus;
	private Date created;
//	private Date dtstart; //super.startDate
//	private Date dtend;  //super.endDate
	private long duration;
	private String[] exdate;
	private String exrule;
	private long instancetype;
	private boolean isorganizer;
	private Date lastmodified;
	private Date lastmodifiedtime;
//	private String location; //super
	private String meetingstatus;
	private MailAddress organizer;
	private String[] rdate;
	private String recurrenceid;
	private Date remindernexttime;
	private boolean reminderset;
	private long reminderoffset;
	private String resources;
	private String rrule;
	private long sequence;
	private String timezone;
	private long timezoneid;
	private String uid;
	private String version;
	private boolean responserequested;

/* urn:schemas:httpmail */
//	private String subject; //super
//	private String textdescription; //super.body
	
/* urn:schemas:mailheader */
	private MailAddress[] to;
	private MailAddress[] cc;
	private MailAddress[] bcc;
	
/* http://schemas.microsoft.com/mapi/ */
//	private boolean finvited;
//	private long responsestatus;
//	private long responsestate;
//	private long apptstateflags;
//	private long busystatus;//http://schemas.microsoft.com/mapi/busystatus
//	private long intendedbusystatus;
	
	
	/* ( Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return super.toString() + ":" + boid.getIndex() + ":" + subject;
	}

	public boolean isAlldayevent() {
		return alldayevent;
	}

	public void setAlldayevent(boolean alldayevent) {
		this.alldayevent = alldayevent;
	}

	public String getBusystatus() {
		return busystatus;
	}

	public void setBusystatus(String busystatus) {
		this.busystatus = busystatus;
	}

	public Date getCreated() {
		return created;
	}

	public void setCreated(Date created) {
		this.created = created;
	}

	public Date getDtend() {
		return endDate;
	}

	public void setDtend(Date dtend) {
		super.endDate = dtend;
	}

	public Date getDtstart() {
		return startDate;
	}

	public void setDtstart(Date dtstart) {
		super.startDate = dtstart;
	}

	public long getDuration() {
		return duration;
	}

	public void setDuration(long duration) {
		this.duration = duration;
	}

	public String[] getExdate() {
		return exdate;
	}

	public void setExdate(String[] exdate) {
		this.exdate = exdate;
	}

	public String getExrule() {
		return exrule;
	}

	public void setExrule(String exrule) {
		this.exrule = exrule;
	}

	public long getInstancetype() {
		return instancetype;
	}

	public void setInstancetype(long instancetype) {
		this.instancetype = instancetype;
	}

	public boolean isIsorganizer() {
		return isorganizer;
	}

	public void setIsorganizer(boolean isorganizer) {
		this.isorganizer = isorganizer;
	}

	public Date getLastmodified() {
		return lastmodified;
	}

	public void setLastmodified(Date lastmodified) {
		this.lastmodified = lastmodified;
	}

	public Date getLastmodifiedtime() {
		return lastmodifiedtime;
	}

	public void setLastmodifiedtime(Date lastmodifiedtime) {
		this.lastmodifiedtime = lastmodifiedtime;
	}

	public String getMeetingstatus() {
		return meetingstatus;
	}

	public void setMeetingstatus(String meetingstatus) {
		this.meetingstatus = meetingstatus;
	}

	public MailAddress getOrganizer() {
		return organizer;
	}

	public void setOrganizer(MailAddress organizer) {
		this.organizer = organizer;
	}

	public String[] getRdate() {
		return rdate;
	}

	public void setRdate(String[] rdate) {
		this.rdate = rdate;
	}

	public String getRecurrenceid() {
		return recurrenceid;
	}

	public void setRecurrenceid(String recurrenceid) {
		this.recurrenceid = recurrenceid;
	}

	public long getReminderoffset() {
		return reminderoffset;
	}

	public void setReminderoffset(long reminderoffset) {
		this.reminderoffset = reminderoffset;
	}

	public String getResources() {
		return resources;
	}

	public void setResources(String resources) {
		this.resources = resources;
	}

	public String getRrule() {
		return rrule;
	}

	public void setRrule(String rrule) {
		this.rrule = rrule;
	}

	public long getSequence() {
		return sequence;
	}

	public void setSequence(long sequence) {
		this.sequence = sequence;
	}

	public String getTimezone() {
		return timezone;
	}

	public void setTimezone(String timezone) {
		this.timezone = timezone;
	}

	public long getTimezoneid() {
		return timezoneid;
	}

	public void setTimezoneid(long timezoneid) {
		this.timezoneid = timezoneid;
	}

	public String getUid() {
		return uid;
	}

	public void setUid(String uid) {
		this.uid = uid;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public MailAddress[] getBcc() {
		return bcc;
	}

	public void setBcc(MailAddress[] bcc) {
		this.bcc = bcc;
	}

	public MailAddress[] getCc() {
		return cc;
	}

	public void setCc(MailAddress[] cc) {
		this.cc = cc;
	}

	public String getTextdescription() {
		return body;
	}

	public void setTextdescription(String textdescription) {
		super.body = textdescription;
	}

	public MailAddress[] getTo() {
		return to;
	}

	public void setTo(MailAddress[] to) {
		this.to = to;
	}

	public Exch2kScheduleDTO() {
		super();
		busystatus = "BUSY";
		meetingstatus = "TENTATIVE";
		alldayevent = false;
		instancetype = 0;
		version = "2.0";
		
	}
	
	

	/* ( Javadoc)
	 * @see jp.co.connectone.store.pim.BasicScheduleDTO#setOid(jp.co.connectone.store.IObjectIndex)
	 */
	public void setOid(IObjectIndex oid)
	{
		super.setOid(oid);
		isnew = false;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.BasicRecordObject#isNew()
	 */
	public boolean isNew()
	{
		return isnew;
	}

	public boolean isResponserequested() {
		return responserequested;
	}

	public void setResponserequested(boolean responserequested) {
		this.responserequested = responserequested;
	}

	/**
	 * @return remindernexttime ߂܂B
	 */
	public Date getRemindernexttime()
	{
		return remindernexttime;
	}

	/**
	 * @param remindernexttime remindernexttimeݒ肵܂B
	 */
	public void setRemindernexttime(Date remindernexttime)
	{
		this.remindernexttime = remindernexttime;
	}

	/**
	 * @return reminderset ߂܂B
	 */
	public boolean isReminderset()
	{
		return reminderset;
	}

	/**
	 * @param reminderset remindersetݒ肵܂B
	 */
	public void setReminderset(boolean reminderset)
	{
		this.reminderset = reminderset;
	}
}