/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.dav;


/**
 * @author amanot
 *
 */
@SuppressWarnings("unchecked")
public class ExPropPatchProperty implements Comparable {
	private String sortID;
	private String name;
	private String value;
	private String namespace;
	private String namespaceInfo;
	
	private String getNameSpaceString(String name) {
		if (name==null) return null;
		if (name.startsWith("http://")) {
			int index = name.substring(0,name.length()-1).lastIndexOf('/');// get the index position of las word inclues the case 'http://xxx/lastword/'
			return name.substring(0,index+1);
		}
		else if (name.startsWith("urn:")) {
			int index = name.lastIndexOf(':');// get the index position of las word from "urn:xxx:xxx"
			int index2 = name.lastIndexOf('/');// in case "urn:uuid:xxx/xxx", the special case on Microsoft
			if (index2 > index) index = index2;
			return name.substring(0,index+1);
		}
		else if (name.startsWith("DAV:")) {
			return "DAV:";// in case of "DAV"
		}
		return null;
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.sortID = name;
		this.namespaceInfo = getNameSpaceString(name);
		if (this.namespaceInfo != null) {
			this.name = name.substring(this.namespaceInfo.length(),name.length());
//			this.namespace = this.namespaceInfo.replaceAll("/","").replaceAll("\\.","").replaceAll(":","");
			if ( "DAV:".equalsIgnoreCase(this.namespaceInfo)) {
				this.namespace = "D";
			}
			else {
				this.namespace = "p" + Integer.toHexString(this.namespaceInfo.hashCode());
			}
		}
		else {
			name = sortID;
		}
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}
	public String getNamespace() {
		return namespace;
	}
	
	public int compareTo(Object dst) {
		if (dst instanceof ExPropPatchProperty) {
			ExPropPatchProperty dest = (ExPropPatchProperty)dst;
			return this.sortID.compareTo(dest.getSortID());
		}
		return 0;
	}
	public String getSortID() {
		return sortID;
	}
	public String getNamespaceInfo() {
		return namespaceInfo;
	}
}
