import java.util.*;

import jp.co.connectone.eai.notes.store.*;
import jp.co.connectone.eai.notes.user.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
/**
 * @author patni
 * 
 */
public class NotesMailStoreImplTest extends TestCase implements User {
	String strUser = USER;
	String strPassword = PASSWORD;
	String strSvr = MAILSERVER;
	String strFolder = FOLDER;
	String strTFolder = TFOLDER;
	String strDate1 = STRDATE;
	Date date; 
	NotesMailStoreImpl aEAINotesImplObj;
	NotesAccountData acc;
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception
	{
		aEAINotesImplObj = new NotesMailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		NotesServiceInfo si = (NotesServiceInfo)aEAINotesImplObj.getServiceInfo();
		si.setServerAddress(strSvr);
		acc = new NotesAccountData(uid,si);
		acc.setUserID(strUser);
		acc.setInternetPassword(strPassword);
	}
	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception 
	{
		super.tearDown();
	}
	
	public void testGetName() throws Exception
	{
		assertEquals(aEAINotesImplObj.getName(),NotesConstants.MAILSTORE_NAME);
	}
	
	public void testGetStoreID() throws Exception
	{
		Log.debug(aEAINotesImplObj.getStoreID().getStoreID());
		assertEquals(aEAINotesImplObj.getStoreID().getStoreID(),"jp.co.connectone.eai.notes.store.NotesMailStoreClient");
	}
	
	public void testGetInstance()
	{
		assertNotNull(NotesMailStoreImpl.getInstance());
	}
	
	public void testGetMailFolders() throws Exception
	{
		/* fetches array of string from the testGetMailFolders */
		FolderMetadata strFolderlist2[]; 
	    strFolderlist2 = aEAINotesImplObj.getMailFolders(acc,null);
	    for (int i=0;i<strFolderlist2.length;i++) {
	    	Log.debug("strForlderList["+i+"]="+strFolderlist2[i]);
	    	Object oid = strFolderlist2[i].getOid();
	    	Log.debug("oid["+i+"]="+oid);
	    	assertNotNull(oid);
	    	
	    }
	    /* Checks the Folderslist against the output of the method */
		boolean includeFlag=false;
		for (int i=0;i<strFolderlist2.length;i++) {
			if ("($Inbox)".equals(strFolderlist2[i].getFolderName())) {
				includeFlag=true;
			}
			Log.debug(strFolderlist2[i].getFolderName());
		}
		assertTrue(includeFlag);
		includeFlag=false;
		for (int i=0;i<strFolderlist2.length;i++) {
			if ("($Trash)".equals(strFolderlist2[i].getFolderName())) {
				includeFlag=true;
			}
			Log.debug(strFolderlist2[i].getFolderName());
		}
		assertTrue(includeFlag);
		includeFlag=false;
		for (int i=0;i<strFolderlist2.length;i++) {
			if ("(Group Calendars)".equals(strFolderlist2[i].getFolderName())) {
				includeFlag=true;
			}
			Log.debug(strFolderlist2[i].getFolderName());
		}
		assertTrue(includeFlag);
		includeFlag=false;
		for (int i=0;i<strFolderlist2.length;i++) {
			if ("($Alarms)".equals(strFolderlist2[i].getFolderName())) {
				includeFlag=true;
			}
			Log.debug(strFolderlist2[i].getFolderName());
		}
		assertTrue(includeFlag);
	}
	public void testgetHeaders() throws Exception
	{
		IMailDTO TstrHeader[] = null;
		
		TstrHeader = aEAINotesImplObj.getHeaders(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER));
		
		assertNotNull(TstrHeader);
		assertTrue(TstrHeader.length>0);// at least one mail shold be in ($Inbox) with test-date.

	}
	public void testgetHeadersByDate() throws Exception
	{
		IMailDTO strHeader3[] = null;
		Calendar c = Calendar.getInstance();
		c.set(2006, 1, 22, 0, 0 ,0);//month -> 0-11
		Date date = c.getTime();
		strHeader3 = aEAINotesImplObj.getHeadersByDate(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date); 
		assertNotNull(strHeader3);
		assertTrue(strHeader3.length>0);// mails shold be in ($Inbox) with test-date.
		for (int i=0;i<strHeader3.length;i++) {
			dumpDTO2(strHeader3[i]);
		}
		strHeader3=null;
		c.set(2005, 11, 1, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		strHeader3 = aEAINotesImplObj.getHeadersByDate(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date); 
		assertNotNull(strHeader3);
		assertEquals(strHeader3.length,0);// no mail shold be in ($Inbox) with test-date.
	}
	
	public void testDeleteMail() throws Exception
	{
		String uidl="0DB68FD3310CC3794925702600290841";
//		String uidl=null;
		if (uidl==null) return;
		BasicObjectIndex oid = new BasicObjectIndex(uidl);
		aEAINotesImplObj.deleteMail(acc,oid);
	}
	
	public void testGetUIDLs() throws Exception
	{
		IRecordObject[] uidlArray1;
		uidlArray1 = aEAINotesImplObj.getUIDLs(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER));
		for (int i=0;i<uidlArray1.length;i++) {
			Log.debug("uidlArray1["+i+"]=" + (String)uidlArray1[i].getOid().getIndex());
		}
		assertNotNull(uidlArray1);
		assertTrue(uidlArray1.length>0);// at least one mail data should be in ($Inbox) at 20 Aug.
		
	}
	public void testGetMailsByDate() throws Exception
	{
		Date date;
		Calendar c = Calendar.getInstance();
		c.set(2006, 1, 22, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		IMailDTO[] mails = aEAINotesImplObj.getMailsByDate(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date);
		assertNotNull(mails);
		assertTrue(mails.length>0);
		for (int i=0;i<mails.length;i++) {
			dumpDTO2(mails[i]);
		}
		c.set(2005, 11, 1, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		mails = aEAINotesImplObj.getMailsByDate(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date);
		assertNotNull(mails);
		assertEquals(mails.length,0);
		for (int i=0;i<mails.length;i++) {
			dumpDTO2(mails[i]);
		}
	}

	public void testSentMailsByDate() throws Exception
	{
		Date date;
		Calendar c = Calendar.getInstance();
		c.set(2006, 1, 22, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		IMailDTO[] mails = aEAINotesImplObj.getMailsByDate(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_SENT_FOLDER),date);
		assertNotNull(mails);
		assertTrue(mails.length>0);
		c.set(2004, 11, 1, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		mails = aEAINotesImplObj.getMailsByDate(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date);
		assertNotNull(mails);
		assertEquals(mails.length,0);
	}
	public void testSendNotesMail() throws Exception
	{
		HeaderDTO header = new HeaderDTO();
		String[] to = {"test@amax.co.jp"};
		header.setHeaderTo(to);
		String[] cc = {""};
		header.setHeaderCC(cc);
		header.setHeaderBCC(cc);
		header.setHeaderSubject("EAINotesImplTest̃[");
		IMailDTO mail = new BasicMailDTO();
		mail.setHeaderDTO(header);
		mail.setBody("̓{fB[");
		aEAINotesImplObj.sendMail(acc,mail);
	}
	public void testGetMail() throws Exception
	{
		IObjectIndex oid = new BasicObjectIndex("A026D2953E0027B9492570610019D376");
		IMailDTO mail = aEAINotesImplObj.getMail(acc,aEAINotesImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),oid);
		assertNotNull(mail);
		dumpDTO2(mail);
	}
	
	private void dumpDTO2(IMailDTO dto)
	{
		HeaderDTO h = dto.getHeader();
		Log.debug("=======================================");
		Log.debug(h.getHeaderSubject());
		Log.debug(h.getHeaderFrom().getRawAddress());
		Log.debug(h.getHeaderSendDate().toString());
		Log.debug(h.getHeaderUIDL());
		Log.debug(array2String(h.getHeaderTo()));
		Log.debug(array2String(h.getHeaderCC()));
		Log.debug(dto.getBody());
		Log.debug("=======================================");
	}
	
	private String array2String(MailAddress[] ar)
	{
		return "" + Arrays.asList(ar);
	}
}
