import junit.framework.TestCase;

import java.util.*;
import jp.co.connectone.eai.notes.store.*;
import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.store.*;
import jp.co.connectone.user.*;


//import jp.co.connectone.eai.notes.logic.NotesConstants;
/*
 * 쐬: 2004/11/21
 *
 */

/**
 * @author amanot
 *
 */
public class EAINotesScheduleImplTest extends TestCase {
	private NotesScheduleStoreImpl m_NotesScheduleBean;
	NotesAccountData acc;
	private String userID;
	private String password;
	private String serverAddress;
	
	protected void setUp() throws Exception {
		m_NotesScheduleBean = new NotesScheduleStoreImpl();
		userID = "Test/Amax";
		password="PASSWORD";
		serverAddress="172.16.5.1";
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		NotesServiceInfo si = (NotesServiceInfo)m_NotesScheduleBean.getServiceInfo();
		si.setServerAddress(serverAddress);
		acc = new NotesAccountData(uid,si);
		acc.setUserID(userID);
		acc.setInternetPassword(password);
	}
	protected void tearDown() throws Exception {
	}
	public void testCreateNewSchedule() throws Exception
	{
		Calendar l_calObj = Calendar.getInstance();
		l_calObj.set(2006, 5, 21, 17, 0, 0 );
		Date l_dateObj = l_calObj.getTime();
		l_calObj.set(2006, 5, 21, 19, 30, 0 );
		Date l_dateObj2 = l_calObj.getTime();
		NotesScheduleDTO l_scheduleDTO = new NotesScheduleDTO();
		l_scheduleDTO.setBody("ĂƂAOB");
//		l_scheduleDTO.setCategory("Ă`");
		//l_scheduleDTO.setDescription();
		l_scheduleDTO.setEndDate(l_dateObj2);
		l_scheduleDTO.setLocation("2chW");
//		l_scheduleDTO.setRepeatFlag(false);
//		l_scheduleDTO.setScheduleType(NotesConstants.SCHEDULE_APPOINTMENT);

//		l_scheduleDTO.setRepeatType(NotesTestPropertyHandler.getString("test.newschedule.repeattype"));
		l_scheduleDTO.setStartDate(l_dateObj);
		l_scheduleDTO.setSubject("eXg(sage)");
		l_scheduleDTO.setUserId("TEST/Admin/JP");
		String[] l_byteFilestream = new String[1];
		String bodyStr = new String("ĂƂAOB");
		l_byteFilestream[0] = bodyStr;
		l_scheduleDTO.setDescription( l_byteFilestream);		
		
		IRecordObject ms_strUNID1 = m_NotesScheduleBean.createNewSchedule(acc, l_scheduleDTO);		
		Log.debug("ms_strUNID1=" + (String)ms_strUNID1.getOid().getIndex());
	}
	
	public void testGetSchedulesByDate() throws Exception
	{
		Calendar l_calObj = Calendar.getInstance();
		l_calObj.set(2004, 11, 21, 17, 0, 0 );
		Date l_dateObj = l_calObj.getTime();
		IScheduleDTO[] sche = m_NotesScheduleBean.getSchedulesByDate(acc,l_dateObj);
		assertNotNull(sche);
		Log.debug(Arrays.asList(sche).toString());
	}
	
	public void testGetScheduleByUNID() throws Exception
	{
		IScheduleDTO dto = m_NotesScheduleBean.getSchedule(acc, new BasicObjectIndex("03F83EAFC4BCB32A4925711D001E8977"));
		Log.debug("dto="+dto);
	}
}
