/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.notes.store.pim;

import jp.co.connectone.store.pim.HeaderDTO;

public class AltHeaderDTO extends HeaderDTO {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private String[] altToList;
	private String[] altCcList;
	private String altFrom;
	private String[] altPrincipalList;

	public void setAltTo(String[] altToList)
	{
		if (altToList==null) {
			this.altToList = null;
		}
		else {
			this.altToList = altToList;
		}
	}


	public void setAltCc(String[] altCcList)
	{
		if (altCcList==null) {
			this.altCcList = null;
		}
		else {
			this.altCcList = new String[altCcList.length];
			for (int i=0;i<altCcList.length;i++) {
				this.altCcList[i] = new String(altCcList[i]);
			}
		}
	}


	public void setAltFrom(String altFrom)
	{
		this.altFrom = altFrom;
	}


	public String[] getAltTo() {
		return altToList;
	}


	public String[] getAltCc() {
		return altCcList;
	}


	public String getAltFrom() {
		return altFrom;
	}


	public String[] getAltPrincipal() {
		return altPrincipalList;
	}


	public void setAltPrincipal(String[] altPrincipalList) {
		if (altPrincipalList==null) {
			this.altPrincipalList = null;
		}
		else {
			this.altPrincipalList = new String[altPrincipalList.length];
			for (int i=0;i<altPrincipalList.length;i++) {
				this.altPrincipalList[i] = new String(altPrincipalList[i]);
			}
		}
	}

}
