/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.notes.store;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBandleHandler 
{

	private static final String BUNDLE_NAME = "messages";//$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

	/**
	 *  Constructor
	 */
	private ResourceBandleHandler() 
	{
	
	}

	/**
	 * Returns value of the key from imap property file
	 * @param key Name of the key whose value to be retrieved
	 * @return Value of the key
	 * @throws MissingResourceException
	 */
	public static String getString(String key)throws MissingResourceException
	{
		return RESOURCE_BUNDLE.getString(key);
	}
}