import java.util.*;

import jp.co.connectone.common.MailTool;
import jp.co.connectone.store.pim.MailAddress;
import junit.framework.TestCase;

/**
 * @author amanot
 * 
 */
public class TestMailTool extends TestCase
{
    private MailTool tool;

    @Override
    protected void setUp() throws Exception
    {
	tool = new MailTool();
    }

    public void testCheckAddressFormat() throws Exception
    {
	tool.setAllowNullOrBlankMailAddress(true);
	assertTrue(tool.checkAddressFormat(new MailAddress("foo@bar.com")));
	assertTrue(tool.checkAddressFormat(new MailAddress("\"\" <foo@bar.com>")));
	assertTrue(tool.checkAddressFormat(new MailAddress("\"Mr. unknown @ mail,address:perrern\" <foo.bar@underconstruction.bar.com>")));
	assertFalse(tool.checkAddressFormat(new MailAddress("\"\" </o=First Organization/ou=Exchange Administrative Group (FYDIB0HF23SPDLT)/cn=Receipients/cn=userb007>")));
	assertFalse(tool.checkAddressFormat(new MailAddress("/o=First Organization/ou=Exchange Administrative Group (FYDIB0HF23SPDLT)/cn=Receipients/cn=userb007")));
	assertTrue(tool.checkAddressFormat(null));
	assertTrue(tool.checkAddressFormat(new MailAddress("")));
	assertTrue(tool.checkAddressFormat(new MailAddress("\"\" <>")));

	tool.setAllowNullOrBlankMailAddress(false);
	assertFalse(tool.checkAddressFormat(null));
	assertFalse(tool.checkAddressFormat(new MailAddress("")));
	assertFalse(tool.checkAddressFormat(new MailAddress("\"\" <>")));
    }

    public void testCheckMailAddresses() throws Exception
    {
	MailAddress[] addrsArray = {new MailAddress("foo@bar.com"),new MailAddress("\"\" <foo@bar.com>"),new MailAddress("\"Mr. unknown @ mail,address:perrern\" <foo.bar@underconstruction.bar.com>"),new MailAddress(""),new MailAddress("\"\" <>")};
	List<MailAddress> addrs = Arrays.asList(addrsArray);
	
	tool.setAllowNullOrBlankMailAddress(true);
	List<MailAddress> addrs2 = tool.checkMailAddresses(addrs);
	assertEquals(addrs, addrs2);

	tool.setAllowNullOrBlankMailAddress(false);
	addrs2 = tool.checkMailAddresses(addrs);
	assertFalse(addrs.equals(addrs2));
    }

    public void testCheckMailAddressesString() throws Exception
    {
	String[] addr = {"foo@bar.com","\"\" <foo@bar.com>","\"Mr. unknown @ mail,address:perrern\" <foo.bar@underconstruction.bar.com>","","\"\" <>"};

	tool.setAllowNullOrBlankMailAddress(true);
	String[]addr2 = tool.checkMailAddressesString(addr);
	assertEquals(addr, addr2);

	tool.setAllowNullOrBlankMailAddress(false);
	addr2 = tool.checkMailAddressesString(addr);
	assertFalse(addr.equals(addr2));
    }
}
