/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.user;

import jp.co.connectone.store.BasicObjectIndex;

public class BasicUserKey extends BasicObjectIndex implements IUserKey 
{
	private static final long serialVersionUID = 1L;
	private String keyType;
	private Object keyValue;
	
	
	public BasicUserKey(String keyType,Object val) throws NullPointerException
	{
		if (keyType==null) {
			throw new NullPointerException("keyType must not be null");
		}
		this.keyType = keyType;
		this.keyValue = val;
		super.setIndex(val);
	}

	public BasicUserKey(String keyType) throws NullPointerException
	{
		if (keyType==null) {
			throw new NullPointerException("keyType must not be null");
		}
		this.keyType = keyType;
	}
	/**
	 * @return keyType ߂܂B
	 */
	public String getKeyType() 
	{
		return keyType;
	}
	/**
	 * @param keyType ݒ肷 keyTypeB
	 */
	public void setKeyType(String keyType) 
	{
		this.keyType = keyType;
	}
	/**
	 * @return keyValue ߂܂B
	 */
	public Object getKeyValue() 
	{
		return keyValue;
	}
	/**
	 * @param keyValue ݒ肷 keyValueB
	 */
	public void setKeyValue(Object keyValue) 
	{
		this.keyValue = keyValue;
	}
	/* ( Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) 
	{
		if (obj==null) {
			return false;
		}
		if (obj instanceof BasicUserKey) {
			IUserKey obj2 = (IUserKey)obj;
			if (this.keyType.equalsIgnoreCase(obj2.getKeyType())) {
				if (this.keyValue==null) {
					if (obj2.getKeyValue()==null) {
						return true;
					}
					return false;
				}
				return this.keyValue.equals(obj2.getKeyValue());
			}
		}
		return false;
	}

	/* ( Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode()
	{
		return keyValue.hashCode();
	}
	
	
}
