/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.*;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;

/**
 * @author amanot
 *
 */
public class ScheduleParseHelper  extends BasicScheduleDTO
{
	private static final long serialVersionUID = 1L;
	private String tid;
	
	protected IScheduleDTO schedule=null;
	protected Calendar cal = null;
	protected static final String dayOfWeek[] = {"","","","","","","","y"};
	public ScheduleParseHelper()
	{
		cal = Calendar.getInstance(Locale.JAPAN);
	}
	
	public ScheduleParseHelper(ScheduleParseHelper org)
	{
		schedule = org.schedule;
		cal = org.cal;
	}

	public ScheduleParseHelper(IScheduleDTO sche)
	{
Log.trace("ScheduleParseHelper:initialDTO="+sche);
		cal = Calendar.getInstance(Locale.JAPAN);
		schedule = sche;
	}
	
	public void setScheduleDTO(IScheduleDTO sche)
	{
		schedule = sche;
	}
	
	public IScheduleDTO getScheduleDTO()
	{
		return schedule;
	}
	

	public void setUserId(String userId)
	{
		schedule.setUserId(userId);
	}

	public void setSubject(String subject)
	{
		schedule.setSubject(subject);
	}

	public void setBody(String body)
	{
		String[] description = new String[1];
		description[0] = body;
		schedule.setBody(body);
	}

	public void setStartDate(int year,int month,int dayOfWeek,int hour,int minutes)
	{
		cal.set(year,month,dayOfWeek,hour,minutes);
		schedule.setStartDate(cal.getTime());
	}

	public void setEndDate(int year,int month,int dayOfWeek,int hour,int minutes)
	{
		cal.set(year,month,dayOfWeek,hour,minutes);
		schedule.setEndDate(cal.getTime());
	}
	
	public void setStartDate(Date startDate)
	{
		schedule.setStartDate(startDate);
	}

	public void setEndDate(Date endDate)
	{
		schedule.setEndDate(endDate);
	}

	public void setLocation(String location)
	{
		schedule.setLocation(location);
	}

	public String getUserId()
	{
		return schedule.getUserId();
	}

	public String getSubject()
	{
		return schedule.getSubject();
	}

	public String getBody()
	{
		return schedule.getBody();
/*		String[] rc = schedule.getDescription();
		if (rc==null) return "";
		if (rc[0]==null) return "";
		return rc[0];
*/
	}

	public Date getStartDate()
	{
		return schedule.getStartDate();
	}
	
	public int getStartYear()
	{
		cal.setTime(schedule.getStartDate());
		return cal.get(Calendar.YEAR);
	}
	
	public int getStartMonth()
	{
		cal.setTime(schedule.getStartDate());
		return cal.get(Calendar.MONTH);
	}
	
	public int getStartDayOfMonth()
	{
		cal.setTime(schedule.getStartDate());
		return cal.get(Calendar.DAY_OF_MONTH);
	}
	
	public String getStartDayOfWeek()
	{
		cal.setTime(schedule.getStartDate());
		int d = cal.get(Calendar.DAY_OF_WEEK);
		return dayOfWeek[d];
	}
	
	public int getStartHour()
	{
		cal.setTime(schedule.getStartDate());
		return cal.get(Calendar.HOUR_OF_DAY);
	}
	
	public int getStartMinute()
	{
		cal.setTime(schedule.getStartDate());
		return cal.get(Calendar.MINUTE);
	}

	public Date getEndDate()
	{
		return schedule.getEndDate();
	}
	
	public int getEndYear()
	{
		cal.setTime(schedule.getEndDate());
		return cal.get(Calendar.YEAR);
	}
	
	public int getEndMonth()
	{
		cal.setTime(schedule.getEndDate());
		return cal.get(Calendar.MONTH);
	}
	
	public int getEndDayOfMonth()
	{
		cal.setTime(schedule.getEndDate());
		return cal.get(Calendar.DAY_OF_MONTH);
	}
	
	public String getEndDayOfWeek()
	{
		cal.setTime(schedule.getEndDate());
		int d = cal.get(Calendar.DAY_OF_WEEK);
		return dayOfWeek[d];
	}
	
	public int getEndHour()
	{
		cal.setTime(schedule.getEndDate());
		return cal.get(Calendar.HOUR_OF_DAY);
	}
	
	public int getEndMinute()
	{
		cal.setTime(schedule.getEndDate());
		return cal.get(Calendar.MINUTE);
	}

	public String getLocation()
	{
		return schedule.getLocation();
	}

	public IObjectIndex getOid() {
		return schedule.getOid();
	}

	public void setOid(IObjectIndex oid) {
		schedule.setOid(oid);
	}

	public String getTid() {
		return tid;
	}

	public void setTid(String tid) {
		this.tid = tid;
	}
}
