/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.Date;

import jp.co.connectone.exception.*;
import jp.co.connectone.store.*;
import jp.co.connectone.user.IAccountData;

public interface IScheduleStore extends IStore
{
	public static final int DEST_TYPE_DEFAULT_SCHEDULE_FOLDER=1;
	public static final int DEST_TYPE_OTHERS_SCHEDULEBOX=2;

	public IScheduleDTO[] getAllSchedules(IAccountData acc, Date cutOffDate) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException;
	public IScheduleDTO[] searchSchedules(IAccountData acc, ISearchFormula conds) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException;
	public IScheduleDTO[] getSchedulesByDate(IAccountData acc, Date dateObj) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException;
	public IScheduleDTO getSchedule(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException;
	public IObjectIndex createNewSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException;
	public IObjectIndex updateSchedule(IAccountData acc, IScheduleDTO objScheduleDTO) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException;
	public void deleteSchedule(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException;
	public boolean isDuplicateSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException;
	public boolean isValidSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException;

}