/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import jp.co.connectone.exception.*;
import jp.co.connectone.store.*;
import jp.co.connectone.user.*;

public interface IAddressBookStore extends IStore
{
	public static final int DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER=1;
	public static final int DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK=2;
	
	public IObjectIndex createNewAddressBookItem(IAccountData acc,  ISearchDestination dest, IAddressDTO addressBookDTO) throws IncorrectStore, ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException;
	public IAddressDTO[] getAddressBookItems(IAccountData acc,  ISearchDestination dest) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException;
	public IAddressDTO getAddressBookItem(IAccountData acc,  ISearchDestination dest, IObjectIndex oid) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException;
	public IObjectIndex updateAddressBookItem(IAccountData acc,  ISearchDestination dest, IAddressDTO addressBookDTO) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException;
	public IAddressDTO[] searchAddressBook(IAccountData acc, ISearchFormula conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException;
	public void deleteAddressBookItem(IAccountData acc,  ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException;
	
}