/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.db;

import jp.co.connectone.store.ISearchType;

public class ColumnDescriptor
{
	protected String mname;
	protected Object mvalue;
	protected ISearchType mtype;
	protected String mprefix;
	protected String moperator;
	public static final String PREFIX_AND = " AND ";
	public static final String PREFIX_OR = "  OR ";
	public static final String OPERATOR_EQUALS = " = ";
	public static final String OPERATOR_LIKE = " LIKE ";
	
	
	public ColumnDescriptor(ISearchType type,String name,Object value,String prefix,String operator)
	{
		setType(type);
		setName(name);
		setValue(value);
		setPrefix(prefix);
		setOperator(operator);
	}
	public String getName()
	{
		return mname;
	}
	public void setName(String name)
	{
		this.mname = name;
	}
	public ISearchType getType()
	{
		return mtype;
	}
	public void setType(ISearchType type)
	{
		this.mtype = type;
	}
	public Object getValue()
	{
		return mvalue;
	}
	public void setValue(Object value)
	{
		this.mvalue = value;
	}
	public String getOperator()
	{
		return moperator;
	}
	public void setOperator(String operator)
	{
		if (OPERATOR_EQUALS==operator) {
			this.moperator = operator;
			return;
		}
		else if (OPERATOR_LIKE==operator) {
			this.moperator = operator;
			return;
		}
		throw new IllegalArgumentException("operator must be one of public OPERATORs.");
	}
	public String getPrefix()
	{
		return mprefix;
	}
	public void setPrefix(String prefix)
	{
		if (PREFIX_AND==prefix) {
			this.mprefix = prefix;
			return;
		}
		else if (PREFIX_OR==prefix) {
			this.mprefix = prefix;
			return;
		}
		throw new IllegalArgumentException("prefidx must be one of public PREFIXs.");
	}
}
