/**
 * Copyright (C) 2006/06/14 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 */

/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;


import jp.co.connectone.exception.IncorrectData;

/**
 * @author amanot
 *
 */
public class BasicSearchDestination extends BasicRecordObject implements ISearchDestination
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected IDatabaseIndex database=null;
	protected IFolderIndex folder=null;
	protected boolean recurcive = false;
	
	/**
	 * @return database ߂܂B
	 */
	public IDatabaseIndex getDatabase()
	{
		return database;
	}

	/**
	 * @param database ݒ肷 databaseB
	 */
	public void setDatabase(IDatabaseIndex database)
	{
		this.database = database;
		super.fieldSet.put("database",database);
	}

	protected BasicSearchDestination(){};
	
	public BasicSearchDestination(IDatabaseIndex database,IFolderIndex folder) throws IncorrectData
	{
		super();
		setDatabase(database);
		setFolder(folder);
		String idxStr = null;
		if (database!=null) {
			idxStr = idxStr + database.getIndex();
		}
		if (folder!=null) {
			idxStr = idxStr + folder.getIndex();
		}
		super.oid = new BasicObjectIndex(idxStr);
	}
	
	/* ( Javadoc)
	 * @see jp.co.connectone.store.ISearchDestination#isRecursive()
	 */
	public boolean isRecursive()
	{
		return recurcive;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.ISearchDestination#setRecursive(boolean)
	 */
	public void setRecursive(boolean recursive)
	{
		this.recurcive = recursive;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.ISearchDestination#getFolder()
	 */
	public IFolderIndex getFolder()
	{
		return folder;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.ISearchDestination#setFolder(jp.co.connectone.store.IFolderIndex)
	 */
	public void setFolder(IFolderIndex folder) throws IncorrectData
	{
		this.folder = folder;
		super.fieldSet.put("folder",folder);
	}
}
