/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;


public class BasicObjectIndex extends BasicRecordObject implements IObjectIndex
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Object index;
	public BasicObjectIndex(){}
	public Object getIndex()
	{
		return index;
	}

	public void setIndex(Object arg0)
	{
		if (typeValidation(arg0)!=true) {
			throw new IllegalArgumentException("this module cannot accept index type "+arg0.getClass().getName());
		}
		index = arg0;
	}
	
	protected boolean typeValidation(Object obj)
	{
		return true;
	}

	public BasicObjectIndex(Object arg0)
	{
		setIndex(arg0);
	}

	public boolean equals(Object obj)
	{
		if (obj == null) return false;
		if (!(obj instanceof IObjectIndex)) return false;
		IObjectIndex dst = (IObjectIndex)obj;
		if (dst.getIndex()==null) return false;
		if (!this.index.getClass().getName().endsWith(dst.getIndex().getClass().getName())) return false;
		if (this.index instanceof String) {
			String o1 = (String)this.index;
			String o2 = (String)dst.getIndex();
			return o1.equalsIgnoreCase(o2);
		}
		return super.equals(obj);
	}

	
}
