/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.common;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

import jp.co.connectone.exception.HandleException;

/**
 * @author amanot
 *
 */
public abstract class PropertyHandlerBaseImpl implements IPropertyHandler 
{
	protected static HashMap<String,IPropertyHandler> handlers = null;
	protected static IPropertyHandler theHandler = null;
	protected abstract Properties getSystemProperties() throws Exception;
	
	static 
	{
		handlers = new HashMap<String,IPropertyHandler>();
	}
	
	public static IPropertyHandler getInstance() throws Exception 
	{
		if (theHandler != null) {
			return theHandler;
		}
		String className = System.getProperty("jp.co.connectone.common.IPropertyHandler","jp.co.connectone.common.FileBasedPropertyHandlerImpl");
		try {
			theHandler = (IPropertyHandler)Class.forName(className).newInstance();
			return theHandler;
		}
		catch (Exception e) {
			// ERROR level logging : illegal install/setting
			throw e;
		}
	}

	public static IPropertyHandler getInstance(String className) throws Exception 
	{
		@SuppressWarnings("unused")
		Object o = Class.forName(className);//to load class and execute static method.need valuable o to execute static{} in Class.
		IPropertyHandler handler = (IPropertyHandler)handlers.get(className);
		if (handler==null) {
			throw new HandleException("request IPropertyHandler with bad class name "+className+".");
		}
		return handler;
	}

	public String getValueFromProperties(String key) throws Exception
	{
		return getSystemProperties().getProperty(key);
	}

	@SuppressWarnings("unchecked")
	public Properties getProperties(String key) throws Exception
	{
			Properties props = getSystemProperties();
			
			Enumeration<String> e = (Enumeration<String>) props.propertyNames();
			HashMap<String,String> sectionMap=new HashMap<String,String>();
			while (e.hasMoreElements()) {
				String s = e.nextElement();
				if (s.startsWith(key)) {
					String v = props.getProperty(s);
					String k = s.substring(key.length()+1);
					sectionMap.put(k,v);
				}
			}
	
			Properties rc = new Properties();
			if (sectionMap.size()==0) {
	// it is not an error (2006.5.11)			throw new DataNotFound("Property initialize error:"+key);
			}
			else {
				rc.putAll(sectionMap);
			}
			return rc;
		}

}
