/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.common;

import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import jp.co.connectone.exception.NoSuchRights;

/**
 * @author amanot
 *
 */
public class ADTool extends ActiveActiveServerToolBaseImpl 
{
	private static boolean toggle=false;
	private int toggleCount;
	public int getToggleCount()
	{
		return toggleCount;
	}

	public void setToggleCount(int toggleCount)
	{
		this.toggleCount = toggleCount;
	}

	public boolean isToggle()
	{
		return toggle;
	}

	public void setToggle(boolean toggle)
	{
		ADTool.toggle = toggle;
	}
	
	private DirContext ctx=null;

	public NamingEnumeration<SearchResult> getExchServerContext(String serverName,String serverName2) throws Exception
	{
		NamingEnumeration<SearchResult> rootDSN = this.getRootDSE(serverName,serverName2);
		if (rootDSN==null) return null;
		String sn = getServerToConnect(serverName, serverName2);
		SearchResult aResult =(SearchResult)rootDSN.nextElement();
		String contextLabel = aResult.getAttributes().get("configurationNamingContext").get(0).toString();
		
		Properties env = new Properties();
		env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL,"ldap://" + sn + "/" + contextLabel);
		env.put(Context.REFERRAL, "throw");
		
		try {
			ctx = new InitialDirContext(env);
		}
		catch (CommunicationException ce) {
			if (toggleOn())	{
				return getExchServerContext(serverName,serverName2);
			}
			else {
				throw ce;
			}
		}

		SearchControls constraints = new SearchControls(); 
		constraints.setSearchScope(SearchControls.SUBTREE_SCOPE); 
		NamingEnumeration<SearchResult> results = ctx.search("", "objectCategory=msExchExchangeServer", constraints);
		clearCount();
		return results;
	}

	public NamingEnumeration<SearchResult> getRootDSE(String serverName,String serverName2) throws Exception
	{
		String sn = getServerToConnect(serverName, serverName2);
		Properties env = new Properties();
		env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL,"ldap://" + sn + "/");
		env.put(Context.REFERRAL, "throw");
		
		try {
			ctx = new InitialDirContext(env);
		}
		catch (CommunicationException ce) {
			if (toggleOn())	{
				return getRootDSE(serverName,serverName2);
			}
			else {
				throw ce;
			}
		}
		
		SearchControls constraints = new SearchControls(); 
		constraints.setSearchScope(SearchControls.OBJECT_SCOPE); 
		NamingEnumeration<SearchResult> results = ctx.search("", "objectclass=*", constraints);
		clearCount();
		return results;
	}
	public NamingEnumeration<SearchResult> getUserDatas(String userID,String password,String serverName,String serverName2,String domain,String whereStr) throws Exception
	{
		NamingEnumeration<SearchResult> retStr = null;
		if (userID==null) return retStr;
		if (password==null) {
			throw new NoSuchRights("pussword must not be null.");
		}
		if (password.length()==0) {
			throw new NoSuchRights("pussword must not be null.");
		}
		if (password.trim().length()==0)  {
			throw new NoSuchRights("pussword must not be null.");
		}
		String sn = getServerToConnect(serverName, serverName2);
		Properties env = new Properties();
		env.put(Context.SECURITY_PRINCIPAL, userID+"@"+domain);
		env.put(Context.SECURITY_CREDENTIALS, password); 
		env.put(Context.SECURITY_AUTHENTICATION, "simple"); 
		env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL,"ldap://" + sn + "/");
		env.put(Context.REFERRAL, "follow");
		
		try {
			ctx = new InitialDirContext(env);
		}
		catch (CommunicationException ce) {
			if (toggleOn())	{
				return getUserDatas( userID, password, serverName, serverName2, domain, whereStr);
			}
			else {
				throw ce;
			}
		}
		SearchControls constraints = new SearchControls(); 
		constraints.setTimeLimit(10*1000);
		constraints.setSearchScope(SearchControls.SUBTREE_SCOPE); 

		String searchDomain = domain.replaceAll("\\.",",dc=");
//		String searchStr = "(& (objectclass=Person) (msExchMailboxGuid=*)"+whereStr+")";
		String searchStr = "(& (mailnickname=*) (| (&(objectCategory=person)(objectClass=user)(!(homeMDB=*))(!(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=user)(|(homeMDB=*)(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=contact))(objectCategory=group)(objectCategory=publicFolder) )"+whereStr+")";
		retStr = ctx.search("dc=" + searchDomain + "", searchStr, constraints);
		ctx.close();
		clearCount();
		return retStr;
	}
	public NamingEnumeration<SearchResult> getUserDetail(String userID,String password,String serverName,String serverName2,String domain) throws Exception
	{
		NamingEnumeration<SearchResult> retStr = null;
		if (userID==null) return retStr;
		if (password==null) {
			throw new NoSuchRights("pussword must not be null.");
		}
		if (password.length()==0) {
			throw new NoSuchRights("pussword must not be null.");
		}
		if (password.trim().length()==0)  {
			throw new NoSuchRights("pussword must not be null.");
		}
		String sn = getServerToConnect(serverName, serverName2);
		String searchDomain = domain.replaceAll("\\.",",dc=");
		Properties env = new Properties();
		env.put(Context.SECURITY_PRINCIPAL, userID+"@"+domain);
		env.put(Context.SECURITY_CREDENTIALS, password); 
		env.put(Context.SECURITY_AUTHENTICATION, "simple"); 
		env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL,"ldap://" + sn + "/");
		env.put(Context.REFERRAL, "follow");
		try {
			ctx = new InitialDirContext(env);
		}
		catch (CommunicationException ce) {
			if (toggleOn())	{
				return getUserDetail( userID, password, serverName, serverName2, domain);
			}
			else {
				throw ce;
			}
		}
		SearchControls constraints = new SearchControls(); 
		constraints.setSearchScope(SearchControls.SUBTREE_SCOPE); 

//		retStr = ctx.search("dc=" + searchDomain + "", "userPrincipalName="+userID+"@"+domain+"*", constraints);
		retStr = ctx.search("dc=" + searchDomain + "", "sAMAccountName="+userID, constraints);
		clearCount();
		return retStr;
	}
	public NamingEnumeration<SearchResult> getOtherUserDetail(String idToSee,String userID,String password,String serverName,String serverName2,String domain) throws Exception
	{
		NamingEnumeration<SearchResult> retStr = null;
		if (userID==null) return retStr;
		if (password==null) {
			throw new NoSuchRights("pussword must not be null.");
		}
		if (password.length()==0) {
			throw new NoSuchRights("pussword must not be null.");
		}
		if (password.trim().length()==0)  {
			throw new NoSuchRights("pussword must not be null.");
		}
		String sn;
		sn = getServerToConnect(serverName, serverName2);
		String searchDomain = domain.replaceAll("\\.",",dc=");
		Properties env = new Properties();
		env.put(Context.SECURITY_PRINCIPAL, userID+"@"+domain);
		env.put(Context.SECURITY_CREDENTIALS, password); 
		env.put(Context.SECURITY_AUTHENTICATION, "simple"); 
		env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL,"ldap://" + sn + "/");
		env.put(Context.REFERRAL, "follow");
		try {
			ctx = new InitialDirContext(env);
		}
		catch (CommunicationException ce) {
			if (toggleOn())	{
				return getOtherUserDetail(idToSee, userID, password, serverName, serverName2, domain);
			}
			else {
				throw ce;
			}
		}
		SearchControls constraints = new SearchControls(); 
		constraints.setSearchScope(SearchControls.SUBTREE_SCOPE); 
		constraints.setCountLimit(1);

//		retStr = ctx.search("dc=" + searchDomain + "", "userPrincipalName="+userID+"@"+domain+"*", constraints);
		retStr = ctx.search("dc=" + searchDomain + "", "sAMAccountName="+idToSee, constraints);
		clearCount();
		return retStr;
	}
	
}
