/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.struts;

import java.util.*;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.IRecordObject;

/**
 * @author amanot
 */
public class StrutsArrayList extends ArrayList<IRecordObject>
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private IRecordObject currentItem = null;

	private IndexList idxList = new IndexList();

	private int pageSize = 0;

	private int currentPage = 0;

	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage()
	{
		return currentPage;
	}

	/**
	 * @param currentPage
	 *            currentPage ݒB
	 */
	public void setCurrentPage(int currentPage)
	{
		this.currentPage = currentPage;
	}
	
	public int getIndexBase()
	{
		return this.currentPage * this.pageSize;
	}

	public int getPrevPageIndex()
	{
		if (currentPage < 0)
			return -1;
		return currentPage - 1;
	}

	public int getNextPageIndex()
	{
		int nextPage = currentPage + 1;
		if (this.size() > (nextPage * pageSize))
			return nextPage;
		return -1;
	}

	public Collection<IRecordObject> getCurrentList()
	{
		if (pageSize == 0) {
			return this;
		}
		ArrayList<IRecordObject> currentList = new ArrayList<IRecordObject>();
		int startIndex = currentPage * pageSize;
		int endIndex = startIndex + pageSize;
		for (int i = startIndex; i < endIndex; i++) {
			if (i >= this.size())
				break;
			currentList.add(this.get(i));
		}
		return currentList;
	}

	public int getSize()
	{
		return size();
	}

	public Object getCurrentItem()
	{
		Log.debug("getCurrentItem:currentItem=" + currentItem);
		return currentItem;
	}
	
	public int getNextIdx()
	{
		if (currentItem == null) return -1;
		int idx = indexOf(currentItem) + 1;
		try {
			super.get(idx);
			return idx;
		}
		catch (IndexOutOfBoundsException e) {
		}
		return -1;
	}
	
	public int getPrevIdx()
	{
		if (currentItem == null) return -1;
		int idx = indexOf(currentItem) - 1;
		return idx;
	}

	public Object getNextItem()
	{
		Log.debug("getNextItem:currentItem=" + currentItem);
		if (currentItem == null)
			return null;
		int idx = indexOf(currentItem);
		idx = idx + 1;
		try {
			return super.get(idx);
		}
		catch (IndexOutOfBoundsException e) {
		}
		return null;
	}

	public Object getPrevItem()
	{
		Log.debug("getPrevItem:currentItem=" + currentItem);
		if (currentItem == null)
			return null;
		int idx = indexOf(currentItem);
		idx = idx - 1;
		try {
			return super.get(idx);
		}
		catch (IndexOutOfBoundsException e) {
		}
		return null;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.util.List#get(int)
	 */
	public IRecordObject get(int index)
	{
		currentItem = (IRecordObject)super.get(index);
		return currentItem;
	}

	public void add(int index, IRecordObject obj)
	{
		currentItem = (IRecordObject)obj;
		super.add(index, obj);
		idxList.add(index,currentItem.getOid());
	}

	public boolean add(IRecordObject obj)
	{
		boolean rc = super.add(obj);
		if (rc) {
			currentItem = (IRecordObject)obj;
			idxList.add(currentItem.getOid());
		}
		return rc;
	}
	
	
	public boolean addAll(Collection<? extends IRecordObject> c)
	{
		Iterator<? extends IRecordObject> i = c.iterator();
		while (i.hasNext()) {
			currentItem = (IRecordObject)i.next();
			idxList.add(currentItem.getOid());
		}
		return super.addAll(c);
	}

	public boolean addAll(int index, Collection<? extends IRecordObject> c)
	{
		Iterator<? extends IRecordObject> it = c.iterator();
		int i = 0;
		while (it.hasNext()) {
			currentItem = (IRecordObject)it.next();
			if (i++<index) continue;
			idxList.add(currentItem.getOid());
		}
		return super.addAll(index, c);
	}

	public void clear()
	{
		currentItem = null;
		pageSize = 0;
		currentPage = 0;
		super.clear();
	}

	public IRecordObject remove(int index)
	{
		currentItem = null;
		return super.remove(index);
	}

	public boolean remove(Object obj)
	{
		boolean rc = super.remove(obj);
		if (rc)
			currentItem = null;
		return rc;
	}

	public IRecordObject set(int index, IRecordObject obj)
	{
		currentItem = obj;
		idxList.add(currentItem.getOid());
		return super.set(index, obj);
	}

	/**
	 * @return pageSize ߂܂B
	 */
	public int getPageSize()
	{
		return pageSize;
	}

	/**
	 * @param pageSize
	 *            pageSize ݒB
	 */
	public void setPageSize(int pageSize)
	{
		this.pageSize = pageSize;
	}

	/**
	 * @return idxList ߂܂B
	 */
	public IndexList getIdxList()
	{
		return idxList;
	}
}
