/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.log;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;

public class AuditLog
{
	protected String userId="";
	protected String httpHeaderUserAgent="";
	protected String strCmd="";
	protected String strFc="";
	protected String strSubmit="";

	protected static final AuditLog theSingleton=new AuditLog();
	protected static final String logFormat="%1$s,%2$s,%3$s/%4$s";//user-id,UserAgent,cmd,fc
	protected static final String logFormatPlusSubmit=logFormat + "/%5$s";//user-id,UserAgent,cmd,fc,submit
	protected static final String logAuthFail="Authentication Failed:%1$s,%2$s";

	public static AuditLog getInstance()
	{
		return theSingleton;
	}

	public void output(boolean authSuccess) throws HandleException
	{
		if (strCmd==null) strCmd="Menu";
		if (strCmd.length()==0) strCmd="Menu";
		String outputStr="";
		try {
			outputStr = selectLogFormat(authSuccess);
		}
		catch (Exception e) {
			Log.fatal("PANIC:can't create audit-log formatted text.",e);
			outputStr = "userId="+userId+",UserAgent="+httpHeaderUserAgent+",cmd/fc="+strCmd+"/"+strFc;
		}
		Log.info(outputStr);
	}

	private String selectLogFormat(boolean authSuccess)
	{
		String outputStr;
		if (authSuccess) {
			if (this.strSubmit!=null) {
				outputStr = String.format(logFormatPlusSubmit,userId, httpHeaderUserAgent,strCmd,strFc,getDisplaySubmitValue());
			} else {
				outputStr = String.format(logFormat,userId, httpHeaderUserAgent,strCmd,strFc);
			}
		}
		else {
			outputStr = String.format(logAuthFail,userId, httpHeaderUserAgent);
		}

		if (outputStr.endsWith("/")) {
			outputStr = outputStr.substring(0, outputStr.length()-1);
		}

		return outputStr;
	}

	public String getUserId()
	{
		return userId;
	}

	public void setUserId(String userId)
	{
		this.userId = userId;
	}

	public String getHttpHeaderUserAgent()
	{
		return httpHeaderUserAgent;
	}

	public void setHttpHeaderUserAgent(String httpHeaderUserAgent)
	{
		this.httpHeaderUserAgent = httpHeaderUserAgent;
	}

	public String getStrCmd()
	{
		return strCmd;
	}

	public void setStrCmd(String strCmd)
	{
		this.strCmd = strCmd;
	}

	public String getStrFc()
	{
		return strFc;
	}

	public void setStrFc(String strFc)
	{
		this.strFc = strFc;
	}

	public String getStrSubmit()
	{
		return strSubmit;
	}

	public void setStrSubmit(String strSubmit)
	{
		this.strSubmit = strSubmit;
	}

	private String getDisplaySubmitValue() {
		String value = "";

		SubmitType type = SubmitType.get(this.strSubmit);

		if (type!=SubmitType.UNKNOWN){
			value = type.toString();
		}
		return value;
	}
}
