/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.helpers;

import jp.co.connectone.store.pim.AttachmentDTO;
public class WebAttachmentParseHelper 
{
	protected AttachmentDTO dto;

	public WebAttachmentParseHelper(AttachmentDTO dto) 
	{
		super();
		this.dto = dto;
	}

	public AttachmentDTO getDto()
	{
		return dto;
	}

	public void setDto(AttachmentDTO dto)
	{
		this.dto = dto;
	}
	
	
	/**
	 * @return fileBody ߂܂B
	 */
	public byte[] getFileBody() {
		return dto.getFileBody();
	}
	/**
	 * @param fileBody fileBody ݒB
	 */
	public void setFileBody(byte[] fileBody) {
		dto.setFileBody(fileBody);
	}
	/**
	 * @return fileName ߂܂B
	 */
	public String getFileName() {
		return dto.getFileName();
	}
	/**
	 * @param fileName fileName ݒB
	 */
	public void setFileName(String fileName) {
		dto.setFileName(fileName);
	}
	/* added module */
	protected WebParserAggregationBase extention = new WebParserAggregationBase();

	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage()
	{
		return extention.getCurrentPage();
	}

	public int getPrevPage()
	{
		return extention.getPrevPage();
	}

	public int getNextPage()
	{
		return extention.getNextPage();
	}

	/**
	 * @param currentPage
	 *            currentPage ݒB
	 */
	public void setCurrentPage(int currentPage)
	{
		extention.setCurrentPage(currentPage);
	}
}
