/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.helpers;

import java.lang.reflect.Constructor;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.AttachmentDTO;
import java.io.*;

@SuppressWarnings("unchecked")
public class DhkWebAttachmentParseHelper extends WebAttachmentParseHelper
{
	private String absolutePath=".";
	private static final String propName="/javacat.properties";
	private static boolean propWritten=false;
	private String convertedText=null;
	
	private void writePropFile()
	{
		propWritten = true;
		File tmp = new File(absolutePath+propName);
		BufferedWriter writer = null;
		try {
			tmp.createNewFile();
			writer = new BufferedWriter(new FileWriter(tmp));
	        String lines[] = {
       		"#",
	        "# << JavaCat libconf file >>",
	        "#",
	        "# (C) Copyright Dehenken Limited. 2000-2005",
	        "# All rights reserved.",
	        "#",
	        "MAX_FILE_SIZE=41943040",
	        "MAX_BUF_SIZE=1048576",
	        "LOG_FILE=./javacat.log",
	        "DIRECTORY=./dhklib",
	        "HTML_HEAD=html/%s.head",
	        "HTML_FOOT=html/%s.foot",
	        "XML_HEAD=xml/%s.head",
	        "XML_FOOT=xml/%s.foot"
	        };
	        String s = absolutePath;
	        try {
	        	s = s.replaceAll("\\\\","/");
	        }
	        catch (Exception e) {
	        	if (e != null) {
	        		Log.error("",e);
	        	}
	        }
	        lines[8] = lines[8].replaceAll("\\./",s+"/");
	        lines[9] = lines[9].replaceAll("\\./",s+"/");
	        for (int i=0;i<lines.length;i++) {
	            writer.write(lines[i], 0, lines[i].length());
	            writer.newLine();
	        }
		}
		catch (IOException e){}
		finally {
	        try {
	            if (writer != null) {
	                writer.flush();
	                writer.close();
	            }
	        } catch (Exception e) {
	        }
	    }
		
	}
	
	public DhkWebAttachmentParseHelper(AttachmentDTO dto)
	{
		super(dto);
	}
	
	private String convert()
	{
		String rc = "eLXgϊɎs܂B";
		byte[] b = dto.getFileBody();

		try {
	        
			Object[] param = new Object[2];
			param[0] = b;
			param[1] = new Integer(b.length);
			Class[] paramTypes = {byte[].class,int.class};
			Constructor c = Class.forName("jp.co.dehenken.javacat.Dtf.Dhktf").getConstructor(paramTypes);
			Object conv = c.newInstance(param);// Dhktf i_Dhktf = new Dhktf(byte[],int);
			if (!propWritten) {
				writePropFile();
			}
			Object[] param2 = new Object[1];
			param2[0] = absolutePath + propName;
			Class[] paramTypes2 = {String.class};
			Class dhktf = conv.getClass();
			dhktf.getMethod("init", paramTypes2).invoke(conv, param2);//i_Dhktf.init(propertyFileName);
			dhktf.getMethod("open").invoke(conv);//int fsize = i_Dhktf.open();
			Object[] param3 = new Object[3];
			param3[0] = new Integer(0);
			param3[1] = new Integer('u');
			param3[2] = new Integer(1);
			Class[] paramTypes3 = {int.class,int.class,int.class};
			Integer type = (Integer)dhktf.getMethod("detect_type", paramTypes3).invoke(conv,param3);//int type = i_Dhktf.detect_type(0, 'u', 1);
	        Integer usz = (Integer)dhktf.getMethod("getSize").invoke(conv);//int usaz = i_Dhktf.getSize();

	        char[] cdata = null;
	        if ((type.intValue() > 0) && (usz.intValue() > 0)) {
	        	Class[] paramTypes4 = {int.class};
	        	Object[] param4 = new Object[1];
	        	param4[0] = type;
                Integer ret = (Integer)dhktf.getMethod("read_text",paramTypes4).invoke(conv, param4);//int ret = i_Dhktf.read_text(type);
	            if (ret.intValue() == 0) {	// 
	                cdata = (char[])dhktf.getMethod("getData").invoke(conv);//cdata = i_Dhktf.getData();
	            }
	        }
	        dhktf.getMethod("close").invoke(conv);//i_Dhktf.close();
	        if (cdata != null) {
	        	rc = new String(cdata);
	        }
		}
		catch (Exception e) {
			Log.error("",e);
		}
		return rc;
		
	}
	
	public String getConvertedText()
	{
		if (convertedText==null) {
			convertedText = convert();
		}
		String rc = convertedText;
		if (rc == null) return rc;
		rc = extention.pagingString(rc);
		rc = extention.formatBody(rc);
		return rc;
	}

	public String getAbsolutePath()
	{
		return absolutePath;
	}

	public void setAbsolutePath(String path)
	{
		absolutePath = path;
	}

	/**
	 * @return bodyLength ߂܂B
	 */
	public int getBodyLength()
	{
		return extention.getBodyLength();
	}

	/**
	 * @param bodyLength
	 *            bodyLength ݒB
	 */
	public void setBodyLength(int bodyLength)
	{
		extention.setBodyLength(bodyLength);
	}

	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage()
	{
		return extention.getCurrentPage();
	}

	public int getPrevPage()
	{
		return extention.getPrevPage();
	}

	public int getNextPage()
	{
		return extention.getNextPage();
	}

	public int getLastPage()
	{
		return extention.getLastPage(convertedText);
	}

	/**
	 * @param currentPage
	 *            currentPage ݒB
	 */
	public void setCurrentPage(int currentPage)
	{
		extention.setCurrentPage(currentPage);
	}

}
