/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.filters;

import java.io.IOException;
import jp.co.connectone.exception.C1V2FilterException;
import jp.co.connectone.log.Log;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionTimeoutFilter extends BaseFilter implements Filter {
	public void doFilter(ServletRequest request, ServletResponse response,
		FilterChain chain) throws IOException, ServletException{
		HttpSession session = ((HttpServletRequest)request).getSession(false);
		HttpServletRequest hRequest = (HttpServletRequest)request;
		String uri = hRequest.getRequestURI().toString();
		String root = hRequest.getContextPath();
		Log.trace("SessionTimeoutFilter:uri="+uri+"/root="+root+"/");
		Log.trace("SessionTimeoutFilter:session="+session);
		if (!uri.equalsIgnoreCase(root + "/") && session == null) {		
			Log.info("session timeout.set FilterEception");
			request.setAttribute("FilterException", (Object)(new C1V2FilterException()));
		}
		chain.doFilter(request, response);
	}
}
