/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.commandenv;
import java.io.Serializable;
import java.util.*;

import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.log.Log;

/**
 * @author amanot
 *
 */
public class CommandEnvSet implements Cloneable,Serializable
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	int sequenceNumber;
	boolean pushed=false;
	HashMap<String,Object> elements;
	private static Properties prop=null;
	private static List<String> hiddenEnvList=new Vector<String>();
	
	/**
	 * 
	 */
	public CommandEnvSet()
	{
		elements = new HashMap<String,Object>();
		sequenceNumber = (int) Math.random() * 10000;
		if (prop==null) {
			try {
				prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.webproxy.ui.logic.CommandEnvSet");
			}
			catch (DataNotFound dnf) {
				Log.error("",dnf);
			}
			catch (Exception e) {
				Log.fatal("",e);
			}
		}
		if (prop != null) {
			String hiddenFieldNames = prop.getProperty("hiddenFieldNames");
			if (hiddenFieldNames != null) {
				String[] arrayFieldNames = hiddenFieldNames.split(",");
				hiddenEnvList = Arrays.asList(arrayFieldNames);
			}
		}
	}
	
	public synchronized void put(String key,Object value)
	{
		elements.put(key,value);
	}
	
	public synchronized Object get(String key)
	{
		return elements.get(key);
	}
	
	public synchronized String getString(String key)
	{
		return (String)elements.get(key);
	}

	public Object clone()
	{
		CommandEnvSet newObj = new CommandEnvSet();
		
		Iterator<String> keys = elements.keySet().iterator();
		
		while (keys.hasNext()) {
			String key = keys.next();
			Object value = elements.get(key);
			Object logValue = value;
			if (hiddenEnvList.contains(key)) {
				logValue = "XXXX";
			}
Log.debug("CommandEnvSet.clone:copying "+key+"("+logValue+")");
			newObj.elements.put(key,value);
		}
		return newObj;

	}

	public void copyNewElements(CommandEnvSet src)
	{
		Iterator<String> keys = src.elements.keySet().iterator();
		
		while (keys.hasNext()) {
			String key = keys.next();
			Object value = src.elements.get(key);
			Object logValue = value;
			if ("p".equals(key)) {
				logValue = "XXXX";
			}
Log.debug("CommandEnvSet.copyNewElements:copying "+key+"("+logValue+")");
			this.elements.put(key,value);
		}
		
	}
	
	Object getEnvElement(String name)
	{
		return elements.get(name);
	}
	
	void setEnvElement(String name,Object value)
	{
		elements.put(name,value);
	}
	
	public String getKey()
	{
		return Integer.toString(this.hashCode()) + sequenceNumber;
	}

	/**
	 * @return pushed ߂܂B
	 */
	public boolean isPushed()
	{
		return pushed;
	}

	/**
	 * @param pushed ݒ肷 pushedB
	 */
	public void setPushed(boolean pushed)
	{
		this.pushed = pushed;
	}
}
