package jp.co.connectone.webproxy.ui.action;

import java.util.Hashtable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exm.IExM;
import jp.co.connectone.log.Log;
import jp.co.connectone.user.*;
import jp.co.connectone.webapps.commandenv.CommandEnvSet;
import jp.co.connectone.webapps.user.c1v2user;

import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class OnetimePasswordLoginAction extends AuthAction {

	protected void setArgs(CommandEnvSet env,DynaActionForm form)
	{
		String tmp;
		env.put("c","c1v2");
		tmp = form.getString("u");
		if (tmp != null) {
			if (tmp.length()>0) {
				env.put("u",tmp);
				env.put("ru",tmp);
				env.put("e_u",tmp);
			}
		}
		tmp = form.getString("w");
		if (tmp != null) {
			if (tmp.length()>0) {
				env.put("e_u",tmp);
			}
		}
		env.put("p","oppass");
		env.put("rp","oppass");
		env.put("cmd","pass");
		super.setArgs(env,form);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.AuthAction#actionLogic(jp.co.connectone.webproxy.ui.logic.CommandEnvSet, org.apache.struts.action.ActionMapping, org.apache.struts.action.DynaActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward actionLogic(CommandEnvSet env, ActionMapping mapping, DynaActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		String IPAddress = request.getRemoteAddr();
Log.debug("OnetimePasswordLoginAction:remote IP address = "+IPAddress);
		if (ctrl.isValidIPAddress(IPAddress)) return mapping.findForward("success");
		return mapping.findForward("logout");
	}
	
	protected boolean doAuth(CommandEnvSet env) throws Exception
	{
		IExM exm = (IExM)env.get("exm");
		String userID=null;
		String password=null;
		String companyCode=null;
		companyCode = env.getString("c");
		userID = env.getString("u");
		password = env.getString("p");
		String ex_id = env.getString("e_u");
		String ex_pass = "";
		String passMask = "******************************";
		if (password.length()<passMask.length()) {
			passMask = passMask.substring(0,password.length());
		}
Log.debug("doAuth:c="+companyCode+";u="+userID+";p="+passMask);
		if (companyCode==null) return false;
		if (userID==null) return false;
		if (password==null) return false;
		Hashtable authParam = new Hashtable();
		authParam.put("password",password);
		exm.authUser(userID, authParam);
		boolean rc=true;
		boolean userNotExist = false;
		try {
			exm.getUser();
		}
		catch (HandleException he) {
			userNotExist=true;
		}
		if (userNotExist) {
			c1v2user newUser = new c1v2user();
			newUser.setKey(new BasicUserKey(String.class.getName(),userID));
			newUser.setPassword(password);
			try {
				ctrl.addAccountData(exm,newUser,"c1v2s2Mail",ex_id,ex_pass);
				ctrl.addAccountData(exm,newUser,"c1v2s2Sche",ex_id,ex_pass);
				ctrl.addAccountData(exm,newUser,"c1v2s2Addr",ex_id,ex_pass);
				ctrl.addAccountData(exm,newUser,"c1v2s2Todo",ex_id,ex_pass);
				ctrl.addAccountData(exm,newUser,"c1v2s2Memo",ex_id,ex_pass);
			}
			catch (Error e) {
				Log.error("",e);
			}		
			ctrl.addUser(exm, newUser);
			rc = false;
		}
		return rc;
	}
	

}
