/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.common;

import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jp.co.connectone.common.ActiveActiveServerToolBaseImpl;
import jp.co.connectone.exception.NoSuchRights;

public class ADTool
extends ActiveActiveServerToolBaseImpl {
    private static boolean toggle = false;
    private int toggleCount;
    private DirContext ctx = null;

    @Override
    public int getToggleCount() {
        return this.toggleCount;
    }

    @Override
    public void setToggleCount(int toggleCount) {
        this.toggleCount = toggleCount;
    }

    @Override
    public boolean isToggle() {
        return toggle;
    }

    @Override
    public void setToggle(boolean toggle) {
        ADTool.toggle = toggle;
    }

    public NamingEnumeration<SearchResult> getExchServerContext(String serverName, String serverName2) throws Exception {
        NamingEnumeration<SearchResult> rootDSN = this.getRootDSE(serverName, serverName2);
        if (rootDSN == null) {
            return null;
        }
        String sn = this.getServerToConnect(serverName, serverName2);
        SearchResult aResult = (SearchResult)rootDSN.nextElement();
        String contextLabel = aResult.getAttributes().get("configurationNamingContext").get(0).toString();
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + sn + "/" + contextLabel);
        env.put("java.naming.referral", "throw");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (CommunicationException ce) {
            if (this.toggleOn()) {
                return this.getExchServerContext(serverName, serverName2);
            }
            throw ce;
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = this.ctx.search("", "objectCategory=msExchExchangeServer", constraints);
        this.clearCount();
        return results;
    }

    public NamingEnumeration<SearchResult> getRootDSE(String serverName, String serverName2) throws Exception {
        String sn = this.getServerToConnect(serverName, serverName2);
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + sn + "/");
        env.put("java.naming.referral", "throw");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (CommunicationException ce) {
            if (this.toggleOn()) {
                return this.getRootDSE(serverName, serverName2);
            }
            throw ce;
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        NamingEnumeration<SearchResult> results = this.ctx.search("", "objectclass=*", constraints);
        this.clearCount();
        return results;
    }

    public NamingEnumeration<SearchResult> getUserDatas(String userID, String password, String serverName, String serverName2, String domain, String whereStr) throws Exception {
        NamingEnumeration<SearchResult> retStr = null;
        if (userID == null) {
            return retStr;
        }
        if (password == null) {
            throw new NoSuchRights("pussword must not be null.");
        }
        if (password.length() == 0) {
            throw new NoSuchRights("pussword must not be null.");
        }
        if (password.trim().length() == 0) {
            throw new NoSuchRights("pussword must not be null.");
        }
        String sn = this.getServerToConnect(serverName, serverName2);
        Properties env = new Properties();
        env.put("java.naming.security.principal", String.valueOf(userID) + "@" + domain);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + sn + "/");
        env.put("java.naming.referral", "follow");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (CommunicationException ce) {
            if (this.toggleOn()) {
                return this.getUserDatas(userID, password, serverName, serverName2, domain, whereStr);
            }
            throw ce;
        }
        SearchControls constraints = new SearchControls();
        constraints.setTimeLimit(10000);
        constraints.setSearchScope(2);
        String searchDomain = domain.replaceAll("\\.", ",dc=");
        String searchStr = "(& (mailnickname=*) (| (&(objectCategory=person)(objectClass=user)(!(homeMDB=*))(!(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=user)(|(homeMDB=*)(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=contact))(objectCategory=group)(objectCategory=publicFolder) )" + whereStr + ")";
        retStr = this.ctx.search("dc=" + searchDomain, searchStr, constraints);
        this.ctx.close();
        this.clearCount();
        return retStr;
    }

    public NamingEnumeration<SearchResult> getUserDetail(String userID, String password, String serverName, String serverName2, String domain) throws Exception {
        NamingEnumeration<SearchResult> retStr = null;
        if (userID == null) {
            return retStr;
        }
        if (password == null) {
            throw new NoSuchRights("pussword must not be null.");
        }
        if (password.length() == 0) {
            throw new NoSuchRights("pussword must not be null.");
        }
        if (password.trim().length() == 0) {
            throw new NoSuchRights("pussword must not be null.");
        }
        String sn = this.getServerToConnect(serverName, serverName2);
        String searchDomain = domain.replaceAll("\\.", ",dc=");
        Properties env = new Properties();
        env.put("java.naming.security.principal", String.valueOf(userID) + "@" + domain);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + sn + "/");
        env.put("java.naming.referral", "follow");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (CommunicationException ce) {
            if (this.toggleOn()) {
                return this.getUserDetail(userID, password, serverName, serverName2, domain);
            }
            throw ce;
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        retStr = this.ctx.search("dc=" + searchDomain, "sAMAccountName=" + userID, constraints);
        this.clearCount();
        return retStr;
    }

    public NamingEnumeration<SearchResult> getOtherUserDetail(String idToSee, String userID, String password, String serverName, String serverName2, String domain) throws Exception {
        NamingEnumeration<SearchResult> retStr = null;
        if (userID == null) {
            return retStr;
        }
        if (password == null) {
            throw new NoSuchRights("pussword must not be null.");
        }
        if (password.length() == 0) {
            throw new NoSuchRights("pussword must not be null.");
        }
        if (password.trim().length() == 0) {
            throw new NoSuchRights("pussword must not be null.");
        }
        String sn = this.getServerToConnect(serverName, serverName2);
        String searchDomain = domain.replaceAll("\\.", ",dc=");
        Properties env = new Properties();
        env.put("java.naming.security.principal", String.valueOf(userID) + "@" + domain);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + sn + "/");
        env.put("java.naming.referral", "follow");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (CommunicationException ce) {
            if (this.toggleOn()) {
                return this.getOtherUserDetail(idToSee, userID, password, serverName, serverName2, domain);
            }
            throw ce;
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setCountLimit(1L);
        retStr = this.ctx.search("dc=" + searchDomain, "sAMAccountName=" + idToSee, constraints);
        this.clearCount();
        return retStr;
    }
}

