/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.smtp.store;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.co.connectone.eai.pop3.log.LogAspect;
import jp.co.connectone.eai.smtp.store.SmtpServiceInfo;
import jp.co.connectone.eai.smtp.user.SmtpAccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.client.AttachmentDataSource;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.BasicMailDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.user.IAccountData;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class SmtpMailStoreImpl
implements IMailStore {
    private String serverAddress;
    public static final IStoreID storeID;
    public static final String storeName = "Smtp Mail Store";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        SmtpMailStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(SmtpMailStoreImpl.class.getName());
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public static SmtpMailStoreImpl getInstance() {
        return new SmtpMailStoreImpl();
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new SmtpServiceInfo(storeID, storeName);
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        SmtpServiceInfo info = new SmtpServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        return info;
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public String getName() throws Exception {
        return storeName;
    }

    public void deleteMail(IAccountData arg0, IObjectIndex arg1) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support deleteMail.");
    }

    public IMailDTO[] getHeaders(IAccountData arg0, ISearchDestination arg1) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getHeaders.");
    }

    public IMailDTO[] getHeadersByDate(IAccountData arg0, ISearchDestination arg1, Date arg2) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getHeadersByDate.");
    }

    public IMailDTO getMail(IAccountData arg0, ISearchDestination arg1, IObjectIndex arg2) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getMail.");
    }

    public FolderMetadata[] getMailFolders(IAccountData arg0, ISearchDestination arg1) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getMailFolders.");
    }

    public IMailDTO[] getMailsByDate(IAccountData arg0, ISearchDestination arg1, Date arg2) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getMailsByDate.");
    }

    public IMailDTO[] getSentMails(IAccountData arg0) throws ServerDown, HandleException {
        throw new HandleException("Smtp Mail Store does not support getSentMails.");
    }

    public IMailDTO[] getSentMailsByDate(IAccountData arg0, Date arg1) throws ServerDown, HandleException {
        throw new HandleException("Smtp Mail Store does not support getSentMailsByDate.");
    }

    public IObjectIndex[] getUIDLs(IAccountData arg0, ISearchDestination arg1) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getUIDLs.");
    }

    public IObjectIndex[] getUIDLsByDate(IAccountData arg0, ISearchDestination arg1, Date arg2) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getUIDLsByDate.");
    }

    public IObjectIndex sendMail(IAccountData acc, IMailDTO dto) throws NoSuchRights, ServerDown, IncorrectData, HandleException {
        if (!(acc instanceof SmtpAccountData)) {
            throw new IncorrectData("account data type must be SmtpAccountData");
        }
        this.setServerAddress(acc.getServiceInfo().getServerAddress());
        MimeMessage msg = this.populateMail(dto);
        try {
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServerDown("got error (" + e.getMessage() + ") from transport, assume server doesn't accept this machine as mail sender");
        }
        return null;
    }

    public void delete(IAccountData arg0, ISearchDestination arg1, IObjectIndex arg2) throws Exception {
        throw new HandleException("Smtp Mail Store does not support delete.");
    }

    public IRecordObject[] getAllDatas(IAccountData arg0, ISearchDestination arg1) throws Exception {
        throw new HandleException("Smtp Mail Store does not support getAllDatas.");
    }

    public IRecordObject getFolderIndexFromString(String arg0) throws IncorrectData {
        throw new IncorrectData("Smtp Mail Store does not support getFolderIndexFromString.");
    }

    public FolderMetadata[] getFolderList(IAccountData arg0, ISearchDestination arg1) throws Exception {
        throw new HandleException("Smtp Mail Store does not support getFolderList.");
    }

    public ISearchDestination getPresetDestination(IAccountData arg0, int arg2) throws IncorrectData, HandleException {
        throw new HandleException("Smtp Mail Store does not support getPresetDestination.");
    }

    public IRecordObject read(IAccountData arg0, ISearchDestination arg1, IObjectIndex arg2) throws Exception {
        throw new HandleException("Smtp Mail Store does not support read.");
    }

    public IRecordObject[] search(IAccountData arg0, ISearchFormula arg1) throws Exception {
        throw new HandleException("Smtp Mail Store does not support search.");
    }

    public IRecordObject[] searchByDate(IAccountData arg0, ISearchDestination arg1, Date arg2) throws Exception {
        throw new HandleException("Smtp Mail Store does not support searchByDate.");
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject ro) throws Exception {
        if (!(ro instanceof BasicMailDTO)) {
            throw new IncorrectData("record object type must be BasicMailDTO");
        }
        BasicMailDTO dto = (BasicMailDTO)ro;
        return this.sendMail(acc, (IMailDTO)dto);
    }

    private Address populateAddress(MailAddress src) {
        InternetAddress add = null;
        if (src == null) {
            return add;
        }
        try {
            String address = src.getAddressPart();
            String name = src.getNamePart();
            String raw = src.getRawAddress();
            add = address.equalsIgnoreCase(raw) ? new InternetAddress(address, name, "ISO-2022-JP") : new InternetAddress(raw);
        }
        catch (UnsupportedEncodingException ue) {
            ue.printStackTrace();
        }
        catch (AddressException ae) {
            ae.printStackTrace();
        }
        return add;
    }

    private MimeMessage populateMail(IMailDTO dto) throws NoSuchRights, HandleException, IncorrectData {
        MimeMessage mail = this.getMessageInstance();
        HeaderDTO header = dto.getHeader();
        try {
            MailAddress[] bccAddress;
            MailAddress[] ccAddress;
            MailAddress[] toAddress;
            mail.setSentDate(new Date());
            mail.setSubject(header.getHeaderSubject(), "ISO-2022-JP");
            mail.setFrom(this.populateAddress(header.getHeaderFrom()));
            if (dto.getHeader().getHeaderReplyTo() != null) {
                MailAddress replyTo = dto.getHeader().getHeaderReplyTo();
                String string = "replyTo:" + replyTo;
                SmtpMailStoreImpl.trace_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
                Address[] replyAddress = new Address[]{this.populateAddress(replyTo)};
                mail.setReplyTo(replyAddress);
            }
            if ((toAddress = header.getHeaderTo()) != null && toAddress.length > 0) {
                Address[] to = new Address[toAddress.length];
                int i = 0;
                while (i < to.length) {
                    to[i] = this.populateAddress(toAddress[i]);
                    ++i;
                }
                mail.setRecipients(Message.RecipientType.TO, to);
            }
            if ((ccAddress = header.getHeaderCC()) != null && ccAddress.length > 0) {
                Address[] cc = new Address[ccAddress.length];
                int i = 0;
                while (i < cc.length) {
                    cc[i] = this.populateAddress(ccAddress[i]);
                    ++i;
                }
                mail.setRecipients(Message.RecipientType.CC, cc);
            }
            if ((bccAddress = header.getHeaderBCC()) != null && bccAddress.length > 0) {
                Address[] bcc = new Address[bccAddress.length];
                int i = 0;
                while (i < bcc.length) {
                    bcc[i] = this.populateAddress(bccAddress[i]);
                    ++i;
                }
                mail.setRecipients(Message.RecipientType.BCC, bcc);
            }
            if (dto.getNumberOfAttachments() > 0) {
                String string = "having attachments";
                SmtpMailStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
                MimeMultipart part1 = new MimeMultipart();
                MimeBodyPart body1 = new MimeBodyPart();
                body1.setText(dto.getBody(), "ISO-2022-JP");
                part1.addBodyPart((BodyPart)body1);
                int i = 0;
                while (i < dto.getNumberOfAttachments()) {
                    AttachmentDTO att = dto.getAttachment(i);
                    MimeBodyPart attach = new MimeBodyPart();
                    attach.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(att)));
                    String attName = att.getFileName();
                    try {
                        attName = MimeUtility.encodeText((String)attName, (String)"ISO-2022-JP", (String)"B");
                    }
                    catch (Exception e) {
                        Log.error((String)"Exception on encoding Japanese Filename", (Throwable)e);
                        e.printStackTrace();
                    }
                    String string2 = "attName=" + attName;
                    SmtpMailStoreImpl.trace_aroundBody5$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_2);
                    attach.setFileName(attName);
                    part1.addBodyPart((BodyPart)attach);
                    ++i;
                }
                mail.setContent((Multipart)part1);
            } else {
                try {
                    mail.setText(dto.getBody());
                }
                catch (Exception e) {
                    Log.error((String)"Exception on encoding Japanese Body", (Throwable)e);
                    e.printStackTrace();
                }
                mail.setHeader("Content-transfer-encoding", "base64");
            }
            mail.saveChanges();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return mail;
    }

    protected MimeMessage getMessageInstance() {
        Properties env = new Properties();
        env.put("mail.smtp.host", this.getServerAddress());
        Session session = Session.getInstance((Properties)env);
        MimeMessage msg = new MimeMessage(session);
        return msg;
    }

    private static final /* synthetic */ void trace_aroundBody0(SmtpMailStoreImpl smtpMailStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody1$advice(SmtpMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(SmtpMailStoreImpl smtpMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(SmtpMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody4(SmtpMailStoreImpl smtpMailStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody5$advice(SmtpMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SmtpMailStoreImpl.java", Class.forName("jp.co.connectone.eai.smtp.store.SmtpMailStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 219);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 255);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 275);
    }
}

