/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.pop3.socket;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Properties;
import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.eai.pop3.exception.ServerCommunicationException;
import jp.co.connectone.eai.pop3.log.LogAspect;
import jp.co.connectone.eai.pop3.socket.ISocketCommand;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.log.Log;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class BaseSocketImpl {
    protected Socket clientSocket = null;
    protected BufferedReader reader = null;
    protected BufferedWriter writer = null;
    protected int defaultPort = 0;
    protected int connection_timeout = 3000;
    protected int transaction_timeout = 30000;
    private Properties prop = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public static BaseSocketImpl getInstance() throws HandleException {
        throw new HandleException("don't call BaseSocketImpl.getInstance() directly. use sub-class.");
    }

    public void connect(String server1, String server2) throws HandleException {
        this.connect(server1, server2, this.defaultPort);
    }

    public void connect(String server1, String server2, int port) throws HandleException {
        if (server1 == null) {
            throw new IncorrectData("server must not be null.");
        }
        if (port <= 0) {
            throw new IncorrectData("port number must be greater than 0.");
        }
        if (this.prop == null) {
            try {
                this.prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.eai.pop3.socket.BaseSocketImpl");
                this.connection_timeout = Integer.parseInt(this.prop.getProperty("connection_timeout_sec", "3")) * 1000;
                this.transaction_timeout = Integer.parseInt(this.prop.getProperty("connection_timeout_sec", "30")) * 1000;
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
        }
        try {
            this.clientSocket = new Socket();
            InetSocketAddress addr = new InetSocketAddress(server1, port);
            this.clientSocket.connect(addr, this.connection_timeout);
            this.clientSocket.setSoTimeout(this.transaction_timeout);
            this.reader = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
        }
        catch (IOException ioe) {
            Log.debug((String)(String.valueOf(server1) + " connection failed.(" + ioe.getMessage() + ") try server2..."), (Throwable)ioe);
            if (server2 != null && !"".equals(server2)) {
                try {
                    this.clientSocket = new Socket();
                    InetSocketAddress addr = new InetSocketAddress(server2, port);
                    this.clientSocket.connect(addr, this.connection_timeout);
                    this.clientSocket.setSoTimeout(this.transaction_timeout);
                    this.reader = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
                }
                catch (IOException ioe2) {
                    Log.error((String)(String.valueOf(server2) + " connection failed.(" + ioe2.getMessage() + ")"), (Throwable)ioe2);
                    this.disconnect();
                    throw new ServerDown(String.valueOf(server2) + " connection failed.(" + ioe2.getMessage() + ")");
                }
            }
            this.disconnect();
            throw new ServerDown(String.valueOf(server1) + " connection failed.(" + ioe.getMessage() + ")");
        }
    }

    public void disconnect() {
        if (this.clientSocket == null) {
            return;
        }
        try {
            try {
                if (!this.clientSocket.isClosed()) {
                    this.clientSocket.close();
                }
            }
            catch (IOException e) {
                Log.error((String)"error on Socket close.", (Throwable)e);
                this.clientSocket = null;
                this.reader = null;
                this.writer = null;
            }
        }
        finally {
            this.clientSocket = null;
            this.reader = null;
            this.writer = null;
        }
    }

    public boolean isClosed() {
        return this.clientSocket == null || this.clientSocket.isClosed();
    }

    protected String transaction(ISocketCommand cmd) throws IOException {
        return this.transaction(cmd, false);
    }

    protected String transaction(ISocketCommand cmd, boolean isMultiLine) throws IOException {
        String cmdStr = String.valueOf(cmd.getCmdWithParams()) + "\r\n";
        String string = "c1:" + cmdStr;
        BaseSocketImpl.trace_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        try {
            this.writer.write(cmdStr);
            this.writer.flush();
        }
        catch (SocketTimeoutException e) {
            Log.debug((String)"Socket.writing, connection timeout.", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            Log.debug((String)"error on Socket.writing.", (Throwable)e);
            throw e;
        }
        try {
            String line = this.reader.readLine();
            if (line == null) {
                String string2 = "readLine returns null.";
                BaseSocketImpl.debug_aroundBody3$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_1);
                throw new ServerCommunicationException("POP connection is not alive.");
            }
            if (line.startsWith("+OK")) {
                if (isMultiLine) {
                    String string3 = "multi line.";
                    BaseSocketImpl.trace_aroundBody5$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_2);
                    line = this.getMultiLine(line);
                } else {
                    String string4 = "single line.";
                    BaseSocketImpl.trace_aroundBody7$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_3);
                }
            }
            String string5 = "pop3:" + line;
            BaseSocketImpl.trace_aroundBody9$advice(this, string5, LogAspect.aspectOf(), string5, null, ajc$tjp_4);
            return line;
        }
        catch (SocketTimeoutException e) {
            Log.debug((String)"Socket.reading, connection timeout.", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            Log.debug((String)"error on Socket.reading.", (Throwable)e);
            throw e;
        }
    }

    protected abstract boolean isTerminate(String var1);

    private String getMultiLine(String line) throws IOException {
        while (true) {
            String addline;
            if ((addline = this.reader.readLine()) == null) {
                String string = "readLine returns null.";
                BaseSocketImpl.debug_aroundBody11$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_5);
                throw new ServerCommunicationException("POP connection is not alive.");
            }
            if (this.isTerminate(addline)) break;
            line = String.valueOf(line) + "\n" + addline;
        }
        return line;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    static {
        BaseSocketImpl.ajc$preClinit();
    }

    private static final /* synthetic */ void trace_aroundBody0(BaseSocketImpl baseSocketImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody1$advice(BaseSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(BaseSocketImpl baseSocketImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(BaseSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody4(BaseSocketImpl baseSocketImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody5$advice(BaseSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody6(BaseSocketImpl baseSocketImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody7$advice(BaseSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody8(BaseSocketImpl baseSocketImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody9$advice(BaseSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(BaseSocketImpl baseSocketImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(BaseSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BaseSocketImpl.java", Class.forName("jp.co.connectone.eai.pop3.socket.BaseSocketImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 118);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 134);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 139);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 143);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 146);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 166);
    }
}

