/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.notes.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import jp.co.connectone.eai.notes.log.LogAspect;
import jp.co.connectone.eai.notes.store.EAINotesBase;
import jp.co.connectone.eai.notes.store.NotesFolderIndex;
import jp.co.connectone.eai.notes.store.NotesObjectIndex;
import jp.co.connectone.eai.notes.store.NotesServiceInfo;
import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.DeleteFailed;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.BasicMailDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.user.IAccountData;
import lotus.domino.DateRange;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class NotesMailStoreImpl
extends EAINotesBase
implements IMailStore {
    public static final IStoreID storeID;
    public static final String storeName = "Notes Mail Store";
    public static final String DEFAULT_NOTES_INBOX_NAME = "($Inbox)";
    public static final String DEFAULT_NOTES_SENTBOX_NAME = "($Sent)";
    private IFolderIndex inboxElement = new NotesFolderIndex("($Inbox)");
    private IFolderIndex sentboxElement = new NotesFolderIndex("($Sent)");
    protected static NotesMailStoreImpl ms_objNotesImpl;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        NotesMailStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(NotesMailStoreImpl.class.getName());
        ms_objNotesImpl = null;
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        NotesServiceInfo info = new NotesServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        String serverAddress2 = (String)h.get("server2");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        if (serverAddress2 != null) {
            info.setServerAddress2(serverAddress2);
        }
        return info;
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new NotesServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteMail(acc, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getMailsByDate(acc, dest, new Date());
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getMailFolders(acc, dest);
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getMail(acc, dest, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula form) throws Exception {
        throw new UnsupportedOperationException("IStore.search is not yet supported.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date startDate) throws Exception {
        return this.getMailsByDate(acc, dest, startDate);
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        IObjectIndex rc = this.sendMail(acc, (IMailDTO)data);
        return rc;
    }

    public static NotesMailStoreImpl getInstance() {
        ms_objNotesImpl = new NotesMailStoreImpl();
        return ms_objNotesImpl;
    }

    private HeaderDTO populateHeaderDTO(Document docObjlcl) throws ServerDown, DataNotFound {
        HeaderDTO l_headerDTOObj = new HeaderDTO();
        Vector l_toListObj = null;
        Vector l_ccListObj = null;
        Vector l_postedDateObj = null;
        String l_strPriority = null;
        try {
            l_headerDTOObj.setHeaderSize(docObjlcl.getSize());
            l_headerDTOObj.setHeaderUIDL(docObjlcl.getUniversalID());
            l_headerDTOObj.setOid((IObjectIndex)new NotesObjectIndex(l_headerDTOObj.getHeaderUIDL()));
            l_toListObj = docObjlcl.getItemValue("SendTo");
            l_headerDTOObj.setHeaderTo(this.convertVectorToStringArray(l_toListObj));
            l_ccListObj = docObjlcl.getItemValue("CopyTo");
            l_headerDTOObj.setHeaderCC(this.convertVectorToStringArray(l_ccListObj));
            l_headerDTOObj.setHeaderFrom(docObjlcl.getItemValueString("From"));
            l_headerDTOObj.setHeaderReplyTo(docObjlcl.getItemValueString("ReplyTo"));
            l_headerDTOObj.setHeaderSubject(docObjlcl.getItemValueString("Subject"));
            l_strPriority = docObjlcl.getItemValueString("X_MSMail_Priority");
            l_headerDTOObj.setHeaderPriority(this.getMailPriority(l_strPriority));
            l_postedDateObj = docObjlcl.getItemValue("PostedDate");
            if (!l_postedDateObj.isEmpty()) {
                DateTime t = (DateTime)l_postedDateObj.firstElement();
                Date d = t.toJavaDate();
                t.recycle();
                l_headerDTOObj.setHeaderSendDate(d);
            }
        }
        catch (NullPointerException l_nullExObj) {
            throw new DataNotFound(l_nullExObj.getMessage());
        }
        catch (NotesException l_notesExcepObj) {
            throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
        }
        return l_headerDTOObj;
    }

    private int getMailPriority(String strPriority) {
        int l_intPriority = 0;
        if (strPriority == null) {
            l_intPriority = 2;
        } else if (strPriority.equalsIgnoreCase("High")) {
            l_intPriority = 1;
        } else if (strPriority.equalsIgnoreCase("Normal")) {
            l_intPriority = 2;
        } else if (strPriority.equalsIgnoreCase("Low")) {
            l_intPriority = 3;
        }
        return l_intPriority;
    }

    private String[] convertVectorToStringArray(Vector<?> vectorObj) {
        int l_intSize = vectorObj.size();
        String[] l_outPutArray = new String[l_intSize];
        int l_intIndex = 0;
        while (l_intIndex < l_intSize) {
            l_outPutArray[l_intIndex] = vectorObj.elementAt(l_intIndex).toString();
            ++l_intIndex;
        }
        return l_outPutArray;
    }

    private Vector<String> convertArrayToStringVector(Object[] strArray) {
        int l_intSize = strArray.length;
        Vector<String> l_outPutVector = new Vector<String>(l_intSize);
        int l_intIndex = 0;
        while (l_intIndex < l_intSize) {
            l_outPutVector.addElement(strArray[l_intIndex].toString());
            ++l_intIndex;
        }
        return l_outPutVector;
    }

    private IMailDTO populateMailDTO(Document docObjlcl) throws ServerDown, StoreNotFound, DataNotFound, HandleException {
        BasicMailDTO l_IMailDTOObj = new BasicMailDTO();
        HeaderDTO l_headerDTOObj = new HeaderDTO();
        Vector l_toListObj = null;
        Vector l_ccListObj = null;
        Vector l_postedDateObj = null;
        String l_strPriority = null;
        DateTime t = null;
        Date d = null;
        try {
            Vector mailDate;
            l_postedDateObj = docObjlcl.getItemValue("PostedDate");
            if (!l_postedDateObj.isEmpty()) {
                t = (DateTime)l_postedDateObj.firstElement();
                d = t.toJavaDate();
                t.recycle();
                l_headerDTOObj.setHeaderSendDate(d);
            }
            if ((mailDate = docObjlcl.getItemValue("DeliveredDate")).size() == 0) {
                mailDate = docObjlcl.getItemValue("PostedDate");
            }
            if (!mailDate.isEmpty()) {
                t = (DateTime)mailDate.firstElement();
            }
            if (t != null) {
                d = t.toJavaDate();
                t.recycle();
            }
            l_headerDTOObj.setHeaderReceivedDate(d);
            l_headerDTOObj.setHeaderSize(docObjlcl.getSize());
            l_headerDTOObj.setHeaderUIDL(docObjlcl.getUniversalID());
            l_headerDTOObj.setOid((IObjectIndex)new NotesObjectIndex(l_headerDTOObj.getHeaderUIDL()));
            l_toListObj = docObjlcl.getItemValue("SendTo");
            l_headerDTOObj.setHeaderTo(this.convertVectorToStringArray(l_toListObj));
            l_ccListObj = docObjlcl.getItemValue("CopyTo");
            l_headerDTOObj.setHeaderCC(this.convertVectorToStringArray(l_ccListObj));
            l_headerDTOObj.setHeaderFrom(docObjlcl.getItemValueString("From"));
            l_headerDTOObj.setHeaderReplyTo(docObjlcl.getItemValueString("ReplyTo"));
            l_headerDTOObj.setHeaderSubject(docObjlcl.getItemValueString("Subject"));
            l_strPriority = docObjlcl.getItemValueString("X_MSMail_Priority");
            l_headerDTOObj.setHeaderPriority(this.getMailPriority(l_strPriority));
            l_IMailDTOObj.setHeaderDTO(l_headerDTOObj);
            l_IMailDTOObj.setOid((IObjectIndex)new NotesObjectIndex(l_headerDTOObj.getHeaderUIDL()));
            l_IMailDTOObj.setBody(docObjlcl.getItemValueString("Body"));
            HashMap<String, String> h = new HashMap<String, String>();
            h.put("CommonUserName", this.getCommonUserNameFromSession());
            try {
                l_IMailDTOObj.setFieldSet(h);
            }
            catch (IllegalAccessException iae) {
                Log.error((String)"failed setting FieldSet", (Throwable)iae);
            }
            this.getAttachments(docObjlcl, (IMailDTO)l_IMailDTOObj);
        }
        catch (NullPointerException l_nullExObj) {
            throw new DataNotFound(l_nullExObj.getMessage());
        }
        catch (NotesException l_notesException) {
            throw new ServerDown(String.valueOf(l_notesException.id) + l_notesException.getMessage());
        }
        catch (NoSuchElementException nsee) {
            throw new DataNotFound(nsee.getMessage());
        }
        return l_IMailDTOObj;
    }

    /*
     * Loose catch block
     */
    private void getAttachments(Document docObjlcl, IMailDTO l_IMailDTOObj) throws ServerDown, StoreNotFound, DataNotFound {
        EmbeddedObject l_embedObj2222 = null;
        AttachmentDTO[] l_byteObjArray = null;
        try {
            try {
                if (docObjlcl.hasEmbedded()) {
                    Vector v = docObjlcl.getItems();
                    Iterator ite = v.iterator();
                    Vector<EmbeddedObject> attv = new Vector<EmbeddedObject>();
                    while (ite.hasNext()) {
                        Item item = (Item)ite.next();
                        if (item.getType() != 1084 || (l_embedObj2222 = docObjlcl.getAttachment(item.getValueString())).getType() != 1454) continue;
                        attv.add(l_embedObj2222);
                    }
                    if (attv.size() > 0) {
                        int l_intIndex = 0;
                        l_byteObjArray = new AttachmentDTO[attv.size()];
                        for (EmbeddedObject l_embedObj2222 : attv) {
                            int l_intBytExistence;
                            String attachName = l_embedObj2222.getName();
                            ByteArrayOutputStream l_byteArr = new ByteArrayOutputStream();
                            BufferedInputStream l_bufInStr = new BufferedInputStream(l_embedObj2222.getInputStream());
                            BufferedOutputStream l_bufOutStr = new BufferedOutputStream(l_byteArr);
                            while ((l_intBytExistence = l_bufInStr.read()) != -1) {
                                l_bufOutStr.write(l_intBytExistence);
                            }
                            l_bufOutStr.flush();
                            l_byteArr.flush();
                            l_byteObjArray[l_intIndex] = new AttachmentDTO();
                            l_byteObjArray[l_intIndex].setFileName(attachName);
                            l_byteObjArray[l_intIndex].setFileBody(l_byteArr.toByteArray());
                            l_byteArr.close();
                            l_bufOutStr.close();
                            l_bufInStr.close();
                            ++l_intIndex;
                        }
                        l_IMailDTOObj.setAttachments(l_byteObjArray);
                    }
                }
            }
            catch (NullPointerException l_nullExObj) {
                Log.error((String)"error on getting attachment file", (Throwable)l_nullExObj);
                AttachmentDTO nullAttach = new AttachmentDTO();
                nullAttach.setFileName("*cannot get attached file*");
                l_byteObjArray = new AttachmentDTO[]{nullAttach};
                l_IMailDTOObj.setAttachments(l_byteObjArray);
                try {
                    if (l_embedObj2222 != null) {
                        l_embedObj2222.recycle();
                    }
                }
                catch (NotesException l_exceptionObj) {
                    throw new ServerDown(l_exceptionObj.getMessage());
                }
            }
            catch (NotesException l_exceptionObj) {
                Log.error((String)"error on getting Notes attachment file", (Throwable)l_exceptionObj);
                AttachmentDTO nullAttach = new AttachmentDTO();
                nullAttach.setFileName("*cannot get attached file*");
                l_byteObjArray = new AttachmentDTO[]{nullAttach};
                l_IMailDTOObj.setAttachments(l_byteObjArray);
                try {
                    if (l_embedObj2222 != null) {
                        l_embedObj2222.recycle();
                    }
                }
                catch (NotesException l_exceptionObj2) {
                    throw new ServerDown(l_exceptionObj2.getMessage());
                }
            }
            catch (IOException l_iOException) {
                Log.error((String)"error on getting attachment file", (Throwable)l_iOException);
                AttachmentDTO nullAttach = new AttachmentDTO();
                nullAttach.setFileName("*cannot get attached file*");
                l_byteObjArray = new AttachmentDTO[]{nullAttach};
                l_IMailDTOObj.setAttachments(l_byteObjArray);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (l_embedObj2222 != null) {
                        l_embedObj2222.recycle();
                    }
                }
                catch (NotesException l_exceptionObj) {
                    throw new ServerDown(l_exceptionObj.getMessage());
                }
            }
        }
        finally {
            try {
                if (l_embedObj2222 != null) {
                    l_embedObj2222.recycle();
                }
            }
            catch (NotesException l_exceptionObj) {
                throw new ServerDown(l_exceptionObj.getMessage());
            }
        }
    }

    private Document populateDocument(IMailDTO IMailDTOobj) throws NoSuchRights, HandleException, IncorrectData {
        Document l_docObj;
        block29: {
            HeaderDTO l_headerDTOobj = IMailDTOobj.getHeader();
            l_docObj = null;
            try {
                l_docObj = this.createDocument();
                l_docObj.appendItemValue("Form", (Object)"Memo");
                l_docObj.appendItemValue("Logo", (Object)"StdNotesltr50");
                if (l_headerDTOobj.getHeaderSubject() != null) {
                    l_docObj.replaceItemValue("Subject", (Object)l_headerDTOobj.getHeaderSubject());
                }
                if (l_headerDTOobj.getHeaderTo() != null) {
                    l_docObj.replaceItemValue("SendTo", this.convertArrayToStringVector(l_headerDTOobj.getHeaderTo()));
                }
                if (l_headerDTOobj.getHeaderCC() != null) {
                    l_docObj.replaceItemValue("CopyTo", this.convertArrayToStringVector(l_headerDTOobj.getHeaderCC()));
                }
                if (l_headerDTOobj.getHeaderBCC() != null) {
                    l_docObj.replaceItemValue("BlindCopyTo", this.convertArrayToStringVector(l_headerDTOobj.getHeaderBCC()));
                }
                if (l_headerDTOobj.getHeaderFrom() != null) {
                    l_docObj.replaceItemValue("From", (Object)l_headerDTOobj.getHeaderFrom().toString());
                }
                if (l_headerDTOobj.getHeaderReplyTo() != null) {
                    l_docObj.replaceItemValue("ReplyTo", (Object)l_headerDTOobj.getHeaderReplyTo().toString());
                }
                RichTextItem l_body = l_docObj.createRichTextItem("Body");
                if (IMailDTOobj.getBody() != null) {
                    l_body.appendText(IMailDTOobj.getBody());
                }
                int l_numberOfAttachments = IMailDTOobj.getNumberOfAttachments();
                AttachmentDTO[] att = IMailDTOobj.getAttachments();
                int i = 0;
                while (i < l_numberOfAttachments) {
                    block28: {
                        File f = null;
                        FileOutputStream fos = null;
                        try {
                            f = File.createTempFile("attachment", "." + att[i].getFileName());
                            fos = new FileOutputStream(f);
                            fos.write(att[i].getFileBody());
                            l_body.embedObject(1454, "", f.getAbsolutePath(), att[i].getFileName());
                        }
                        catch (IOException ioe) {
                            Log.error((String)"error on create temp file for attach.", (Throwable)ioe);
                            try {
                                fos.close();
                                f.delete();
                            }
                            catch (Exception exception) {}
                            break block28;
                        }
                        catch (NotesException ne) {
                            try {
                                Log.error((String)"error on create temp file for attach.", (Throwable)ne);
                                break block28;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    fos.close();
                                    f.delete();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        try {
                            fos.close();
                            f.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                if (l_headerDTOobj.getHeaderSendDate() != null) {
                    l_docObj.replaceItemValue("PostedDate", (Object)super.createDateTime(l_headerDTOobj.getHeaderSendDate()));
                    break block29;
                }
                DateTime created = l_docObj.getCreated();
                try {
                    l_docObj.replaceItemValue("PostedDate", (Object)super.createDateTime(created.getLocalTime()));
                }
                catch (ParseException pe) {
                    Log.error((String)"", (Throwable)pe);
                    throw new IncorrectData(pe.getMessage());
                }
            }
            catch (NotesException l_notesExpObj) {
                throw new IncorrectData(String.valueOf(l_notesExpObj.id) + l_notesExpObj.text);
            }
        }
        return l_docObj;
    }

    public FolderMetadata[] getMailFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        FolderMetadata[] l_strFolderlist = new FolderMetadata[]{};
        ArrayList<FolderMetadata> dst = new ArrayList<FolderMetadata>();
        Vector<View> l_viewsObj = null;
        View l_viewObj = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_viewsObj = this.getViews();
                int l_intIndex = 0;
                while (l_intIndex < l_viewsObj.size()) {
                    l_viewObj = l_viewsObj.elementAt(l_intIndex);
                    if (l_viewObj.isFolder()) {
                        FolderMetadata folder = new FolderMetadata();
                        folder.setFolderName(l_viewObj.getName());
                        folder.setOid((IObjectIndex)new NotesFolderIndex(l_viewObj.getName()));
                        dst.add(folder);
                    }
                    ++l_intIndex;
                }
            }
            catch (NullPointerException l_nullExObj) {
                throw new StoreNotFound(l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExcepObj) {
                throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        finally {
            block19: {
                try {
                    try {
                        if (l_viewsObj != null) {
                            l_viewObj.recycle();
                        }
                    }
                    catch (Exception l_exceptionObj) {
                        Log.error((String)"", (Throwable)l_exceptionObj);
                        super.recycleObjects();
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    super.recycleObjects();
                    throw throwable;
                }
                super.recycleObjects();
            }
        }
        l_strFolderlist = dst.toArray(l_strFolderlist);
        return l_strFolderlist;
    }

    public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IMailDTO[] headers;
        block34: {
            DocumentCollection l_docCollectionObj = null;
            View l_viewObj = null;
            Object l_dateTimeStartObj = null;
            DateRange l_dateRangeObj = null;
            headers = null;
            IFolderIndex folder = dest.getFolder();
            this.initSession((NotesAccountData)acc);
            try {
                try {
                    String l_offsetDays = EAINotesBase.prop.getProperty("OffsetDays", "30");
                    int l_intoffsetDays = Integer.parseInt(l_offsetDays);
                    l_viewObj = this.getView(folder);
                    l_dateRangeObj = this.createDateRange("Today", l_intoffsetDays, false);
                    l_docCollectionObj = l_viewObj.getAllDocumentsByKey((Object)l_dateRangeObj);
                    headers = this.generateMailArray(l_docCollectionObj);
                }
                catch (NullPointerException l_nullExObj) {
                    throw new StoreNotFound(String.valueOf((String)folder.getIndex()) + l_nullExObj.getMessage());
                }
                catch (NotesException l_notesExObj) {
                    throw new DataNotFound(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (l_viewObj != null) {
                                l_viewObj.recycle();
                            }
                            if (l_docCollectionObj != null) {
                                l_docCollectionObj.recycle();
                            }
                            if (l_dateTimeStartObj != null) {
                                l_dateTimeStartObj.recycle();
                            }
                            if (l_dateRangeObj != null) {
                                l_dateRangeObj.recycle();
                            }
                            break block34;
                        }
                        catch (NotesException l_exceptionObj) {
                            throw new ServerDown(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
                        }
                    }
                    finally {
                        super.recycleObjects();
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (l_viewObj != null) {
                            l_viewObj.recycle();
                        }
                        if (l_docCollectionObj != null) {
                            l_docCollectionObj.recycle();
                        }
                        if (l_dateTimeStartObj != null) {
                            l_dateTimeStartObj.recycle();
                        }
                        if (l_dateRangeObj != null) {
                            l_dateRangeObj.recycle();
                        }
                    }
                    catch (NotesException l_exceptionObj) {
                        throw new ServerDown(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
                    }
                }
                finally {
                    super.recycleObjects();
                }
                throw throwable;
            }
            try {
                try {
                    if (l_viewObj != null) {
                        l_viewObj.recycle();
                    }
                    if (l_docCollectionObj != null) {
                        l_docCollectionObj.recycle();
                    }
                    if (l_dateTimeStartObj != null) {
                        l_dateTimeStartObj.recycle();
                    }
                    if (l_dateRangeObj != null) {
                        l_dateRangeObj.recycle();
                    }
                }
                catch (NotesException l_exceptionObj) {
                    throw new ServerDown(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
        }
        return headers;
    }

    protected HeaderDTO[] generateHeaderArray(DocumentCollection l_docCollectionObj) throws HandleException {
        if (l_docCollectionObj == null) {
            throw new HandleException("l_docCollectionObj nust not be null");
        }
        HeaderDTO l_headerDTOObj = new HeaderDTO();
        ArrayList<HeaderDTO> l_listHeaderObj = new ArrayList<HeaderDTO>();
        Document l_docObj = null;
        try {
            try {
                l_docObj = l_docCollectionObj.getFirstDocument();
                while (l_docObj != null) {
                    Document rec_dummy = null;
                    try {
                        l_headerDTOObj = this.populateHeaderDTO(l_docObj);
                        l_listHeaderObj.add(l_headerDTOObj);
                    }
                    catch (ClassCastException l_classCastExObj) {
                        Log.info((String)("Notes mail failed to cast. (UniversalID:" + l_docObj.getUniversalID() + ")"));
                    }
                    rec_dummy = l_docObj;
                    l_docObj = l_docCollectionObj.getNextDocument(l_docObj);
                    rec_dummy.recycle();
                }
            }
            catch (NotesException l_notesExObj) {
                throw new DataNotFound(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
            }
        }
        finally {
            if (l_docObj != null) {
                try {
                    l_docObj.recycle();
                    l_docObj = null;
                }
                catch (NotesException e) {
                    Log.warn((String)"notes object recycle failed.");
                }
            }
        }
        HeaderDTO[] l_obj = new HeaderDTO[1];
        l_obj = l_listHeaderObj.toArray(l_obj);
        return l_obj;
    }

    public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date lastDate) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IFolderIndex folder = dest.getFolder();
        View l_viewObj = null;
        ViewEntryCollection l_viewEntryCollection = null;
        IMailDTO[] headers = null;
        DateTime l_dateTimeObj = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_viewObj = this.getView(folder);
                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
                l_dateTimeObj = super.createDateTime(df.format(lastDate));
                String string = "l_viewObj=" + l_viewObj + ";l_dateTimeObj = " + l_dateTimeObj;
                NotesMailStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
                l_viewEntryCollection = l_viewObj.getAllEntriesByKey((Object)l_dateTimeObj);
                headers = this.exGenerateMailArray(l_viewEntryCollection);
            }
            catch (NullPointerException l_nullExObj) {
                throw new StoreNotFound(String.valueOf((String)folder.getIndex()) + l_nullExObj.getMessage());
            }
            catch (NotesException notesExObj) {
                throw new DataNotFound(String.valueOf(notesExObj.id) + notesExObj.text);
            }
            catch (ParseException pe) {
                Log.error((String)"", (Throwable)pe);
                throw new IncorrectData(pe.getMessage());
            }
        }
        finally {
            super.recycleObjects();
        }
        return headers;
    }

    public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex strReferenceUID) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IMailDTO l_IMailDTOObj = null;
        Document l_docObj = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_docObj = this.getDocumentByUNID(strReferenceUID);
                l_IMailDTOObj = this.populateMailDTO(l_docObj);
            }
            catch (NullPointerException l_nullExObj) {
                throw new DataNotFound(l_nullExObj.getMessage());
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (l_docObj != null) {
                        l_docObj.recycle();
                    }
                }
                catch (NotesException l_notesExcepObj) {
                    throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
            }
            catch (NotesException l_notesExcepObj) {
                throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        finally {
            super.recycleObjects();
        }
        return l_IMailDTOObj;
    }

    public IObjectIndex[] getUIDLsByDate(IAccountData acc, ISearchDestination dest, Date dateObj) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IFolderIndex folder = dest.getFolder();
        View l_viewObj = null;
        DateRange l_dateRangeObj = null;
        DocumentCollection l_docCollectionObj = null;
        IObjectIndex[] l_strUidl = null;
        Date tmpDate = dateObj;
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        String tmpStr = String.valueOf(df.format(dateObj)) + " 00:00:00";
        try {
            tmpDate = df2.parse(tmpStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Date startDate = tmpDate;
        tmpStr = String.valueOf(df.format(dateObj)) + " 23:59:59";
        try {
            tmpDate = df2.parse(tmpStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Date endDate = tmpDate;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_viewObj = this.getView(folder);
                l_dateRangeObj = super.createDateRange(startDate, endDate);
                l_docCollectionObj = l_viewObj.getAllDocumentsByKey((Object)l_dateRangeObj);
                l_strUidl = this.generateUIDLArray(l_docCollectionObj);
            }
            catch (NullPointerException l_nullExObj) {
                throw new StoreNotFound(String.valueOf((String)folder.getIndex()) + l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExcepObj) {
                throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (l_viewObj != null) {
                        l_viewObj.recycle();
                    }
                    if (l_dateRangeObj != null) {
                        l_dateRangeObj.recycle();
                    }
                    if (l_docCollectionObj != null) {
                        l_docCollectionObj.recycle();
                    }
                }
                catch (NotesException l_excepObj) {
                    throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (l_viewObj != null) {
                    l_viewObj.recycle();
                }
                if (l_dateRangeObj != null) {
                    l_dateRangeObj.recycle();
                }
                if (l_docCollectionObj != null) {
                    l_docCollectionObj.recycle();
                }
            }
            catch (NotesException l_excepObj) {
                throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
            }
        }
        finally {
            super.recycleObjects();
        }
        return l_strUidl;
    }

    protected IObjectIndex[] generateUIDLArray(DocumentCollection l_docCollectionObj) throws HandleException {
        if (l_docCollectionObj == null) {
            throw new HandleException("l_docCollectionObj nust not be null");
        }
        BasicObjectIndex[] l_strUidl = null;
        Document l_docObj = null;
        try {
            try {
                int l_intMailCount = l_docCollectionObj.getCount();
                l_strUidl = new BasicObjectIndex[l_intMailCount];
                l_docObj = l_docCollectionObj.getFirstDocument();
                int l_intIndex = 0;
                while (l_docObj != null) {
                    Document rec_dummy = null;
                    String unid = l_docObj.getUniversalID();
                    l_strUidl[l_intIndex] = new BasicObjectIndex((Object)unid);
                    HashMap<String, String> h = new HashMap<String, String>();
                    h.put("UNID", unid);
                    try {
                        l_strUidl[l_intIndex].setFieldSet(h);
                    }
                    catch (Exception e) {
                        Log.error((String)"Exception on BasicRecordObject.setFieldSet.", (Throwable)e);
                    }
                    ++l_intIndex;
                    rec_dummy = l_docObj;
                    l_docObj = l_docCollectionObj.getNextDocument(l_docObj);
                    rec_dummy.recycle();
                }
            }
            catch (NotesException l_notesExObj) {
                throw new DataNotFound(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
            }
        }
        finally {
            if (l_docObj != null) {
                try {
                    l_docObj.recycle();
                    l_docObj = null;
                }
                catch (NotesException notesException) {}
            }
        }
        return l_strUidl;
    }

    /*
     * Loose catch block
     */
    public IObjectIndex[] getUIDLs(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IObjectIndex[] l_strUIDL;
        block44: {
            IFolderIndex folder = null;
            if (dest != null) {
                folder = dest.getFolder();
            }
            View l_viewObj = null;
            Object l_dateTimeStartObj = null;
            DateRange l_dateRangeObj = null;
            DocumentCollection l_docCollectionObj = null;
            l_strUIDL = null;
            super.initSession((NotesAccountData)acc);
            try {
                String l_offsetDays = EAINotesBase.prop.getProperty("OffsetDays", "30");
                int l_intoffsetDays = Integer.parseInt(l_offsetDays);
                l_dateRangeObj = this.createDateRange("Today", l_intoffsetDays, false);
                l_viewObj = this.getView(folder);
                l_docCollectionObj = l_viewObj.getAllDocumentsByKey((Object)l_dateRangeObj);
                l_strUIDL = this.generateUIDLArray(l_docCollectionObj);
            }
            catch (NullPointerException l_nullExObj) {
                throw new StoreNotFound(String.valueOf((String)folder.getIndex()) + l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExcepObj) {
                Log.error((String)"", (Throwable)l_notesExcepObj);
                try {
                    try {
                        if (l_viewObj != null) {
                            l_viewObj.recycle();
                        }
                        if (l_docCollectionObj != null) {
                            l_docCollectionObj.recycle();
                        }
                        if (l_dateTimeStartObj != null) {
                            l_dateTimeStartObj.recycle();
                        }
                        if (l_dateRangeObj != null) {
                            l_dateRangeObj.recycle();
                        }
                        break block44;
                    }
                    catch (NotesException l_excepObj) {
                        throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                    }
                }
                finally {
                    super.recycleObjects();
                }
            }
            catch (Exception exception) {
                try {
                    try {
                        if (l_viewObj != null) {
                            l_viewObj.recycle();
                        }
                        if (l_docCollectionObj != null) {
                            l_docCollectionObj.recycle();
                        }
                        if (l_dateTimeStartObj != null) {
                            l_dateTimeStartObj.recycle();
                        }
                        if (l_dateRangeObj != null) {
                            l_dateRangeObj.recycle();
                        }
                        break block44;
                    }
                    catch (NotesException l_excepObj) {
                        throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                    }
                }
                finally {
                    super.recycleObjects();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (l_viewObj != null) {
                                l_viewObj.recycle();
                            }
                            if (l_docCollectionObj != null) {
                                l_docCollectionObj.recycle();
                            }
                            if (l_dateTimeStartObj != null) {
                                l_dateTimeStartObj.recycle();
                            }
                            if (l_dateRangeObj != null) {
                                l_dateRangeObj.recycle();
                            }
                        }
                        catch (NotesException l_excepObj) {
                            throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                        }
                    }
                    finally {
                        super.recycleObjects();
                    }
                    throw throwable;
                }
            }
            try {
                try {
                    if (l_viewObj != null) {
                        l_viewObj.recycle();
                    }
                    if (l_docCollectionObj != null) {
                        l_docCollectionObj.recycle();
                    }
                    if (l_dateTimeStartObj != null) {
                        l_dateTimeStartObj.recycle();
                    }
                    if (l_dateRangeObj != null) {
                        l_dateRangeObj.recycle();
                    }
                }
                catch (NotesException l_excepObj) {
                    throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
        }
        return l_strUIDL;
    }

    protected IMailDTO[] generateMailArray(DocumentCollection l_docCollectionObj) throws HandleException, DataNotFound {
        if (l_docCollectionObj == null) {
            throw new HandleException("l_docCollectionObj must not be null");
        }
        IMailDTO[] l_mailArray = new IMailDTO[]{};
        IMailDTO l_IMailDTOObj = null;
        ArrayList<IMailDTO> l_listMailObj = new ArrayList<IMailDTO>();
        Document l_docObj = null;
        try {
            try {
                l_docObj = l_docCollectionObj.getFirstDocument();
                while (l_docObj != null) {
                    Document rec_dummy = null;
                    try {
                        l_IMailDTOObj = this.populateMailDTO(l_docObj);
                        l_listMailObj.add(l_IMailDTOObj);
                    }
                    catch (DataNotFound dataNotFound) {
                    }
                    catch (ClassCastException l_classCastExObj) {
                        Log.info((String)("Notes mail failed to cast. (UniversalID:" + l_docObj.getUniversalID() + ")"));
                    }
                    rec_dummy = l_docObj;
                    l_docObj = l_docCollectionObj.getNextDocument(l_docObj);
                    rec_dummy.recycle();
                }
            }
            catch (NotesException l_notesExObj) {
                throw new DataNotFound(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
            }
        }
        finally {
            if (l_docObj != null) {
                try {
                    l_docObj.recycle();
                    l_docObj = null;
                }
                catch (NotesException notesException) {}
            }
        }
        if (l_listMailObj.size() > 0) {
            l_mailArray = l_listMailObj.toArray(l_mailArray);
        }
        return l_mailArray;
    }

    public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date dateObj) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        String string = "EAINotesMailImpl.getMailsByDate";
        NotesMailStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        IFolderIndex folder = dest.getFolder();
        View l_viewObj = null;
        DateTime l_dateTimeObj = null;
        DocumentCollection l_docCollectionObj = null;
        IMailDTO[] l_mailArray = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_viewObj = this.getView(folder);
                String string2 = "l_viewObj=" + l_viewObj;
                NotesMailStoreImpl.debug_aroundBody5$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_2);
                l_dateTimeObj = super.createDateTime(dateObj);
                try {
                    l_dateTimeObj = super.createDateTime(l_dateTimeObj.getDateOnly());
                }
                catch (ParseException pe) {
                    Log.error((String)"", (Throwable)pe);
                    throw new IncorrectData(pe.getMessage());
                }
                String string3 = "l_viewObj=" + l_viewObj + ";l_dateTimeObj = " + l_dateTimeObj;
                NotesMailStoreImpl.debug_aroundBody7$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_3);
                l_docCollectionObj = l_viewObj.getAllDocumentsByKey((Object)l_dateTimeObj);
                l_mailArray = this.generateMailArray(l_docCollectionObj);
            }
            catch (NullPointerException l_nullExObj) {
                throw new StoreNotFound(String.valueOf((String)folder.getIndex()) + l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExcepObj) {
                throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (l_viewObj != null) {
                        l_viewObj.recycle();
                    }
                    if (l_dateTimeObj != null) {
                        l_dateTimeObj.recycle();
                    }
                    if (l_docCollectionObj != null) {
                        l_docCollectionObj.recycle();
                    }
                }
                catch (NotesException l_excepObj) {
                    throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (l_viewObj != null) {
                    l_viewObj.recycle();
                }
                if (l_dateTimeObj != null) {
                    l_dateTimeObj.recycle();
                }
                if (l_docCollectionObj != null) {
                    l_docCollectionObj.recycle();
                }
            }
            catch (NotesException l_excepObj) {
                throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
            }
        }
        finally {
            super.recycleObjects();
        }
        return l_mailArray;
    }

    public IObjectIndex sendMail(IAccountData acc, IMailDTO IMailDTOobj) throws NoSuchRights, ServerDown, IncorrectData, HandleException {
        Document l_docObj = null;
        NotesObjectIndex rc = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_docObj = this.populateDocument(IMailDTOobj);
                l_docObj.save();
                rc = new NotesObjectIndex(l_docObj.getUniversalID());
                l_docObj.send(l_docObj.getItemValue("SendTo"));
            }
            catch (NotesException notesEx) {
                throw new HandleException(String.valueOf(notesEx.id) + notesEx.text);
            }
        }
        catch (Throwable throwable) {
            block17: {
                try {
                    try {
                        if (l_docObj != null) {
                            l_docObj.recycle();
                        }
                    }
                    catch (NotesException l_notesExp) {
                        new ServerDown(String.valueOf(l_notesExp.id) + l_notesExp.text);
                        super.recycleObjects();
                        break block17;
                    }
                }
                catch (Throwable throwable2) {
                    super.recycleObjects();
                    throw throwable2;
                }
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
            }
            catch (NotesException l_notesExp) {
                new ServerDown(String.valueOf(l_notesExp.id) + l_notesExp.text);
                super.recycleObjects();
            }
        }
        finally {
            super.recycleObjects();
        }
        return rc;
    }

    public IMailDTO[] getSentMails(IAccountData acc) throws ServerDown, HandleException {
        return this.getMailsByDate(acc, this.getPresetDestination(acc, 2), new Date());
    }

    public IMailDTO[] getSentMailsByDate(IAccountData acc, Date dateObj) throws ServerDown, HandleException {
        return this.getMailsByDate(acc, this.getPresetDestination(acc, 2), dateObj);
    }

    public void deleteMail(IAccountData acc, IObjectIndex strUIDL) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        Document l_docObj = null;
        String string = "delete mail " + strUIDL;
        NotesMailStoreImpl.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_docObj = this.getDocumentByUNID(strUIDL);
                l_docObj.remove(true);
                String string2 = "deleted";
                NotesMailStoreImpl.debug_aroundBody11$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_5);
            }
            catch (NullPointerException l_nullExObj) {
                String string3 = "mail not found";
                NotesMailStoreImpl.debug_aroundBody13$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_6);
                throw new DataNotFound(l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExObj) {
                throw new DeleteFailed();
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (l_docObj != null) {
                        l_docObj.recycle();
                    }
                }
                catch (NotesException l_notesExcepObj) {
                    throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
            }
            catch (NotesException l_notesExcepObj) {
                throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        finally {
            super.recycleObjects();
        }
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        IDatabaseIndex db = null;
        IFolderIndex folder = null;
        switch (type) {
            case 1: {
                folder = this.inboxElement;
                break;
            }
            case 2: {
                folder = this.sentboxElement;
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    @Override
    protected String getElmentName() {
        return DEFAULT_NOTES_INBOX_NAME;
    }

    @Override
    protected HashMap<String, Object> populateHashMap(Document doc) throws HandleException {
        HashMap<String, Object> h = new HashMap<String, Object>();
        try {
            Vector items = doc.getItems();
            Item item = null;
            String name = null;
            Vector values = null;
            String[] value = null;
            int i = 0;
            while (i < items.size()) {
                try {
                    item = (Item)items.get(i);
                    name = item.getName();
                    values = item.getValues();
                    value = values == null || values.size() <= 1 ? item.getValueString() : this.convertVectorToStringArray(values);
                    h.put(name, value);
                }
                catch (Exception e2) {
                    if (name == null) {
                        name = "[couldn't get name]";
                    }
                    String string = "skip convert field " + name + " by error. message is " + e2.getMessage();
                    NotesMailStoreImpl.trace_aroundBody15$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_7);
                    name = null;
                }
                ++i;
            }
        }
        catch (NotesException e) {
            throw new HandleException(String.valueOf(e.id) + e.text);
        }
        return h;
    }

    protected IMailDTO[] exGenerateMailArray(ViewEntryCollection l_viewEntryCollection) throws HandleException, DataNotFound {
        if (l_viewEntryCollection == null) {
            throw new HandleException("l_viewEntryCollection must not be null");
        }
        IMailDTO[] l_mailArray = null;
        BasicMailDTO l_IMailDTOObj = null;
        HeaderDTO l_headerDTOObj = null;
        ArrayList<BasicMailDTO> l_listMailObj = new ArrayList<BasicMailDTO>();
        Document l_docObj = null;
        ViewEntry l_viewEntry = null;
        try {
            int collectionCount = l_viewEntryCollection.getCount();
            String string = "collectionCount=" + collectionCount;
            NotesMailStoreImpl.debug_aroundBody17$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_8);
            l_viewEntry = l_viewEntryCollection.getLastEntry();
            while (l_viewEntry != null) {
                try {
                    l_IMailDTOObj = new BasicMailDTO();
                    l_docObj = l_viewEntry.getDocument();
                    try {
                        l_headerDTOObj = this.exPopulateHeaderDTO(l_docObj);
                        if (l_docObj.hasEmbedded()) {
                            AttachmentDTO[] l_byteObjArray = new AttachmentDTO[]{new AttachmentDTO()};
                            l_IMailDTOObj.setAttachments(l_byteObjArray);
                        }
                        l_IMailDTOObj.setHeaderDTO(l_headerDTOObj);
                        l_IMailDTOObj.setOid((IObjectIndex)new NotesObjectIndex(l_headerDTOObj.getHeaderUIDL()));
                        HashMap<String, String> h = new HashMap<String, String>();
                        h.put("CommonUserName", this.getCommonUserNameFromSession());
                        String form = l_docObj.getItemValueString("Form");
                        if (form == null || form.length() == 0) {
                            form = l_docObj.getItemValueString("FORM");
                        }
                        h.put("Form", form);
                        try {
                            l_IMailDTOObj.setFieldSet(h);
                        }
                        catch (IllegalAccessException iae) {
                            Log.error((String)"failed setting FieldSet", (Throwable)iae);
                        }
                        l_listMailObj.add(l_IMailDTOObj);
                    }
                    catch (ClassCastException l_classCastExObj) {
                        Log.info((String)("Notes mail failed to cast. (UniversalID:" + l_docObj.getUniversalID() + ")"));
                    }
                }
                catch (DataNotFound dnf) {
                    String string2 = "DataNotFound via exGenerateMailArray :\n" + dnf.getStackTraceString();
                    NotesMailStoreImpl.debug_aroundBody19$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_9);
                }
                l_viewEntry = l_viewEntryCollection.getPrevEntry(l_viewEntry);
            }
        }
        catch (NotesException l_notesExObj) {
            throw new DataNotFound(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
        }
        IMailDTO[] a = new IMailDTO[]{};
        l_mailArray = l_listMailObj.toArray(a);
        return l_mailArray;
    }

    private HeaderDTO exPopulateHeaderDTO(Document docObjlcl) throws ServerDown, DataNotFound {
        HeaderDTO l_headerDTOObj = new HeaderDTO();
        try {
            Vector mailDate;
            Vector l_toListObj = docObjlcl.getItemValue("SendTo");
            l_headerDTOObj.setHeaderTo(this.convertVectorToStringArray(l_toListObj));
            l_headerDTOObj.setHeaderUIDL(docObjlcl.getUniversalID());
            l_headerDTOObj.setHeaderFrom(docObjlcl.getItemValueString("From"));
            l_headerDTOObj.setHeaderSubject(docObjlcl.getItemValueString("Subject"));
            Vector l_postedDateObj = docObjlcl.getItemValue("PostedDate");
            DateTime t = null;
            Date d = null;
            if (!l_postedDateObj.isEmpty()) {
                t = (DateTime)l_postedDateObj.firstElement();
                d = t.toJavaDate();
                l_headerDTOObj.setHeaderSendDate(d);
            }
            if ((mailDate = docObjlcl.getItemValue("DeliveredDate")).size() != 0) {
                t = (DateTime)mailDate.firstElement();
            }
            if (t != null) {
                d = t.toJavaDate();
                l_headerDTOObj.setHeaderReceivedDate(d);
            }
        }
        catch (NullPointerException l_nullExObj) {
            throw new DataNotFound(l_nullExObj.getMessage());
        }
        catch (NotesException l_notesExcepObj) {
            throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
        }
        return l_headerDTOObj;
    }

    private static final /* synthetic */ void debug_aroundBody0(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody12(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody13$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody14(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody15$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody16(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody17$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody18(NotesMailStoreImpl notesMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody19$advice(NotesMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NotesMailStoreImpl.java", Class.forName("jp.co.connectone.eai.notes.store.NotesMailStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 579);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 847);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 856);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 868);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 946);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 951);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 954);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1034);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1059);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1096);
    }
}

