/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.GenericValidator;

public class GenericTypeValidator
implements Serializable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$GenericTypeValidator == null ? (class$org$apache$commons$validator$GenericTypeValidator = GenericTypeValidator.class$("org.apache.commons.validator.GenericTypeValidator")) : class$org$apache$commons$validator$GenericTypeValidator));
    static /* synthetic */ Class class$org$apache$commons$validator$GenericTypeValidator;

    public static Byte formatByte(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Byte(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Short formatShort(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Short(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer formatInt(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long formatLong(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float formatFloat(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Float(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double formatDouble(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Date formatDate(String value, Locale locale) {
        Date date = null;
        if (value == null) {
            return null;
        }
        try {
            DateFormat formatter = null;
            formatter = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
            formatter.setLenient(false);
            date = formatter.parse(value);
        }
        catch (ParseException e) {
            log.warn((Object)value, (Throwable)e);
        }
        return date;
    }

    public static Date formatDate(String value, String datePattern, boolean strict) {
        Date date = null;
        if (value == null || datePattern == null || datePattern.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
            formatter.setLenient(false);
            date = formatter.parse(value);
            if (strict && datePattern.length() != value.length()) {
                date = null;
            }
        }
        catch (ParseException e) {
            log.warn((Object)value, (Throwable)e);
        }
        return date;
    }

    public static Long formatCreditCard(String value) {
        return GenericValidator.isCreditCard(value) ? new Long(value) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

