/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.messages.BaseRequestType;
import com.microsoft.schemas.exchange.services._2006.messages.CreateItemType;
import com.microsoft.schemas.exchange.services._2006.messages.UpdateItemType;
import com.microsoft.schemas.exchange.services._2006.types.BodyType;
import com.microsoft.schemas.exchange.services._2006.types.BodyTypeType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemCreateOrDeleteOperationType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemUpdateOperationType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.TargetFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import jp.co.connectone.eai.exchews.ews.EWSSearchFormula;
import jp.co.connectone.eai.exchews.ews.EWS_AND_SearchConditionCollection;
import jp.co.connectone.eai.exchews.ews.IEwsSearchFormula;
import jp.co.connectone.eai.exchews.ews.UpdateItemMap;
import jp.co.connectone.eai.exchews.store.EAIExchewsBase;
import jp.co.connectone.eai.exchews.store.ExchewsFolderIndex;
import jp.co.connectone.eai.exchews.store.ExchewsObjectIndex;
import jp.co.connectone.eai.exchews.store.ExchewsScheduleDTO;
import jp.co.connectone.eai.exchews.store.ExchewsServiceInfo;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.SearchConditionFailed;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchConditionElement;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.ISearchType;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.client.ScheduleSearchCondition;
import jp.co.connectone.store.pim.IScheduleDTO;
import jp.co.connectone.store.pim.IScheduleStore;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;

public class ExchewsScheduleStoreImpl
extends EAIExchewsBase
implements IScheduleStore {
    public static final List<String> SEARCH_FIELDS = IEwsSearchFormula.ALL_PROPERTIES;
    public static final IStoreID storeID = new SimpleStoreID(ExchewsScheduleStoreImpl.class.getName());
    public static final String storeName = "Exchange EWS schedule store";
    protected static final String itemType = "IPM.Appointment";
    protected boolean sendFlag = false;

    public IServiceInfo getServiceInfo() throws Exception {
        return new ExchewsServiceInfo(storeID, storeName);
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IObjectIndex createNewSchedule(IAccountData acc, IScheduleDTO dto) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException {
        super.setAccountData(acc);
        CalendarItemType item = null;
        try {
            item = ExchewsScheduleDTO.convertToCalendarItemType(dto);
        }
        catch (Exception e) {
            Log.error((String)"ScheduleDTO convert error.", (Throwable)e);
            throw new IncorrectData(e.getMessage());
        }
        item = super.createItem(EAIExchewsBase.shceduleElement, (ItemType)item);
        ExchewsObjectIndex oid = new ExchewsObjectIndex(item.getItemId());
        return oid;
    }

    @Override
    protected void setAdditionalRequestProperties(BaseRequestType item) throws HandleException {
        if (item == null) {
            return;
        }
        if (item instanceof CreateItemType) {
            CalendarItemType cal;
            ItemType it = (ItemType)((CreateItemType)item).getItems().getItemOrMessageOrCalendarItem().get(0);
            CalendarItemCreateOrDeleteOperationType type = CalendarItemCreateOrDeleteOperationType.SEND_TO_NONE;
            if (it != null && it instanceof CalendarItemType && ((cal = (CalendarItemType)it).getRequiredAttendees() != null || cal.getOptionalAttendees() != null)) {
                type = CalendarItemCreateOrDeleteOperationType.SEND_TO_ALL_AND_SAVE_COPY;
            }
            ((CreateItemType)item).setSendMeetingInvitations(type);
        } else if (item instanceof UpdateItemType) {
            CalendarItemUpdateOperationType utype = CalendarItemUpdateOperationType.SEND_TO_NONE;
            if (this.sendFlag) {
                utype = CalendarItemUpdateOperationType.SEND_TO_CHANGED_AND_SAVE_COPY;
                this.sendFlag = false;
            }
            UpdateItemType ui = (UpdateItemType)item;
            ui.setSendMeetingInvitationsOrCancellations(utype);
        }
    }

    public void deleteSchedule(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        try {
            this.delete(acc, null, oid);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
    }

    public IScheduleDTO[] getAllSchedules(IAccountData acc, Date cutOffDate) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        return null;
    }

    public IScheduleDTO getSchedule(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        super.setAccountData(acc);
        ISearchDestination dest = this.getPresetDestination(acc, 1);
        CalendarItemType item = (CalendarItemType)this.getItem(dest, (ItemIdType)oid.getIndex());
        ExchewsScheduleDTO rc = null;
        try {
            rc = ExchewsScheduleDTO.convertFromCalendarItemType(item);
            if (rc != null && item.isHasAttachments().booleanValue()) {
                rc.convertAndSetEWSAttachments(this.getAttachments((ItemType)item));
            }
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"Calendar item convert error", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        return rc;
    }

    public IScheduleDTO[] getSchedulesByDate(IAccountData acc, Date date) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        SearchConditionCollection cond = new SearchConditionCollection();
        ISearchDestination dest = this.getPresetDestination(acc, 1);
        List<String> fieldsToGet = SEARCH_FIELDS;
        EWSSearchFormula form = null;
        try {
            form = new EWSSearchFormula(dest, fieldsToGet, cond);
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException();
        }
        return this.getSchedulesByDate(acc, form, date);
    }

    public IScheduleDTO[] getSchedulesByDate(IAccountData acc, ISearchFormula search, Date date) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        super.setAccountData(acc);
        SearchConditionCollection cond = super.getDateSearchCondition(UnindexedFieldURIType.CALENDAR_START, date);
        SearchConditionCollection src = search.getSearchConditions();
        if (src == null) {
            search.setSearchConditions(cond);
        } else {
            EWS_AND_SearchConditionCollection and = new EWS_AND_SearchConditionCollection();
            and.add((ISearchConditionElement)cond);
            and.add((ISearchConditionElement)src);
            search.setSearchConditions((SearchConditionCollection)and);
        }
        ExchewsScheduleDTO[] dtos = new ExchewsScheduleDTO[1];
        List<Object> items = new ArrayList();
        try {
            items = super.searchByDate(search.getDest(), search.getFieldsToGet(), search.getSearchConditions(), date, itemType);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        ArrayList<ExchewsScheduleDTO> rc = new ArrayList<ExchewsScheduleDTO>();
        for (ItemType itemType : items) {
            try {
                ExchewsScheduleDTO dto = ExchewsScheduleDTO.convertFromCalendarItemType((CalendarItemType)itemType);
                rc.add(dto);
                if (!itemType.isHasAttachments().booleanValue()) continue;
                dto.convertAndSetEWSAttachments(this.getAttachments(itemType));
            }
            catch (Exception e) {
                Log.debug((String)"error on converting CalendarItemType to ExchewsScheduleDTO. skip one data..", (Throwable)e);
            }
        }
        return rc.toArray(dtos);
    }

    public boolean isDuplicateSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException {
        return false;
    }

    public boolean isValidSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        return false;
    }

    public IScheduleDTO[] searchSchedules(IAccountData acc, ISearchFormula form) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        if (form == null) {
            throw new NullPointerException("ISearchFormula parameter must not be null.");
        }
        SearchConditionCollection conds = form.getSearchConditions();
        if (conds == null) {
            throw new IncorrectData("Search condition for date must be defined.");
        }
        Date date = null;
        ExchewsObjectIndex oid = null;
        for (ISearchConditionElement cond : conds) {
            if (cond == null || !(cond instanceof ScheduleSearchCondition)) continue;
            ScheduleSearchCondition con = (ScheduleSearchCondition)cond;
            ISearchType type = con.getType();
            Object value = con.getValue();
            if (type == ScheduleSearchCondition.CONDITION.TYPE_SINGLEDATE) {
                date = (Date)value;
                continue;
            }
            if (type == ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME) {
                this.idToSee = (IObjectIndex)value;
                continue;
            }
            if (type != ScheduleSearchCondition.CONDITION.TYPE_OID) continue;
            oid = (ExchewsObjectIndex)((Object)value);
        }
        if (oid != null) {
            IScheduleDTO[] rc = new IScheduleDTO[]{this.getSchedule(acc, (IObjectIndex)oid)};
            return rc;
        }
        if (date == null) {
            throw new IncorrectData("Search condition for date must be defined.");
        }
        return this.getSchedulesByDate(acc, date);
    }

    public IObjectIndex updateSchedule(IAccountData acc, IScheduleDTO dto) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        if (dto == null) {
            throw new IncorrectData("dto null.");
        }
        if (dto.getOid() == null) {
            throw new IncorrectData("oid in updateItem should not be null");
        }
        super.setAccountData(acc);
        IObjectIndex oid = dto.getOid();
        super.updateItem((ItemIdType)oid.getIndex(), this.generateUpdateMap(dto));
        return oid;
    }

    protected UpdateItemMap generateUpdateMap(IScheduleDTO dto) throws IncorrectData {
        if (dto instanceof ExchewsScheduleDTO) {
            ExchewsScheduleDTO sche = (ExchewsScheduleDTO)dto;
            this.sendFlag = sche.getTo() != null || sche.getCc() != null || sche.getBcc() != null;
        }
        UpdateItemMap map = new UpdateItemMap();
        ItemType item = null;
        try {
            item = new ItemType();
            item.setSubject(dto.getSubject());
            map.put(UnindexedFieldURIType.ITEM_SUBJECT, item);
            item = new ItemType();
            BodyType value = new BodyType();
            value.setBodyType(BodyTypeType.TEXT);
            value.setValue(dto.getBody());
            item.setBody(value);
            map.put(UnindexedFieldURIType.ITEM_BODY, item);
            CalendarItemType citem = new CalendarItemType();
            XMLGregorianCalendar sdt = ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getStartDate());
            citem.setStart(sdt);
            map.put(UnindexedFieldURIType.CALENDAR_START, citem);
            citem = new CalendarItemType();
            XMLGregorianCalendar edt = ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getEndDate());
            citem.setEnd(edt);
            map.put(UnindexedFieldURIType.CALENDAR_END, citem);
            citem = new CalendarItemType();
            citem.setLocation(dto.getLocation());
            map.put(UnindexedFieldURIType.CALENDAR_LOCATION, citem);
        }
        catch (Exception e) {
            Log.error((String)"IScheduleDTO convert error.", (Throwable)e);
            throw new IncorrectData(e.getMessage());
        }
        return map;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        super.setAccountData(acc);
        this.sendMailPolicy = CalendarItemCreateOrDeleteOperationType.SEND_TO_ALL_AND_SAVE_COPY;
        super.delete(oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return null;
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        return null;
    }

    public String getName() throws Exception {
        return null;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        DistinguishedFolderIdType src = new DistinguishedFolderIdType();
        switch (type) {
            case 1: {
                src.setId(EAIExchewsBase.shceduleElement);
                break;
            }
            case 2: {
                src.setId(EAIExchewsBase.shceduleElement);
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        folder = (IFolderIndex)this.populateFolder(new ExchewsFolderIndex(src)).getOid();
        return new BasicSearchDestination(db, folder);
    }

    public IStoreID getStoreID() throws Exception {
        return null;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return null;
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        return null;
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        return null;
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        if (data.isNew()) {
            return this.createNewSchedule(acc, (IScheduleDTO)data);
        }
        return this.updateSchedule(acc, (IScheduleDTO)data);
    }

    @Override
    protected UnindexedFieldURIType getDateField() {
        return UnindexedFieldURIType.CALENDAR_START;
    }

    @Override
    protected TargetFolderIdType getTargetFolder() {
        TargetFolderIdType target = new TargetFolderIdType();
        DistinguishedFolderIdType id = new DistinguishedFolderIdType();
        id.setId(EAIExchewsBase.shceduleElement);
        target.setDistinguishedFolderId(id);
        return target;
    }
}

