/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.messages.ExchangeServicePortType;
import com.microsoft.schemas.exchange.services._2006.messages.ExchangeServices;
import com.microsoft.schemas.exchange.services._2006.messages.FindFolderResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.FindFolderResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemType;
import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderType;
import com.microsoft.schemas.exchange.services._2006.types.DefaultShapeNamesType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.FolderResponseShapeType;
import com.microsoft.schemas.exchange.services._2006.types.FolderType;
import com.microsoft.schemas.exchange.services._2006.types.IndexBasePointType;
import com.microsoft.schemas.exchange.services._2006.types.IndexedPageViewType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MessageType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfBaseFolderIdsType;
import com.microsoft.schemas.exchange.services._2006.types.ResponseClassType;
import com.microsoft.schemas.exchange.services._2006.types.TargetFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import jp.co.connectone.eai.exchews.ews.EWSSearchFormula;
import jp.co.connectone.eai.exchews.ews.IEwsSearchFormula;
import jp.co.connectone.eai.exchews.log.LogAspect;
import jp.co.connectone.eai.exchews.store.EAIExchewsBase;
import jp.co.connectone.eai.exchews.store.ExchewsFolderIndex;
import jp.co.connectone.eai.exchews.store.ExchewsFolderMetadata;
import jp.co.connectone.eai.exchews.store.ExchewsMailDTO;
import jp.co.connectone.eai.exchews.store.ExchewsObjectIndex;
import jp.co.connectone.eai.exchews.store.ExchewsServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ExchewsMailStoreImpl
extends EAIExchewsBase
implements IMailStore {
    public static final List<String> SEARCH_FIELDS_HEADERS;
    public static final IStoreID storeID;
    protected static final String itemType = "IPM.Note";
    public static final String storeName = "Exchange EWS mail store";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ExchewsMailStoreImpl.ajc$preClinit();
        SEARCH_FIELDS_HEADERS = IEwsSearchFormula.ALL_PROPERTIES;
        storeID = new SimpleStoreID(ExchewsMailStoreImpl.class.getName());
    }

    public void deleteMail(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        try {
            this.delete(acc, null, oid);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)((Object)e);
            }
            throw new HandleException((Throwable)e);
        }
    }

    public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        super.setAccountData(acc);
        return null;
    }

    public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        super.setAccountData(acc);
        ExchewsFolderIndex idx = (ExchewsFolderIndex)dest.getFolder();
        BaseFolderIdType src = (BaseFolderIdType)idx.getIndex();
        FindItemType finder = new FindItemType();
        FolderResponseShapeType folderShape = new FolderResponseShapeType();
        folderShape.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);
        IndexedPageViewType index = new IndexedPageViewType();
        index.setBasePoint(IndexBasePointType.BEGINNING);
        index.setOffset(0);
        finder.setIndexedPageItemView(index);
        NonEmptyArrayOfBaseFolderIdsType folderIds = new NonEmptyArrayOfBaseFolderIdsType();
        List ids = folderIds.getFolderIdOrDistinguishedFolderId();
        ids.add(src);
        finder.setParentFolderIds(folderIds);
        FindFolderResponseType findFolderResponse = new FindFolderResponseType();
        Holder responseHolder = new Holder((Object)findFolderResponse);
        ExchangeServicePortType proxy = null;
        ArrayList<BaseFolderType> mailFolders = new ArrayList<BaseFolderType>();
        List responses = null;
        try {
            ExchangeServices service = new ExchangeServices();
            proxy = service.getExchangeServicePort();
            BindingProvider bp = (BindingProvider)proxy;
            Map map = bp.getRequestContext();
            map.put("javax.xml.ws.security.auth.username", String.valueOf(this.domain) + "\\" + this.userID);
            map.put("javax.xml.ws.security.auth.password", this.password);
            map.put("javax.xml.ws.service.endpoint.address", this.endPointUri);
            responses = ((FindFolderResponseType)responseHolder.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    Log.warn((String)("Get Child Folders Response Error: " + response.getMessageText()));
                    continue;
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    Log.warn((String)("Get Child Folders Response Warning: " + response.getMessageText()));
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                FindFolderResponseMessageType findResponse = (FindFolderResponseMessageType)response;
                List allFolders = findResponse.getRootFolder().getFolders().getFolderOrCalendarFolderOrContactsFolder();
                for (BaseFolderType folder : allFolders) {
                    String string = "folder name:" + folder.getDisplayName();
                    ExchewsMailStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
                    String string2 = "number of child folders" + folder.getChildFolderCount();
                    ExchewsMailStoreImpl.debug_aroundBody3$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_1);
                    mailFolders.add(folder);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception Performing getChildFolders", e);
        }
        return null;
    }

    public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        super.setAccountData(acc);
        MessageType message = (MessageType)this.getItem(dest, (ItemIdType)oid.getIndex());
        ExchewsMailDTO rc = null;
        try {
            rc = ExchewsMailDTO.convertFromMessageType(message);
            if (rc != null && message.isHasAttachments().booleanValue()) {
                rc.convertAndSetEWSAttachments(this.getAttachments((ItemType)message));
            }
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"mail convert error", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        return rc;
    }

    public FolderMetadata[] getMailFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        FolderMetadata[] folders = null;
        try {
            folders = this.getFolderList(acc, dest);
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
        return folders;
    }

    public IMailDTO[] getMailsByDate(IAccountData acc, ISearchFormula search, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        super.setAccountData(acc);
        ExchewsMailDTO[] dtos = new ExchewsMailDTO[1];
        List<Object> messages = new ArrayList();
        try {
            messages = super.searchByDate(search.getDest(), search.getFieldsToGet(), search.getSearchConditions(), date, itemType);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        ArrayList<ExchewsMailDTO> rc = new ArrayList<ExchewsMailDTO>();
        for (ItemType itemType : messages) {
            try {
                ExchewsMailDTO dto = ExchewsMailDTO.convertFromMessageType((MessageType)itemType);
                rc.add(dto);
                if (!itemType.isHasAttachments().booleanValue()) continue;
                dto.convertAndSetEWSAttachments(this.getAttachments(itemType));
            }
            catch (Exception e) {
                Log.debug((String)"error on converting MessageType to ExchewsMailDTO. skip one data..", (Throwable)e);
            }
        }
        return rc.toArray(dtos);
    }

    public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        SearchConditionCollection cond = this.getDateSearchCondition(UnindexedFieldURIType.ITEM_DATE_TIME_RECEIVED, date);
        List<String> fieldsToGet = SEARCH_FIELDS_HEADERS;
        EWSSearchFormula form = null;
        try {
            form = new EWSSearchFormula(dest, fieldsToGet, cond);
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException();
        }
        return this.getMailsByDate(acc, form, date);
    }

    public IMailDTO[] getSentMails(IAccountData acc) throws ServerDown, HandleException {
        super.setAccountData(acc);
        return null;
    }

    public IMailDTO[] getSentMailsByDate(IAccountData acc, Date date) throws ServerDown, HandleException {
        super.setAccountData(acc);
        return null;
    }

    public IObjectIndex[] getUIDLs(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        super.setAccountData(acc);
        return null;
    }

    public IObjectIndex[] getUIDLsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        super.setAccountData(acc);
        return null;
    }

    public IObjectIndex sendMail(IAccountData acc, IMailDTO dto) throws NoSuchRights, ServerDown, IncorrectData, HandleException {
        IObjectIndex rc = null;
        ISearchDestination dst = this.getPresetDestination(acc, 3);
        try {
            rc = this.write(acc, dst, (IRecordObject)dto);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
        return rc;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        super.delete(oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        super.setAccountData(acc);
        return null;
    }

    @Override
    public IRecordObject getFolderIndexFromString(String idx) throws IncorrectData {
        return null;
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        super.setAccountData(acc);
        ExchewsFolderIndex idx = (ExchewsFolderIndex)dest.getFolder();
        BaseFolderIdType src = (BaseFolderIdType)idx.getIndex();
        List<BaseFolderType> folders = super.getAllSubFolders(src, 0);
        ArrayList<ExchewsFolderMetadata> rc = new ArrayList<ExchewsFolderMetadata>();
        ExchewsFolderMetadata[] a = new ExchewsFolderMetadata[]{};
        for (BaseFolderType folder : folders) {
            rc.add(ExchewsFolderMetadata.convertFromEWSFolderType((FolderType)folder));
        }
        return rc.toArray(a);
    }

    public String getName() throws Exception {
        return storeName;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int dest) throws IncorrectData, HandleException {
        super.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        DistinguishedFolderIdType src = new DistinguishedFolderIdType();
        switch (dest) {
            case 1: {
                src.setId(EAIExchewsBase.inboxElement);
                break;
            }
            case 2: {
                src.setId(EAIExchewsBase.sentboxElement);
                break;
            }
            case 3: {
                src.setId(EAIExchewsBase.draftElement);
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        folder = (IFolderIndex)this.populateFolder(new ExchewsFolderIndex(src)).getOid();
        return new BasicSearchDestination(db, folder);
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new ExchewsServiceInfo(storeID, storeName);
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData data) throws Exception {
        return super.getServiceInfo(storeID, storeName, data);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getMail(acc, dest, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula frm) throws Exception {
        return null;
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        return this.getMailsByDate(acc, dest, date);
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject dto) throws Exception {
        MessageType item;
        ExchewsObjectIndex rc = null;
        if (dto == null) {
            throw new NullPointerException("dto must not be null.");
        }
        if (dest == null) {
            throw new NullPointerException("dest must not be null.");
        }
        IFolderIndex folder = dest.getFolder();
        if (folder == null) {
            throw new NullPointerException("destination folder must not be null.");
        }
        DistinguishedFolderIdType element = (DistinguishedFolderIdType)folder.getIndex();
        if (acc == null) {
            throw new NullPointerException("acc must not be null.");
        }
        super.setAccountData(acc);
        IMailDTO mail = (IMailDTO)dto;
        try {
            item = ExchewsMailDTO.convertToMessageType(mail);
        }
        catch (Exception e) {
            Log.error((String)"MailDTO convert error.", (Throwable)e);
            throw new IncorrectData(e.getMessage());
        }
        item = super.createItem(element.getId(), (ItemType)item);
        ItemIdType itemId = item.getItemId();
        ExchewsObjectIndex oid = new ExchewsObjectIndex(itemId);
        AttachmentDTO[] atts = mail.getAttachments();
        if (atts != null && atts.length > 0) {
            super.addAttach(itemId, atts);
        }
        if (oid == null) {
            throw new HandleException("failed to save mail to the server.");
        }
        boolean success = super.sendSavedMsg(itemId, (DistinguishedFolderIdType)this.getPresetDestination(acc, 2).getFolder().getIndex());
        if (success) {
            rc = oid;
        }
        return rc;
    }

    @Override
    protected UnindexedFieldURIType getDateField() {
        return UnindexedFieldURIType.ITEM_DATE_TIME_RECEIVED;
    }

    @Override
    protected TargetFolderIdType getTargetFolder() {
        TargetFolderIdType target = new TargetFolderIdType();
        DistinguishedFolderIdType id = new DistinguishedFolderIdType();
        id.setId(EAIExchewsBase.inboxElement);
        target.setDistinguishedFolderId(id);
        return target;
    }

    private static final /* synthetic */ void debug_aroundBody0(ExchewsMailStoreImpl exchewsMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(ExchewsMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(ExchewsMailStoreImpl exchewsMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(ExchewsMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExchewsMailStoreImpl.java", Class.forName("jp.co.connectone.eai.exchews.store.ExchewsMailStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 111);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 112);
    }
}

