/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.ArrayOfStringsType;
import com.microsoft.schemas.exchange.services._2006.types.ContactItemType;
import com.microsoft.schemas.exchange.services._2006.types.EmailAddressDictionaryEntryType;
import com.microsoft.schemas.exchange.services._2006.types.EmailAddressDictionaryType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.PhoneNumberDictionaryEntryType;
import com.microsoft.schemas.exchange.services._2006.types.PhoneNumberDictionaryType;
import com.microsoft.schemas.exchange.services._2006.types.PhysicalAddressDictionaryEntryType;
import com.microsoft.schemas.exchange.services._2006.types.PhysicalAddressDictionaryType;
import java.util.Iterator;
import jp.co.connectone.eai.exchews.ews.IEwsDTOType;
import jp.co.connectone.eai.exchews.log.LogAspect;
import jp.co.connectone.eai.exchews.store.ExchewsItemBase;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.IAddressDTO;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ExchewsAddressDTO
extends ExchewsItemBase
implements IAddressDTO,
IEwsDTOType {
    private static final long serialVersionUID = 1L;
    protected String displayName;
    protected String companyName;
    protected String surName;
    protected String givenName;
    protected String middleName;
    protected String email;
    protected String companyPhone;
    protected String homePhone;
    protected String mobilePhone;
    protected String companyAddress;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public static ExchewsAddressDTO convertFromContactItemType(ContactItemType msg) throws Exception {
        EmailAddressDictionaryType addrs;
        ArrayOfStringsType companies;
        PhysicalAddressDictionaryType phAddr;
        if (msg == null) {
            return null;
        }
        ExchewsAddressDTO rc = new ExchewsAddressDTO();
        ExchewsAddressDTO.convertFromItemType(rc, (ItemType)msg);
        PhoneNumberDictionaryType phones = msg.getPhoneNumbers();
        if (phones != null) {
            for (PhoneNumberDictionaryEntryType ph : phones.getEntry()) {
                switch (ph.getKey()) {
                    case HOME_PHONE: {
                        rc.homePhone = ph.getValue();
                        break;
                    }
                    case BUSINESS_PHONE: {
                        rc.companyPhone = ph.getValue();
                        break;
                    }
                    case MOBILE_PHONE: {
                        rc.mobilePhone = ph.getValue();
                    }
                }
            }
        }
        if ((phAddr = msg.getPhysicalAddresses()) != null) {
            for (PhysicalAddressDictionaryEntryType entry : phAddr.getEntry()) {
                switch (entry.getKey()) {
                    case BUSINESS: {
                        rc.companyAddress = String.valueOf(entry.getPostalCode()) + " " + entry.getState() + " " + entry.getCity() + " " + entry.getStreet() + "," + entry.getCountryOrRegion();
                    }
                }
            }
        }
        if ((companies = msg.getCompanies()) != null) {
            Iterator iterator = companies.getString().iterator();
            while (iterator.hasNext()) {
                String company;
                String string = company = (String)iterator.next();
                ExchewsAddressDTO.trace_aroundBody1$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            }
        }
        rc.companyName = msg.getCompanyName();
        rc.displayName = msg.getFileAs();
        if (rc.displayName == null) {
            rc.displayName = msg.getDisplayName();
        }
        if ((addrs = msg.getEmailAddresses()) != null) {
            for (EmailAddressDictionaryEntryType addr : addrs.getEntry()) {
                String value = addr.getValue();
                if (value == null) continue;
                rc.email = value;
                break;
            }
        }
        rc.givenName = msg.getGivenName();
        rc.middleName = msg.getMiddleName();
        rc.surName = msg.getSurname();
        rc.setBeanData();
        return rc;
    }

    public void copy(IAddressDTO src) {
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCompanyPhone() {
        return this.companyPhone;
    }

    public void setCompanyPhone(String companyPhone) {
        this.companyPhone = companyPhone;
    }

    public String getHomePhone() {
        return this.homePhone;
    }

    public void setHomePhone(String homePhone) {
        this.homePhone = homePhone;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getCompanyAddress() {
        return this.companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFamilyName() {
        return this.surName;
    }

    public String getFirstName() {
        return this.givenName;
    }

    public String getTid() {
        return null;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFamilyName(String familyName) {
        this.surName = familyName;
    }

    public void setFirstName(String firstName) {
        this.givenName = firstName;
    }

    public void setTid(String tid) {
    }

    static {
        ExchewsAddressDTO.ajc$preClinit();
    }

    private static final /* synthetic */ void trace_aroundBody0(String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody1$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExchewsAddressDTO.java", Class.forName("jp.co.connectone.eai.exchews.store.ExchewsAddressDTO"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 73);
    }
}

