/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.BaseFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderType;
import com.microsoft.schemas.exchange.services._2006.types.ContactItemType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.FolderType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.TargetFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import jp.co.connectone.common.ADTool;
import jp.co.connectone.common.MailTool;
import jp.co.connectone.eai.exchews.ews.EWSSearchCondition;
import jp.co.connectone.eai.exchews.ews.EWSSearchOperator;
import jp.co.connectone.eai.exchews.ews.EWSSearchType;
import jp.co.connectone.eai.exchews.ews.EWS_CONTAINS_SearchConditionCollection;
import jp.co.connectone.eai.exchews.log.LogAspect;
import jp.co.connectone.eai.exchews.store.EAIExchewsBase;
import jp.co.connectone.eai.exchews.store.ExchewsAddressDTO;
import jp.co.connectone.eai.exchews.store.ExchewsDatabaseIndex;
import jp.co.connectone.eai.exchews.store.ExchewsFolderIndex;
import jp.co.connectone.eai.exchews.store.ExchewsFolderMetadata;
import jp.co.connectone.eai.exchews.store.ExchewsObjectIndex;
import jp.co.connectone.eai.exchews.store.ExchewsServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.DatabaseMetadata;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchCondition;
import jp.co.connectone.store.ISearchConditionElement;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.ISearchType;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.client.AddressBookSearchCondition;
import jp.co.connectone.store.pim.BasicAddressDTO;
import jp.co.connectone.store.pim.IAddressBookStore;
import jp.co.connectone.store.pim.IAddressDTO;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ExchewsAddressBookStoreImpl
extends EAIExchewsBase
implements IAddressBookStore {
    public static final IStoreID storeID;
    public static final String storeName = "Exchange EWS addressbook store";
    protected static final String itemType = "IPM.Contact";
    protected String adAddress;
    protected String adAddress2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        ExchewsAddressBookStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(ExchewsAddressBookStoreImpl.class.getName());
    }

    public ExchewsAddressBookStoreImpl() {
        this.includeMimeContent = false;
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new ExchewsServiceInfo(storeID, storeName);
    }

    @Override
    protected void setAccountData(IAccountData acc) throws HandleException {
        ExchewsServiceInfo si = (ExchewsServiceInfo)acc.getServiceInfo();
        this.adAddress = si.getAdAddress();
        this.adAddress2 = si.getAdAddress2();
        super.setAccountData(acc);
    }

    @Override
    protected UnindexedFieldURIType getDateField() {
        return UnindexedFieldURIType.ITEM_DATE_TIME_CREATED;
    }

    @Override
    protected TargetFolderIdType getTargetFolder() {
        TargetFolderIdType target = new TargetFolderIdType();
        DistinguishedFolderIdType id = new DistinguishedFolderIdType();
        id.setId(EAIExchewsBase.addressbookElement);
        target.setDistinguishedFolderId(id);
        return target;
    }

    public IObjectIndex createNewAddressBookItem(IAccountData acc, ISearchDestination dest, IAddressDTO addressBookDTO) throws IncorrectStore, ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void deleteAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public IAddressDTO getAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        ExchewsAddressDTO l_objIAddressDTO = null;
        String string = "getAddressBookItem::oid=" + oid;
        ExchewsAddressBookStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        this.setAccountData(acc);
        if (dest.getDatabase() != null) {
            SearchConditionCollection conds = new SearchConditionCollection();
            AddressBookSearchCondition cond = new AddressBookSearchCondition((ISearchType)AddressBookSearchCondition.CONDITION.TYPE_ACCOUNTNAME, (Object)oid.getIndex().toString());
            conds.add((ISearchConditionElement)cond);
            List<HashMap<String, String>> col = this.searchUserFromActiveDirectory(conds);
            if (col.size() == 0) {
                throw new DataNotFound("account that has sAMAAccountName=" + oid.getIndex().toString() + " not found.");
            }
            l_objIAddressDTO = this.populateAddressDTOG(col.get(0));
        } else {
            ContactItemType contact = (ContactItemType)this.getItem(dest, (ItemIdType)oid.getIndex());
            ExchewsAddressDTO rc = null;
            try {
                rc = ExchewsAddressDTO.convertFromContactItemType(contact);
            }
            catch (HandleException he) {
                throw he;
            }
            catch (Exception e) {
                Log.error((String)"address convert error", (Throwable)e);
                throw new HandleException((Throwable)e);
            }
            l_objIAddressDTO = rc;
        }
        return l_objIAddressDTO;
    }

    public IAddressDTO[] getAddressBookItems(IAccountData acc, ISearchDestination dest) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public IAddressDTO[] searchAddressBook(IAccountData acc, ISearchFormula conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        if (conds.getDest().getDatabase() != null) {
            String string = "search from active directory";
            ExchewsAddressBookStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
            return this.searchActiveDirectory(acc, conds.getSearchConditions());
        }
        return this.searchPersonalAddressbook(acc, conds);
    }

    public IObjectIndex updateAddressBookItem(IAccountData acc, ISearchDestination dest, IAddressDTO addressBookDTO) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getAddressBookItems(acc, dest);
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        super.setAccountData(acc);
        ExchewsFolderIndex idx = (ExchewsFolderIndex)dest.getFolder();
        BaseFolderIdType src = (BaseFolderIdType)idx.getIndex();
        List<BaseFolderType> folders = super.getAllSubFolders(src, 0);
        ArrayList<ExchewsFolderMetadata> rc = new ArrayList<ExchewsFolderMetadata>();
        ExchewsFolderMetadata[] a = new ExchewsFolderMetadata[]{};
        for (BaseFolderType folder : folders) {
            rc.add(ExchewsFolderMetadata.convertFromEWSFolderType((FolderType)folder));
        }
        return rc.toArray(a);
    }

    public String getName() throws Exception {
        return storeName;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        switch (type) {
            case 1: {
                DistinguishedFolderIdType src = new DistinguishedFolderIdType();
                src.setId(EAIExchewsBase.addressbookElement);
                folder = (IFolderIndex)this.populateFolder(new ExchewsFolderIndex(src)).getOid();
                break;
            }
            case 2: {
                db = (IDatabaseIndex)this.populateADDatabase().getOid();
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    protected DatabaseMetadata populateADDatabase() {
        DatabaseMetadata db = new DatabaseMetadata();
        db.setServerName(this.adAddress);
        ExchewsDatabaseIndex oid = new ExchewsDatabaseIndex("connector_exchews:ActiveDirectory." + this.adAddress);
        db.setOid((IObjectIndex)oid);
        HashMap h = db.getFieldSet();
        h.put("oid", oid);
        return db;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getAddressBookItem(acc, dest, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula conds) throws Exception {
        return this.searchAddressBook(acc, conds);
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private IAddressDTO populateAddressDTOG(HashMap<String, String> itemList) {
        String streetAddress;
        String l;
        BasicAddressDTO l_objIAddressDTO = new BasicAddressDTO();
        String tid = itemList.get("userPrincipalName");
        if (tid == null) {
            tid = "";
        }
        l_objIAddressDTO.setTid(tid.replaceAll("@", "."));
        l_objIAddressDTO.setOid((IObjectIndex)new ExchewsObjectIndex(itemList.get("sAMAccountName")));
        l_objIAddressDTO.setFirstName(itemList.get("givenName"));
        l_objIAddressDTO.setFamilyName(itemList.get("sn"));
        l_objIAddressDTO.setEmail(itemList.get("mail"));
        l_objIAddressDTO.setCompanyPhone(itemList.get("telephoneNumber"));
        l_objIAddressDTO.setHomePhone(itemList.get("homePhone"));
        l_objIAddressDTO.setMobilePhone(itemList.get("mobile"));
        l_objIAddressDTO.setCompanyName(itemList.get("company"));
        l_objIAddressDTO.setDisplayName(itemList.get("displayName"));
        String string = "displayName=" + itemList.get("displayName");
        ExchewsAddressBookStoreImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
        String st = itemList.get("st");
        if (st == null) {
            st = "";
        }
        if ((l = itemList.get("l")) == null) {
            l = "";
        }
        if ((streetAddress = itemList.get("streetAddress")) == null) {
            streetAddress = "";
        }
        l_objIAddressDTO.setCompanyAddress(String.valueOf(st) + l + streetAddress);
        return l_objIAddressDTO;
    }

    private IAddressDTO[] searchActiveDirectory(IAccountData acc, SearchConditionCollection conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        this.setAccountData(acc);
        List<HashMap<String, String>> col = this.searchUserFromActiveDirectory(conds);
        int len = col.size();
        String string = "results(searchUserFromActiveDirectory):" + len;
        ExchewsAddressBookStoreImpl.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
        IAddressDTO[] l_IAddressDTOArray = new IAddressDTO[]{};
        ArrayList<IAddressDTO> ar = new ArrayList<IAddressDTO>();
        int i = 0;
        while (i < len) {
            block4: {
                IAddressDTO dto = null;
                try {
                    dto = this.populateAddressDTOG(col.get(i));
                }
                catch (Exception e) {
                    Log.error((String)("IAddressDTO populate error:Igunore address data no " + i), (Throwable)e);
                    break block4;
                }
                if (dto.getOid().getIndex() != null) {
                    ar.add(dto);
                }
            }
            ++i;
        }
        l_IAddressDTOArray = ar.toArray(l_IAddressDTOArray);
        return l_IAddressDTOArray;
    }

    protected List<HashMap<String, String>> searchUserFromActiveDirectory(SearchConditionCollection conds) throws NullPointerException, ServerDown, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.adAddress == null) {
            throw new NullPointerException("set adAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        Iterator it = conds.iterator();
        ISearchCondition cond = null;
        String whereStr = "";
        while (it.hasNext()) {
            ISearchConditionElement elem = (ISearchConditionElement)it.next();
            cond = (ISearchCondition)elem;
            String string = "condition:" + cond.getType() + ":" + cond.getValue();
            ExchewsAddressBookStoreImpl.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        }
        if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME) {
            whereStr = " (displayName=" + cond.getValue() + "*) ";
        } else if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME) {
            whereStr = " (sn=*" + cond.getValue() + "*) ";
        } else if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_LASTNAME) {
            whereStr = " (givenName=*" + cond.getValue() + "*) ";
        } else if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_ACCOUNTNAME) {
            whereStr = " (sAMAccountName=" + cond.getValue() + ") ";
        } else {
            throw new HandleException("Illegal search type");
        }
        String string = "whereStr:" + whereStr;
        ExchewsAddressBookStoreImpl.debug_aroundBody11$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_5);
        ADTool ad = new ADTool();
        NamingEnumeration results = null;
        ArrayList<HashMap<String, String>> lists = new ArrayList<HashMap<String, String>>();
        try {
            results = ad.getUserDatas(this.userID, this.password, this.adAddress, this.adAddress2, this.domain, whereStr);
            while (results.hasMoreElements()) {
                String string2 = "LOOP FIRST LINE";
                ExchewsAddressBookStoreImpl.debug_aroundBody13$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_6);
                SearchResult aResult = (SearchResult)results.nextElement();
                String string3 = "name: " + aResult.getName();
                ExchewsAddressBookStoreImpl.debug_aroundBody15$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_7);
                Attributes attrs = aResult.getAttributes();
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                HashMap<String, String> list = new HashMap<String, String>();
                String string4 = "loop IN";
                ExchewsAddressBookStoreImpl.debug_aroundBody17$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_8);
                while (ae.hasMoreElements()) {
                    Attribute attr = (Attribute)ae.nextElement();
                    String strAttrID = attr.getID();
                    NamingEnumeration<?> e = attr.getAll();
                    String value = "";
                    while (e.hasMoreElements()) {
                        Object o = e.nextElement();
                        String string5 = "class of object(" + strAttrID + "):" + o.getClass();
                        ExchewsAddressBookStoreImpl.trace_aroundBody19$advice(this, string5, LogAspect.aspectOf(), string5, null, ajc$tjp_9);
                        if (!(o instanceof String)) continue;
                        value = (String)o;
                    }
                    String string6 = String.valueOf(strAttrID) + ": " + value;
                    ExchewsAddressBookStoreImpl.trace_aroundBody21$advice(this, string6, LogAspect.aspectOf(), string6, null, ajc$tjp_10);
                    list.put(strAttrID, value);
                }
                String string7 = "loop OUT";
                ExchewsAddressBookStoreImpl.debug_aroundBody23$advice(this, string7, LogAspect.aspectOf(), string7, null, ajc$tjp_11);
                lists.add(list);
                list = null;
                String string8 = "LOOP LAST LINE";
                ExchewsAddressBookStoreImpl.debug_aroundBody25$advice(this, string8, LogAspect.aspectOf(), string8, null, ajc$tjp_12);
            }
            String string9 = "no of accounts:" + lists.size();
            ExchewsAddressBookStoreImpl.debug_aroundBody27$advice(this, string9, LogAspect.aspectOf(), string9, null, ajc$tjp_13);
            results.close();
        }
        catch (AuthenticationException ae) {
            Log.error((String)("searchUserFromActiveDirectory:Authentication failed(" + ae.getMessage() + ")"), (Throwable)ae);
            throw new NoSuchRights("searchUserFromActiveDirectory:Authentication failed(" + ae.getMessage() + ")");
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new ServerDown(e.getMessage());
        }
        return lists;
    }

    protected SearchConditionCollection convertCondition(SearchConditionCollection searchConditions) throws IncorrectData {
        if (searchConditions == null) {
            return null;
        }
        if (searchConditions.size() != 1) {
            throw new IncorrectData("convertCondition currently accepts single condition only.");
        }
        ISearchConditionElement cond = (ISearchConditionElement)searchConditions.iterator().next();
        if (!(cond instanceof AddressBookSearchCondition)) {
            throw new IncorrectData("convertCondition accepts AddressBookSearchCondition only.");
        }
        EWS_CONTAINS_SearchConditionCollection rc = new EWS_CONTAINS_SearchConditionCollection();
        AddressBookSearchCondition adc = (AddressBookSearchCondition)cond;
        ISearchType type = adc.getType();
        String value = (String)adc.getValue();
        UnindexedFieldURIType field = null;
        if (AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME == type) {
            field = UnindexedFieldURIType.CONTACTS_DISPLAY_NAME;
        } else if (AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME == type) {
            field = UnindexedFieldURIType.CONTACTS_SURNAME;
        } else if (AddressBookSearchCondition.CONDITION.TYPE_LASTNAME == type) {
            field = UnindexedFieldURIType.CONTACTS_GIVEN_NAME;
        } else if (AddressBookSearchCondition.CONDITION.TYPE_ACCOUNTNAME == type) {
            throw new IncorrectData("CONTACT doesn't contain AccountName.");
        }
        EWSSearchCondition ews = new EWSSearchCondition(field, EWSSearchType.TYPE_STRING, (Object)value, EWSSearchOperator.OP_CONTAINS);
        rc.add((ISearchConditionElement)ews);
        return rc;
    }

    protected IAddressDTO[] searchPersonalAddressbook(IAccountData acc, ISearchFormula conds) throws HandleException {
        super.setAccountData(acc);
        IAddressDTO[] dtos = new IAddressDTO[1];
        List<Object> messages = new ArrayList();
        try {
            messages = super.search(conds.getDest(), conds.getFieldsToGet(), this.convertCondition(conds.getSearchConditions()));
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        ArrayList<ExchewsAddressDTO> rc = new ArrayList<ExchewsAddressDTO>();
        MailTool tool = new MailTool();
        tool.setAllowNullOrBlankMailAddress(false);
        for (ItemType itemType : messages) {
            try {
                ExchewsAddressDTO dto = ExchewsAddressDTO.convertFromContactItemType((ContactItemType)itemType);
                MailAddress address = new MailAddress(dto.getEmail());
                if (!tool.checkAddressFormat(address)) continue;
                rc.add(dto);
                itemType.isHasAttachments().booleanValue();
            }
            catch (Exception e) {
                Log.debug((String)"error on converting MessageType to ExchewsMailDTO. skip one data..", (Throwable)e);
            }
        }
        return rc.toArray(dtos);
    }

    private static final /* synthetic */ void debug_aroundBody0(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody12(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody13$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody14(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody15$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody16(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody17$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody18(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody19$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody20(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody21$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody22(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody23$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody24(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody25$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody26(ExchewsAddressBookStoreImpl exchewsAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody27$advice(ExchewsAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExchewsAddressBookStoreImpl.java", Class.forName("jp.co.connectone.eai.exchews.store.ExchewsAddressBookStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 86);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 127);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 360);
        ajc$tjp_11 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 363);
        ajc$tjp_12 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 366);
        ajc$tjp_13 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 368);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 265);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 284);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 317);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 334);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 341);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 343);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 347);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 355);
    }
}

