/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.messages.AttachmentInfoResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.BaseRequestType;
import com.microsoft.schemas.exchange.services._2006.messages.CreateAttachmentResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.CreateAttachmentType;
import com.microsoft.schemas.exchange.services._2006.messages.CreateItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.CreateItemType;
import com.microsoft.schemas.exchange.services._2006.messages.DeleteItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.DeleteItemType;
import com.microsoft.schemas.exchange.services._2006.messages.ExchangeServicePortType;
import com.microsoft.schemas.exchange.services._2006.messages.ExchangeServices;
import com.microsoft.schemas.exchange.services._2006.messages.FindFolderResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.FindFolderResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.FindFolderType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemType;
import com.microsoft.schemas.exchange.services._2006.messages.GetAttachmentResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.GetAttachmentType;
import com.microsoft.schemas.exchange.services._2006.messages.GetItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.GetItemType;
import com.microsoft.schemas.exchange.services._2006.messages.ItemInfoResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SendItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.SendItemType;
import com.microsoft.schemas.exchange.services._2006.messages.UpdateItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.UpdateItemType;
import com.microsoft.schemas.exchange.services._2006.types.AffectedTaskOccurrencesType;
import com.microsoft.schemas.exchange.services._2006.types.AttachmentResponseShapeType;
import com.microsoft.schemas.exchange.services._2006.types.AttachmentType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderType;
import com.microsoft.schemas.exchange.services._2006.types.BodyTypeResponseType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemCreateOrDeleteOperationType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarViewType;
import com.microsoft.schemas.exchange.services._2006.types.ConflictResolutionType;
import com.microsoft.schemas.exchange.services._2006.types.DefaultShapeNamesType;
import com.microsoft.schemas.exchange.services._2006.types.DisposalType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdNameType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.EmailAddressType;
import com.microsoft.schemas.exchange.services._2006.types.ExchangeVersionType;
import com.microsoft.schemas.exchange.services._2006.types.FileAttachmentType;
import com.microsoft.schemas.exchange.services._2006.types.FolderQueryTraversalType;
import com.microsoft.schemas.exchange.services._2006.types.FolderResponseShapeType;
import com.microsoft.schemas.exchange.services._2006.types.IndexedPageViewType;
import com.microsoft.schemas.exchange.services._2006.types.ItemChangeType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemQueryTraversalType;
import com.microsoft.schemas.exchange.services._2006.types.ItemResponseShapeType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MessageDispositionType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfAllItemsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfAttachmentsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfBaseFolderIdsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfBaseItemIdsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfItemChangeDescriptionsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfItemChangesType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfPathsToElementType;
import com.microsoft.schemas.exchange.services._2006.types.ObjectFactory;
import com.microsoft.schemas.exchange.services._2006.types.PathToUnindexedFieldType;
import com.microsoft.schemas.exchange.services._2006.types.RequestServerVersion;
import com.microsoft.schemas.exchange.services._2006.types.ResponseClassType;
import com.microsoft.schemas.exchange.services._2006.types.RestrictionType;
import com.microsoft.schemas.exchange.services._2006.types.SearchExpressionType;
import com.microsoft.schemas.exchange.services._2006.types.ServerVersionInfo;
import com.microsoft.schemas.exchange.services._2006.types.SetItemFieldType;
import com.microsoft.schemas.exchange.services._2006.types.TargetFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.TimeZoneContextType;
import com.microsoft.schemas.exchange.services._2006.types.TimeZoneDefinitionType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import jp.co.connectone.eai.exchews.ews.EWSSearchCondition;
import jp.co.connectone.eai.exchews.ews.EWSSearchConditionCollection;
import jp.co.connectone.eai.exchews.ews.EWSSearchOperator;
import jp.co.connectone.eai.exchews.ews.EWSSearchType;
import jp.co.connectone.eai.exchews.ews.EWS_AND_SearchConditionCollection;
import jp.co.connectone.eai.exchews.ews.UpdateItemMap;
import jp.co.connectone.eai.exchews.log.LogAspect;
import jp.co.connectone.eai.exchews.ssl.NoSecurityHostnameVerifier;
import jp.co.connectone.eai.exchews.ssl.NoSecuritySSLSocketFactory;
import jp.co.connectone.eai.exchews.store.ExchewsFolderIndex;
import jp.co.connectone.eai.exchews.store.ExchewsServiceInfo;
import jp.co.connectone.eai.exchews.user.ExchewsAccountData;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchConditionElement;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.user.IAccountData;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class EAIExchewsBase {
    protected static final ObjectFactory typesObjectFactory;
    protected boolean includeMimeContent = true;
    protected static final DistinguishedFolderIdNameType rootElement;
    protected static final DistinguishedFolderIdNameType inboxElement;
    protected static final DistinguishedFolderIdNameType shceduleElement;
    protected static final DistinguishedFolderIdNameType addressbookElement;
    protected static final DistinguishedFolderIdNameType deletedItemsElement;
    protected static final DistinguishedFolderIdNameType draftElement;
    protected static final DistinguishedFolderIdNameType memoElement;
    protected static final DistinguishedFolderIdNameType sentboxElement;
    protected static final DistinguishedFolderIdNameType taskElement;
    protected static final DistinguishedFolderIdNameType jumkElement;
    protected static final String HTTP_PROTOCOL_PREFIX = "http://";
    protected static final String SSL_PROTOCOL_PREFIX = "https://";
    protected static final String DEFAULT_PROTOCOL_PREFIX = "https://";
    protected static final RequestServerVersion version;
    protected static final TimeZoneContextType tzct;
    protected String protocolPrefix = "https://";
    protected ServerVersionInfo serverVersion = new ServerVersionInfo();
    protected Holder<ServerVersionInfo> serverVersionHolder = new Holder((Object)this.serverVersion);
    protected CalendarItemCreateOrDeleteOperationType sendMailPolicy = null;
    protected IObjectIndex idToSee = null;
    protected String endPointUri;
    protected String path;
    protected String userID;
    protected String password;
    protected String domain;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;

    static {
        EAIExchewsBase.ajc$preClinit();
        typesObjectFactory = new ObjectFactory();
        rootElement = DistinguishedFolderIdNameType.MSGFOLDERROOT;
        inboxElement = DistinguishedFolderIdNameType.INBOX;
        shceduleElement = DistinguishedFolderIdNameType.CALENDAR;
        addressbookElement = DistinguishedFolderIdNameType.CONTACTS;
        deletedItemsElement = DistinguishedFolderIdNameType.DELETEDITEMS;
        draftElement = DistinguishedFolderIdNameType.DRAFTS;
        memoElement = DistinguishedFolderIdNameType.NOTES;
        sentboxElement = DistinguishedFolderIdNameType.SENTITEMS;
        taskElement = DistinguishedFolderIdNameType.TASKS;
        jumkElement = DistinguishedFolderIdNameType.JUNKEMAIL;
        version = new RequestServerVersion();
        version.setVersion(ExchangeVersionType.EXCHANGE_2007_SP_1);
        HttpsURLConnection.setDefaultSSLSocketFactory(new NoSecuritySSLSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new NoSecurityHostnameVerifier());
        tzct = new TimeZoneContextType();
        TimeZoneDefinitionType tz = new TimeZoneDefinitionType();
        tz.setId("Tokyo Standard Time");
        tzct.setTimeZoneDefinition(tz);
    }

    protected abstract UnindexedFieldURIType getDateField();

    protected void setEndPointUri(ExchewsServiceInfo si) throws ServerDown, HandleException {
        this.endPointUri = si.getEndPointUri();
    }

    protected boolean sendSavedMsg(ItemIdType id, DistinguishedFolderIdType folder) throws HandleException, ServerDown, DataNotFound {
        boolean rc = false;
        SendItemType siSendItem = new SendItemType();
        NonEmptyArrayOfBaseItemIdsType ids = new NonEmptyArrayOfBaseItemIdsType();
        ids.getItemIdOrOccurrenceItemIdOrRecurringMasterItemId().add(id);
        siSendItem.setItemIds(ids);
        TargetFolderIdType target = new TargetFolderIdType();
        target.setDistinguishedFolderId(folder);
        siSendItem.setSavedItemFolderId(target);
        siSendItem.setSaveItemToFolder(true);
        Holder responseHolder = new Holder();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.sendItem(siSendItem, version, responseHolder, this.serverVersionHolder);
            List responses = null;
            SendItemResponseType siRes = (SendItemResponseType)responseHolder.value;
            responses = siRes.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement b : responses) {
                ResponseMessageType response = (ResponseMessageType)b.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    Log.warn((String)("Send Item Response Error: " + response.getMessageText()));
                    throw new IncorrectData(response.getMessageText());
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    Log.warn((String)("Send Item Response Warning: " + response.getMessageText()));
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "Send Item SUCCESS.";
                EAIExchewsBase.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
                rc = true;
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (IncorrectData icd) {
            throw icd;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
        return rc;
    }

    protected List<? extends ItemType> searchByDate(ISearchDestination dest, List<String> itemList, SearchConditionCollection conds, Date date, String itemType) throws NullPointerException, ServerDown, HandleException {
        NonEmptyArrayOfPathsToElementType props = ExchEWSTranslator.createAdditionalProperties(UnindexedFieldURIType.ITEM_ITEM_CLASS);
        ItemResponseShapeType irst = new ItemResponseShapeType();
        irst.setAdditionalProperties(props);
        irst.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);
        EWSSearchConditionCollection col = (EWSSearchConditionCollection)this.getDateSearchCondition(this.getDateField(), date);
        SearchExpressionType at = col.generateSearchExpression();
        FindItemType fit = new FindItemType();
        fit.setItemShape(irst);
        NonEmptyArrayOfBaseFolderIdsType folderIds = this.getEWSParamFolderIDs(dest);
        fit.setParentFolderIds(folderIds);
        fit.setTraversal(ItemQueryTraversalType.SHALLOW);
        if ("IPM.Appointment".equals(itemType)) {
            CalendarViewType calView = ExchEWSTranslator.createCalendarViewType(date);
            fit.setCalendarView(calView);
        } else {
            RestrictionType rt = ExchEWSTranslator.createRestriction(at);
            fit.setRestriction(rt);
        }
        FindItemResponseType findItemResponse = new FindItemResponseType();
        Holder responseHolder = new Holder((Object)findItemResponse);
        ArrayList<ItemType> messages = new ArrayList<ItemType>();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.findItem(fit, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            responses = ((FindItemResponseType)responseHolder.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
                    this.processResponseErrorCode(response);
                    continue;
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    String string = "Exchange Server returns Warning: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "findItem SUCCESS.";
                EAIExchewsBase.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
                FindItemResponseMessageType findResponse = (FindItemResponseMessageType)response;
                for (ItemType item : findResponse.getRootFolder().getItems().getItemOrMessageOrCalendarItem()) {
                    messages.add(item);
                }
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (NoSuchRights ne) {
            throw ne;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
        return messages;
    }

    private void processResponseErrorCode(ResponseMessageType response) throws ServerDown, NoSuchRights, HandleException {
        String code = response.getResponseCode();
        String message = response.getMessageText();
        String string = "ResponseCode:" + response;
        EAIExchewsBase.trace_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        if (code.indexOf("ErrorFolderNotFound") >= 0 || code.indexOf("ErrorMissingEmailAddress") >= 0 || code.indexOf("ErrorNonExistentMailbox") >= 0 || code.indexOf("ErrorAccessDenied") >= 0) {
            throw new NoSuchRights(code);
        }
        throw new HandleException("Exchange Server returns Error: " + message + "(" + code + ")");
    }

    private void processWebServiceException(WebServiceException wse) throws ServerDown, NoSuchRights {
        String msg = wse.getMessage();
        String string = "WebServiceException:" + msg;
        EAIExchewsBase.trace_aroundBody11$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_5);
        String string2 = msg = wse.getLocalizedMessage();
        EAIExchewsBase.trace_aroundBody13$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_6);
        String string3 = "class:" + ((Object)((Object)wse)).getClass();
        EAIExchewsBase.trace_aroundBody15$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_7);
        if (msg.indexOf("Authentication failure") >= 0 || msg.indexOf("401") >= 0 && msg.indexOf("Unauthorized") >= 0 || msg.indexOf("ErrorFolderNotFound") >= 0) {
            throw new NoSuchRights(msg);
        }
        if (msg.indexOf("timed out") >= 0) {
            throw new ServerDown(msg);
        }
        Throwable errCause = wse;
        int i = 0;
        while (i < 4) {
            if ((errCause = errCause.getCause()) == null) break;
            msg = errCause.getMessage();
            String string4 = "WebServiceException:" + msg;
            EAIExchewsBase.trace_aroundBody17$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_8);
            String string5 = msg = errCause.getLocalizedMessage();
            EAIExchewsBase.trace_aroundBody19$advice(this, string5, LogAspect.aspectOf(), string5, null, ajc$tjp_9);
            String string6 = "class:" + errCause.getClass();
            EAIExchewsBase.trace_aroundBody21$advice(this, string6, LogAspect.aspectOf(), string6, null, ajc$tjp_10);
            if (msg.indexOf("Authentication failure") >= 0 || msg.indexOf("401") >= 0 && msg.indexOf("Unauthorized") >= 0 || msg.indexOf("ErrorFolderNotFound") >= 0) {
                throw new NoSuchRights(msg);
            }
            if (msg.indexOf("timed out") >= 0) {
                throw new ServerDown(msg);
            }
            ++i;
        }
        Log.error((String)"error on processing EWS request", (Throwable)wse);
        throw wse;
    }

    protected List<? extends ItemType> search(ISearchDestination dest, List<String> itemList, SearchConditionCollection conds) throws NullPointerException, ServerDown, HandleException {
        FindItemType fit = new FindItemType();
        NonEmptyArrayOfPathsToElementType props = ExchEWSTranslator.createAdditionalProperties(UnindexedFieldURIType.ITEM_ITEM_CLASS);
        ItemResponseShapeType irst = new ItemResponseShapeType();
        irst.setAdditionalProperties(props);
        irst.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);
        EWSSearchConditionCollection col = (EWSSearchConditionCollection)conds;
        SearchExpressionType at = col.generateSearchExpression();
        if (at != null) {
            RestrictionType rt = ExchEWSTranslator.createRestriction(at);
            fit.setRestriction(rt);
        }
        fit.setItemShape(irst);
        NonEmptyArrayOfBaseFolderIdsType folderIds = this.getEWSParamFolderIDs(dest);
        fit.setParentFolderIds(folderIds);
        fit.setTraversal(ItemQueryTraversalType.SHALLOW);
        FindItemResponseType findItemResponse = new FindItemResponseType();
        Holder responseHolder = new Holder((Object)findItemResponse);
        ArrayList<ItemType> messages = new ArrayList<ItemType>();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.findItem(fit, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            responses = ((FindItemResponseType)responseHolder.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody23$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_11);
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    String string = "Exchange Server returns Warning: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody25$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_12);
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "findItem SUCCESS.";
                EAIExchewsBase.debug_aroundBody27$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_13);
                FindItemResponseMessageType findResponse = (FindItemResponseMessageType)response;
                for (ItemType item : findResponse.getRootFolder().getItems().getItemOrMessageOrCalendarItem()) {
                    messages.add(item);
                }
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
        return messages;
    }

    private void setEWSAuthParams(ExchangeServicePortType proxy) {
        BindingProvider bp = (BindingProvider)proxy;
        Map map = bp.getRequestContext();
        map.put("javax.xml.ws.security.auth.username", String.valueOf(this.userID) + "@" + this.domain);
        map.put("javax.xml.ws.security.auth.password", this.password);
        map.put("javax.xml.ws.service.endpoint.address", this.endPointUri);
        map.put("javax.xml.ws.http.request.headers", Collections.singletonMap("X-connectone-Version", Collections.singletonList("3.0-RC")));
    }

    private NonEmptyArrayOfBaseFolderIdsType getEWSParamFolderIDs(ISearchDestination dest) {
        BaseFolderIdType id = (BaseFolderIdType)dest.getFolder().getIndex();
        if (this.idToSee != null) {
            if (id instanceof DistinguishedFolderIdType) {
                EmailAddressType addr = new EmailAddressType();
                addr.setEmailAddress(this.idToSee.getIndex().toString());
                ((DistinguishedFolderIdType)id).setMailbox(addr);
            }
            this.idToSee = null;
        }
        NonEmptyArrayOfBaseFolderIdsType folderIds = ExchEWSTranslator.createFolderIds(id);
        return folderIds;
    }

    private List<BaseFolderType> getFirstChildlen(BaseFolderIdType parentFolder) throws ServerDown, NoSuchRights {
        FindFolderType finder = new FindFolderType();
        FolderResponseShapeType folderShape = new FolderResponseShapeType();
        folderShape.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);
        finder.setFolderShape(folderShape);
        finder.setTraversal(FolderQueryTraversalType.SHALLOW);
        IndexedPageViewType index = ExchEWSTranslator.createEWSParamPaging(0, 128);
        finder.setIndexedPageFolderView(index);
        NonEmptyArrayOfBaseFolderIdsType folderIds = ExchEWSTranslator.createFolderIds(parentFolder);
        finder.setParentFolderIds(folderIds);
        FindFolderResponseType findFolderResponse = new FindFolderResponseType();
        Holder responseHolder = new Holder((Object)findFolderResponse);
        ExchangeServicePortType proxy = null;
        ArrayList<BaseFolderType> mailFolders = new ArrayList<BaseFolderType>();
        List responses = null;
        try {
            ExchangeServices service = new ExchangeServices();
            proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.findFolder(finder, version, tzct, responseHolder, this.serverVersionHolder);
            responses = ((FindFolderResponseType)responseHolder.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    Log.warn((String)("Get Child Folders Response Error: " + response.getMessageText()));
                    this.processResponseErrorCode(response);
                    continue;
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    Log.warn((String)("Get Child Folders Response Warning: " + response.getMessageText()));
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "findFolder SUCCESS.";
                EAIExchewsBase.debug_aroundBody29$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_14);
                FindFolderResponseMessageType findResponse = (FindFolderResponseMessageType)response;
                List allFolders = findResponse.getRootFolder().getFolders().getFolderOrCalendarFolderOrContactsFolder();
                for (BaseFolderType folder : allFolders) {
                    String string2 = "folder name:" + folder.getDisplayName();
                    EAIExchewsBase.debug_aroundBody31$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_15);
                    String string3 = "number of child folders" + folder.getChildFolderCount();
                    EAIExchewsBase.debug_aroundBody33$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_16);
                    mailFolders.add(folder);
                }
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (NoSuchRights ne) {
            throw ne;
        }
        catch (Exception e) {
            Log.error((String)"Exception on getFirstChildlen.", (Throwable)e);
            throw new RuntimeException("Exception Performing getFirstChildlen", e);
        }
        return mailFolders;
    }

    protected List<BaseFolderType> getAllSubFolders(BaseFolderIdType parentFolder, int layer) throws ServerDown, HandleException {
        ArrayList<BaseFolderType> folders = new ArrayList<BaseFolderType>();
        List<BaseFolderType> thisFolder = null;
        String string = "getAllSubFolders:enter " + parentFolder;
        EAIExchewsBase.debug_aroundBody35$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_17);
        String layerStr = "-";
        int i = 0;
        while (i < layer) {
            layerStr = String.valueOf(layerStr) + "-";
            ++i;
        }
        try {
            thisFolder = this.getFirstChildlen(parentFolder);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            String string2 = "getAllSubFolders:could not get subfolder of " + parentFolder;
            EAIExchewsBase.debug_aroundBody37$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_18);
            return thisFolder;
        }
        for (BaseFolderType folder : thisFolder) {
            folder.setDisplayName(String.valueOf(layerStr) + folder.getDisplayName());
            folders.add(folder);
            String string3 = "name:" + folder.getDisplayName();
            EAIExchewsBase.debug_aroundBody39$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_19);
            if (folder.getChildFolderCount() <= 0) continue;
            folders.addAll(this.getAllSubFolders((BaseFolderIdType)folder.getFolderId(), layer + 1));
        }
        return folders;
    }

    protected List<? extends ItemType> getListByDate(ISearchDestination dest, List<String> itemList, Date date) throws NullPointerException, ServerDown, HandleException {
        if (itemList == null) {
            return null;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.endPointUri == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        NonEmptyArrayOfPathsToElementType props = ExchEWSTranslator.createAdditionalProperties(UnindexedFieldURIType.ITEM_ITEM_CLASS);
        ItemResponseShapeType irst = new ItemResponseShapeType();
        irst.setAdditionalProperties(props);
        irst.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);
        irst.setIncludeMimeContent(Boolean.valueOf(this.includeMimeContent));
        EWSSearchConditionCollection col = (EWSSearchConditionCollection)this.getDateSearchCondition(this.getDateField(), date);
        SearchExpressionType at = col.generateSearchExpression();
        RestrictionType rt = ExchEWSTranslator.createRestriction(at);
        FindItemType fit = new FindItemType();
        fit.setItemShape(irst);
        NonEmptyArrayOfBaseFolderIdsType folderIds = this.getEWSParamFolderIDs(dest);
        fit.setParentFolderIds(folderIds);
        fit.setTraversal(ItemQueryTraversalType.SHALLOW);
        fit.setRestriction(rt);
        FindItemResponseType findItemResponse = new FindItemResponseType();
        Holder responseHolder = new Holder((Object)findItemResponse);
        ArrayList<ItemType> messages = new ArrayList<ItemType>();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.findItem(fit, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            responses = ((FindItemResponseType)responseHolder.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody41$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_20);
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    String string = "Exchange Server returns Warning: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody43$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_21);
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "findItem SUCCESS.";
                EAIExchewsBase.debug_aroundBody45$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_22);
                FindItemResponseMessageType findResponse = (FindItemResponseMessageType)response;
                for (ItemType item : findResponse.getRootFolder().getItems().getItemOrMessageOrCalendarItem()) {
                    messages.add(item);
                }
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (Exception e) {
            Log.error((String)"Exception on getListByDate.", (Throwable)e);
            throw new RuntimeException("Exception Performing getListByDate", e);
        }
        return messages;
    }

    protected List<? extends ItemType> getList(ISearchDestination dest, List<String> itemList) throws NullPointerException, ServerDown, HandleException {
        if (itemList == null) {
            return null;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.endPointUri == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        NonEmptyArrayOfPathsToElementType props = ExchEWSTranslator.createAdditionalProperties(UnindexedFieldURIType.ITEM_ITEM_CLASS);
        ItemResponseShapeType irst = new ItemResponseShapeType();
        irst.setAdditionalProperties(props);
        irst.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);
        FindItemType fit = new FindItemType();
        fit.setItemShape(irst);
        NonEmptyArrayOfBaseFolderIdsType folderIds = this.getEWSParamFolderIDs(dest);
        fit.setParentFolderIds(folderIds);
        fit.setTraversal(ItemQueryTraversalType.SHALLOW);
        FindItemResponseType findItemResponse = new FindItemResponseType();
        Holder responseHolder = new Holder((Object)findItemResponse);
        ArrayList<ItemType> messages = new ArrayList<ItemType>();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.findItem(fit, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            responses = ((FindItemResponseType)responseHolder.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody47$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_23);
                    this.processResponseErrorCode(response);
                    continue;
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    String string = "Exchange Server returns Warning: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody49$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_24);
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "findItem SUCCESS.";
                EAIExchewsBase.debug_aroundBody51$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_25);
                FindItemResponseMessageType findResponse = (FindItemResponseMessageType)response;
                for (ItemType item : findResponse.getRootFolder().getItems().getItemOrMessageOrCalendarItem()) {
                    messages.add(item);
                }
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (NoSuchRights ne) {
            throw ne;
        }
        catch (Exception e) {
            Log.error((String)"Exception on getList.", (Throwable)e);
            throw new RuntimeException("Exception Performing getList", e);
        }
        return messages;
    }

    protected List<AttachmentType> getAttachments(ItemType msg) throws ServerDown, NoSuchRights {
        if (msg == null) {
            return null;
        }
        ArrayList<AttachmentType> rc = new ArrayList<AttachmentType>();
        if (msg.isHasAttachments().booleanValue() && msg.getAttachments() == null) {
            FileAttachmentType dummy = new FileAttachmentType();
            dummy.setName("dummy attachment");
            rc.add((AttachmentType)dummy);
            return rc;
        }
        GetAttachmentType req = new GetAttachmentType();
        req.setAttachmentIds(ExchEWSTranslator.createAttachIdList(msg.getAttachments().getItemAttachmentOrFileAttachment()));
        AttachmentResponseShapeType arst = new AttachmentResponseShapeType();
        arst.setIncludeMimeContent(Boolean.valueOf(this.includeMimeContent));
        req.setAttachmentShape(arst);
        Holder responseHolder = new Holder();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.getAttachment(req, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            GetAttachmentResponseType atRes = (GetAttachmentResponseType)responseHolder.value;
            responses = atRes.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody53$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_26);
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    String string = "Exchange Server returns Warning: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody55$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_27);
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "getAttachment SUCCESS.";
                EAIExchewsBase.debug_aroundBody57$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_28);
                AttachmentInfoResponseMessageType attResponse = (AttachmentInfoResponseMessageType)response;
                rc.addAll(attResponse.getAttachments().getItemAttachmentOrFileAttachment());
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (Exception e) {
            Log.error((String)"Exception on getAttachments.", (Throwable)e);
            throw new RuntimeException("Exception Performing getAttachments", e);
        }
        return rc;
    }

    protected ItemIdType deleteItem(ItemIdType iit) throws ServerDown, NoSuchRights, IncorrectData {
        DeleteItemType dit = new DeleteItemType();
        NonEmptyArrayOfBaseItemIdsType value = new NonEmptyArrayOfBaseItemIdsType();
        value.getItemIdOrOccurrenceItemIdOrRecurringMasterItemId().add(iit);
        dit.setItemIds(value);
        dit.setDeleteType(DisposalType.MOVE_TO_DELETED_ITEMS);
        dit.setAffectedTaskOccurrences(AffectedTaskOccurrencesType.ALL_OCCURRENCES);
        dit.setSendMeetingCancellations(this.sendMailPolicy);
        Holder responseHolder = new Holder();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.deleteItem(dit, version, responseHolder, this.serverVersionHolder);
            List responses = null;
            DeleteItemResponseType diRes = (DeleteItemResponseType)responseHolder.value;
            responses = diRes.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement b : responses) {
                ResponseMessageType response = (ResponseMessageType)b.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    Log.warn((String)("Delete Item Response Error: " + response.getMessageText()));
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    Log.warn((String)("Delete Item Response Warning: " + response.getMessageText()));
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                String string = "deleteItem SUCCESS.";
                EAIExchewsBase.debug_aroundBody59$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_29);
                return iit;
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (IncorrectData icd) {
            throw icd;
        }
        catch (Exception e) {
            Log.error((String)"Exception on deleteItem.", (Throwable)e);
            throw new RuntimeException("Exception Performing deleteItem", e);
        }
        return null;
    }

    protected void updateItem(ItemIdType id, UpdateItemMap itemMap) throws ServerDown, NoSuchRights {
        UpdateItemType uit = new UpdateItemType();
        uit.setConflictResolution(ConflictResolutionType.AUTO_RESOLVE);
        uit.setMessageDisposition(MessageDispositionType.SAVE_ONLY);
        uit.setItemChanges(this.buildItemChamgeArray(id, itemMap));
        try {
            this.setAdditionalRequestProperties((BaseRequestType)uit);
        }
        catch (HandleException e) {
            Log.error((String)"failed to set Additional Request Properties.", (Throwable)e);
        }
        Holder responseHolder = new Holder();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.updateItem(uit, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            UpdateItemResponseType uiRes = (UpdateItemResponseType)responseHolder.value;
            responses = uiRes.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement b : responses) {
                ResponseMessageType response = (ResponseMessageType)b.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) {
                    String string = "updateItem SUCCESS.";
                    EAIExchewsBase.debug_aroundBody61$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_30);
                    ItemInfoResponseMessageType mes = (ItemInfoResponseMessageType)response;
                    List items = mes.getItems().getItemOrMessageOrCalendarItem();
                    String string2 = ((ItemType)items.get(0)).toString();
                    EAIExchewsBase.trace_aroundBody63$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_31);
                    continue;
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody65$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_32);
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.WARNING)) continue;
                String string = "Exchange Server returns Warning: " + response.getMessageText();
                EAIExchewsBase.debug_aroundBody67$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_33);
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (Exception e) {
            Log.error((String)"Exception on updateItem.", (Throwable)e);
            throw new RuntimeException("Exception Performing updateItem", e);
        }
    }

    protected abstract TargetFolderIdType getTargetFolder();

    protected NonEmptyArrayOfItemChangesType buildItemChamgeArray(ItemIdType id, UpdateItemMap fields) {
        NonEmptyArrayOfItemChangesType chgs = new NonEmptyArrayOfItemChangesType();
        List icl = chgs.getItemChange();
        ItemChangeType ict = new ItemChangeType();
        ict.setItemId(id);
        NonEmptyArrayOfItemChangeDescriptionsType upd = new NonEmptyArrayOfItemChangeDescriptionsType();
        List list = upd.getAppendToItemFieldOrSetItemFieldOrDeleteItemField();
        for (UnindexedFieldURIType uri : fields.keySet()) {
            ItemType item = (ItemType)fields.get(uri);
            list.add(this.generateSetItemField(uri, item));
        }
        ict.setUpdates(upd);
        icl.add(ict);
        return chgs;
    }

    protected SetItemFieldType generateSetItemField(UnindexedFieldURIType ftype, ItemType msg) {
        PathToUnindexedFieldType ufut = new PathToUnindexedFieldType();
        ufut.setFieldURI(ftype);
        JAXBElement elem = typesObjectFactory.createFieldURI(ufut);
        SetItemFieldType sift = new SetItemFieldType();
        sift.setPath(elem);
        sift.setItem(msg);
        return sift;
    }

    protected void setAdditionalRequestProperties(BaseRequestType item) throws HandleException {
    }

    protected void addAttach(ItemIdType itemId, AttachmentDTO[] src) throws ServerDown, NoSuchRights {
        NonEmptyArrayOfAttachmentsType atts = ExchEWSTranslator.createArrayOfAttachmentsType(src);
        CreateAttachmentType cat = new CreateAttachmentType();
        cat.setAttachments(atts);
        cat.setParentItemId(itemId);
        Holder responseHolder = new Holder();
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.createAttachment(cat, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            CreateAttachmentResponseType caRes = (CreateAttachmentResponseType)responseHolder.value;
            responses = caRes.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement b : responses) {
                AttachmentInfoResponseMessageType response = (AttachmentInfoResponseMessageType)b.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) {
                    String string = "createAttachment SUCCESS.";
                    EAIExchewsBase.debug_aroundBody69$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_34);
                    String key = ((AttachmentType)response.getAttachments().getItemAttachmentOrFileAttachment().get(0)).getAttachmentId().getRootItemChangeKey();
                    itemId.setChangeKey(key);
                    continue;
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody71$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_35);
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.WARNING)) continue;
                String string = "Exchange Server returns Warning: " + response.getMessageText();
                EAIExchewsBase.debug_aroundBody73$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_36);
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (Exception e) {
            Log.error((String)"Exception on createAttachment.", (Throwable)e);
            throw new RuntimeException("Exception Performing addAttach", e);
        }
    }

    protected ItemType createItem(DistinguishedFolderIdNameType dist, ItemType msg) throws ServerDown, NoSuchRights {
        CreateItemType cit = new CreateItemType();
        cit.setMessageDisposition(MessageDispositionType.SAVE_ONLY);
        TargetFolderIdType target = new TargetFolderIdType();
        DistinguishedFolderIdType id = new DistinguishedFolderIdType();
        id.setId(dist);
        target.setDistinguishedFolderId(id);
        cit.setSavedItemFolderId(target);
        NonEmptyArrayOfAllItemsType ar = new NonEmptyArrayOfAllItemsType();
        ar.getItemOrMessageOrCalendarItem().add(msg);
        cit.setItems(ar);
        try {
            this.setAdditionalRequestProperties((BaseRequestType)cit);
        }
        catch (HandleException e) {
            Log.error((String)"failed to set Additional Request Properties.", (Throwable)e);
        }
        Holder responseHolder = new Holder();
        ItemType rc = null;
        try {
            ExchangeServices service = new ExchangeServices();
            ExchangeServicePortType proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.createItem(cit, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            CreateItemResponseType ciRes = (CreateItemResponseType)responseHolder.value;
            responses = ciRes.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement b : responses) {
                ResponseMessageType response = (ResponseMessageType)b.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) {
                    String string = "createItem SUCCESS.";
                    EAIExchewsBase.debug_aroundBody75$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_37);
                    ItemInfoResponseMessageType mes = (ItemInfoResponseMessageType)response;
                    List items = mes.getItems().getItemOrMessageOrCalendarItem();
                    rc = (ItemType)items.get(0);
                    continue;
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    String string = "Exchange Server returns Error: " + response.getMessageText();
                    EAIExchewsBase.debug_aroundBody77$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_38);
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.WARNING)) continue;
                String string = "Exchange Server returns Warning: " + response.getMessageText();
                EAIExchewsBase.debug_aroundBody79$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_39);
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (Exception e) {
            Log.error((String)"Exception on createItem.", (Throwable)e);
            throw new RuntimeException("Exception Performing createItem", e);
        }
        return rc;
    }

    protected ItemType getItem(ISearchDestination dest, ItemIdType iit) throws HandleException {
        ItemType rc = null;
        GetItemType git = new GetItemType();
        git.setItemIds(ExchEWSTranslator.createItemIdList(iit));
        ItemResponseShapeType irst = new ItemResponseShapeType();
        irst.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);
        irst.setIncludeMimeContent(Boolean.valueOf(this.includeMimeContent));
        irst.setBodyType(BodyTypeResponseType.TEXT);
        git.setItemShape(irst);
        Holder responseHolder = new Holder();
        ExchangeServicePortType proxy = null;
        try {
            ExchangeServices service = new ExchangeServices();
            proxy = service.getExchangeServicePort();
            this.setEWSAuthParams(proxy);
            proxy.getItem(git, version, tzct, responseHolder, this.serverVersionHolder);
            List responses = null;
            responses = ((GetItemResponseType)responseHolder.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
            for (JAXBElement jaxResponse : responses) {
                ResponseMessageType response = (ResponseMessageType)jaxResponse.getValue();
                if (response.getResponseClass().equals((Object)ResponseClassType.ERROR)) {
                    Log.warn((String)("Get Item Response Error: " + response.getMessageText()));
                    throw new HandleException("Exchange Server returns Error: " + response.getMessageText());
                }
                if (response.getResponseClass().equals((Object)ResponseClassType.WARNING)) {
                    Log.warn((String)("Get Item Response Warning: " + response.getMessageText()));
                    continue;
                }
                if (!response.getResponseClass().equals((Object)ResponseClassType.SUCCESS)) continue;
                Log.info((String)"getItem SUCCESS.");
                ItemInfoResponseMessageType res = (ItemInfoResponseMessageType)response;
                List items = res.getItems().getItemOrMessageOrCalendarItem();
                rc = (ItemType)items.get(0);
            }
        }
        catch (WebServiceException wse) {
            this.processWebServiceException(wse);
        }
        catch (Exception e) {
            Log.error((String)"Exception on getItem.", (Throwable)e);
            throw new RuntimeException("Exception Performing getItem", e);
        }
        return rc;
    }

    public String getDomain() {
        return this.domain;
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getServerAddress() {
        return this.endPointUri;
    }

    public String getUserID() {
        return this.userID;
    }

    protected void setUserID(String userID) {
        this.userID = userID;
    }

    protected void setAccountData(IAccountData acc) throws HandleException {
        ExchewsServiceInfo si = (ExchewsServiceInfo)acc.getServiceInfo();
        ExchewsAccountData eacc = (ExchewsAccountData)acc;
        this.setDomain(eacc.getDomain());
        this.setUserID(eacc.getUserID());
        this.setPassword(eacc.getPassword());
        this.setEndPointUri(si);
    }

    protected int delete(IObjectIndex oid) throws NullPointerException, ServerDown, NoSuchRights, IncorrectData {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.endPointUri == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        int code = 0;
        this.deleteItem((ItemIdType)oid.getIndex());
        return code;
    }

    public IRecordObject getFolderIndexFromString(String folderName) throws IncorrectData {
        BasicRecordObject rc = new BasicRecordObject();
        rc.setOid((IObjectIndex)new ExchewsFolderIndex(folderName));
        HashMap<String, IObjectIndex> h = new HashMap<String, IObjectIndex>();
        h.put("IFolderIndex", rc.getOid());
        try {
            rc.setFieldSet(h);
        }
        catch (IllegalAccessException e) {
            Log.error((String)"getFolderIndexFromString:error on setting IFolderIndex", (Throwable)e);
            throw new IncorrectData("getFolderIndexFromString:error on setting IFolderIndex");
        }
        return rc;
    }

    protected FolderMetadata populateFolder(IFolderIndex idx) {
        FolderMetadata folder = new FolderMetadata();
        folder.setOid((IObjectIndex)idx);
        HashMap<String, IFolderIndex> h = new HashMap<String, IFolderIndex>();
        h.put("oid", idx);
        folder.setFieldSet(h);
        folder.setFolderName(idx.getIndex().toString());
        return folder;
    }

    protected ArrayList<FolderMetadata> populateFolderList(int layer, String root, Vector<?> src) throws HandleException {
        if (src == null) {
            return null;
        }
        if (src.size() == 0) {
            return null;
        }
        Enumeration<?> em = src.elements();
        ArrayList<FolderMetadata> dst = new ArrayList<FolderMetadata>();
        String path = null;
        String sub = null;
        String layerStr = "";
        int i = 0;
        while (i < layer) {
            layerStr = String.valueOf(layerStr) + "-";
            ++i;
        }
        while (em.hasMoreElements()) {
            Object o = em.nextElement();
            try {
                Class<?> c = o.getClass();
                if (c.equals(Class.forName("java.lang.String"))) {
                    String string = "raw data of foldername:" + (String)o;
                    EAIExchewsBase.debug_aroundBody81$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_40);
                    FolderMetadata folder = new FolderMetadata();
                    path = (String)o;
                    sub = path.substring(path.indexOf(root) + root.length());
                    String string2 = "substring:" + sub;
                    EAIExchewsBase.debug_aroundBody83$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_41);
                    ExchewsFolderIndex oid = new ExchewsFolderIndex(path);
                    folder.setOid((IObjectIndex)oid);
                    String string3 = "oid:" + (String)oid.getIndex();
                    EAIExchewsBase.debug_aroundBody85$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_42);
                    HashMap<String, ExchewsFolderIndex> h = new HashMap<String, ExchewsFolderIndex>();
                    h.put("oid", oid);
                    folder.setFieldSet(h);
                    String string4 = "layerStr:" + layerStr;
                    EAIExchewsBase.debug_aroundBody87$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_43);
                    folder.setFolderName(String.valueOf(layerStr) + sub.replaceAll("/", ""));
                    String string5 = "folderName:" + folder.getFolderName();
                    EAIExchewsBase.debug_aroundBody89$advice(this, string5, LogAspect.aspectOf(), string5, null, ajc$tjp_44);
                    dst.add(folder);
                    continue;
                }
                if (!c.equals(Class.forName("java.util.Vector"))) continue;
                Vector v = (Vector)o;
                dst.addAll(this.populateFolderList(layer + 1, path, v));
            }
            catch (ClassNotFoundException e) {
                throw new HandleException(e.getMessage());
            }
        }
        return dst;
    }

    public IServiceInfo getServiceInfo(IStoreID storeID, String storeName, IServiceInfoRawData serviceData) throws Exception {
        String tmp;
        HashMap h = serviceData.getFieldSet();
        ExchewsServiceInfo info = new ExchewsServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        if ((tmp = (String)h.get("serverAddress")) != null) {
            info.setServerAddress(tmp);
        }
        if ((tmp = (String)h.get("protocolPrefix")) != null) {
            info.setProtocolPrefix(tmp);
        }
        return info;
    }

    public SearchConditionCollection getDateSearchCondition(UnindexedFieldURIType dateField, Date date) throws HandleException {
        EWS_AND_SearchConditionCollection c = new EWS_AND_SearchConditionCollection();
        EWSSearchCondition cond = new EWSSearchCondition(dateField, EWSSearchType.TYPE_DATE_0000, (Object)date, EWSSearchOperator.OP_BIG_EQUAL);
        c.add((ISearchConditionElement)cond);
        cond = new EWSSearchCondition(dateField, EWSSearchType.TYPE_DATE_2359, (Object)date, EWSSearchOperator.OP_SMALL_EQUAL);
        c.add((ISearchConditionElement)cond);
        return c;
    }

    private static final /* synthetic */ void debug_aroundBody0(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody8(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody9$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody10(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody11$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody12(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody13$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody14(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody15$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody16(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody17$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody18(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody19$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody20(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody21$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody22(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody23$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody24(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody25$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody26(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody27$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody28(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody29$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody30(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody31$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody32(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody33$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody34(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody35$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody36(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody37$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody38(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody39$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody40(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody41$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody42(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody43$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody44(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody45$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody46(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody47$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody48(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody49$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody50(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody51$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody52(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody53$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody54(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody55$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody56(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody57$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody58(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody59$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody60(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody61$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody62(EAIExchewsBase eAIExchewsBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody63$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody64(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody65$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody66(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody67$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody68(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody69$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody70(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody71$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody72(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody73$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody74(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody75$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody76(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody77$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody78(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody79$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody80(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody81$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody82(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody83$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody84(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody85$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody86(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody87$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody88(EAIExchewsBase eAIExchewsBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody89$advice(EAIExchewsBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EAIExchewsBase.java", Class.forName("jp.co.connectone.eai.exchews.store.EAIExchewsBase"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 107);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 167);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 231);
        ajc$tjp_11 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 282);
        ajc$tjp_12 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 286);
        ajc$tjp_13 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 289);
        ajc$tjp_14 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 384);
        ajc$tjp_15 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 388);
        ajc$tjp_16 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 389);
        ajc$tjp_17 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 413);
        ajc$tjp_18 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 427);
        ajc$tjp_19 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 433);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 171);
        ajc$tjp_20 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 483);
        ajc$tjp_21 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 487);
        ajc$tjp_22 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 490);
        ajc$tjp_23 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 542);
        ajc$tjp_24 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 546);
        ajc$tjp_25 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 549);
        ajc$tjp_26 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 607);
        ajc$tjp_27 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 611);
        ajc$tjp_28 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 614);
        ajc$tjp_29 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 665);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 174);
        ajc$tjp_30 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 714);
        ajc$tjp_31 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 717);
        ajc$tjp_32 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 720);
        ajc$tjp_33 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 724);
        ajc$tjp_34 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 800);
        ajc$tjp_35 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 806);
        ajc$tjp_36 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 810);
        ajc$tjp_37 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 859);
        ajc$tjp_38 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 865);
        ajc$tjp_39 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 869);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 198);
        ajc$tjp_40 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1089);
        ajc$tjp_41 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1093);
        ajc$tjp_42 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1096);
        ajc$tjp_43 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1100);
        ajc$tjp_44 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1102);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 211);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 213);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 214);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 228);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 230);
    }
}

