/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exch2k.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jp.co.connectone.eai.exch2k.dav.DavSearchCondition;
import jp.co.connectone.eai.exch2k.log.LogAspect;
import jp.co.connectone.eai.exch2k.store.EAIExch2kBase;
import jp.co.connectone.eai.exch2k.store.Exch2kFolderIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kObjectIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.DeleteFailed;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.SearchConditionFailed;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.UpdateFailed;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchCondition;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.BasicTaskDTO;
import jp.co.connectone.store.pim.ITaskDTO;
import jp.co.connectone.store.pim.ITaskStore;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Exch2kTaskStoreImpl
extends EAIExch2kBase
implements ITaskStore {
    private static final String DEFAULT_EXCHANGE_TASK_PATH_ELEMENT = "\u4ed5\u4e8b";
    private IFolderIndex taskElement = new Exch2kFolderIndex("\u4ed5\u4e8b");
    protected static final String elmentName = "\u4ed5\u4e8b";
    public static final IStoreID storeID;
    public static final String storeName = "Exchange2K task store";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Exch2kTaskStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(Exch2kTaskStoreImpl.class.getName());
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new Exch2kServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public ITaskDTO[] getAllTasks(IAccountData acc) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        ITaskDTO[] l_scheduleDtoArray = null;
        Vector<String> v = this.makeItemList();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.getList(this.taskElement, v);
        int len = col.size();
        l_scheduleDtoArray = new ITaskDTO[len];
        int i = 0;
        while (i < len) {
            l_scheduleDtoArray[i] = this.populateTaskDTO(col.elementAt(i));
            ++i;
        }
        return l_scheduleDtoArray;
    }

    public ITaskDTO[] getTasksByDate(IAccountData acc, Date dateObj) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        ITaskDTO[] l_scheduleDtoArray = null;
        Vector<String> v = this.makeItemList();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.getListByDate(this.taskElement, v, dateObj, "urn:schemas:httpmail:datereceived");
        int len = col.size();
        l_scheduleDtoArray = new ITaskDTO[len];
        int i = 0;
        while (i < len) {
            l_scheduleDtoArray[i] = this.populateTaskDTO(col.elementAt(i));
            ++i;
        }
        return l_scheduleDtoArray;
    }

    private Vector<String> makeItemList() {
        Vector<String> v = new Vector<String>();
        v.add("DAV:id");
        v.add("DAV:href");
        v.add("urn:schemas:httpmail:subject");
        v.add("urn:schemas:httpmail:textdescription");
        v.add("urn:schemas:httpmail:sendername");
        v.add("urn:schemas:httpmail:datereceived");
        v.add("urn:schemas:httpmail:importance");
        return v;
    }

    public ITaskDTO getTaskByOID(IAccountData acc, IObjectIndex oid) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException {
        String string = "getTaskByOID::oid=" + oid;
        Exch2kTaskStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        HashMap<String, Object> task = super.getProps((String)oid.getIndex(), this.makeItemList());
        return this.populateTaskDTO(task);
    }

    public IObjectIndex createNewTask(IAccountData acc, ITaskDTO ITaskDTO2) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException {
        IObjectIndex oid = null;
        Hashtable<String, String> h = this.populateHashtable(ITaskDTO2);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        String url = String.valueOf(this.generateBaseURL()) + "\u4ed5\u4e8b" + "/" + new Date().getTime() + ".EML";
        oid = super.saveData(this.escapeURL(url), h);
        return oid;
    }

    public IObjectIndex updateTask(IAccountData acc, ITaskDTO objITaskDTO) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, UpdateFailed, HandleException {
        IObjectIndex oid = null;
        Hashtable<String, String> h = this.populateHashtable(objITaskDTO);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        String url = (String)objITaskDTO.getOid().getIndex();
        oid = super.saveData(url, h);
        return oid;
    }

    public void deleteTask(IAccountData acc, IObjectIndex oid) throws IncorrectData, DeleteFailed, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        super.delete(oid);
    }

    private ITaskDTO populateTaskDTO(HashMap<String, Object> itemList) throws ServerDown, DataNotFound {
        BasicTaskDTO l_ITaskDTO = new BasicTaskDTO();
        l_ITaskDTO.setTid((String)itemList.get("id"));
        l_ITaskDTO.setOid((IObjectIndex)new Exch2kObjectIndex(itemList.get("href")));
        l_ITaskDTO.setSubject((String)itemList.get("subject"));
        l_ITaskDTO.setBody((String)itemList.get("textdescription"));
        l_ITaskDTO.setSenderName((String)itemList.get("sendername"));
        l_ITaskDTO.setDate(this.davDateStr2JavaDate((String)itemList.get("datereceived")));
        try {
            l_ITaskDTO.setPriority(Integer.parseInt((String)itemList.get("importance")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l_ITaskDTO;
    }

    private Hashtable<String, String> populateHashtable(ITaskDTO task) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        String string = "task=" + task;
        Exch2kTaskStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        if (task.getSubject() != null) {
            h.put("urn:schemas:httpmail:subject", task.getSubject());
        }
        if (task.getBody() != null) {
            h.put("urn:schemas:httpmail:textdescription", task.getBody());
        }
        if (task.getSenderName() != null) {
            h.put("urn:schemas:httpmail:sendername", task.getSenderName());
        }
        return h;
    }

    @Override
    protected DavSearchCondition convertCondition(SearchCondition src) throws HandleException {
        throw new HandleException("Not yet implemented");
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteTask(acc, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getAllTasks(acc);
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        FolderMetadata[] l_strFolderlist = new FolderMetadata[]{};
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex path = dest.getFolder();
        if (path == null) {
            path = this.taskElement;
        }
        Vector<Object> lists = super.getAllSubFolders((String)path.getIndex());
        ArrayList<FolderMetadata> arrFolderlist = this.populateFolderList(0, (String)path.getIndex(), lists);
        l_strFolderlist = arrFolderlist.toArray(l_strFolderlist);
        int i = 0;
        while (i < l_strFolderlist.length) {
            if (l_strFolderlist[i].getFolderName().length() == 0) {
                l_strFolderlist[i].setFolderName((String)path.getIndex());
            }
            ++i;
        }
        return l_strFolderlist;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getTaskByOID(acc, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        throw new UnsupportedOperationException("search is not yet supported.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        return this.getTasksByDate(acc, date);
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        IObjectIndex rc = null;
        rc = data.isNew() ? this.createNewTask(acc, (ITaskDTO)data) : this.updateTask(acc, (ITaskDTO)data);
        return rc;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        switch (type) {
            case 1: {
                folder = (IFolderIndex)this.populateFolder(this.taskElement).getOid();
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    @Override
    protected String getElmentName() {
        return "\u4ed5\u4e8b";
    }

    private static final /* synthetic */ void debug_aroundBody0(Exch2kTaskStoreImpl exch2kTaskStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(Exch2kTaskStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(Exch2kTaskStoreImpl exch2kTaskStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(Exch2kTaskStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Exch2kTaskStoreImpl.java", Class.forName("jp.co.connectone.eai.exch2k.store.Exch2kTaskStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 96);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 153);
    }
}

