/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exch2k.store;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.co.connectone.eai.exch2k.dav.DavSearchCondition;
import jp.co.connectone.eai.exch2k.log.LogAspect;
import jp.co.connectone.eai.exch2k.store.EAIExch2kBase;
import jp.co.connectone.eai.exch2k.store.Exch2kFolderIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kMailDTO;
import jp.co.connectone.eai.exch2k.store.Exch2kObjectIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchCondition;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.client.AttachmentDataSource;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Exch2kMailStoreImpl
extends EAIExch2kBase
implements IMailStore {
    public static final int DEST_TYPE_OLD_MAIL_FOLDER = 11;
    private static final String DEFAULT_EXCHANGE_INBOX_PATH_ELEMENT = "\u53d7\u4fe1\u30c8\u30ec\u30a4";
    private static final String OLD_EXCHANGE_INBOX_PATH_ELEMENT = "\u53d7\u4fe1\uff84\uff9a\uff72";
    private static final String DEFAULT_EXCHANGE_SENTBOX_PATH_ELEMENT = "\u9001\u4fe1\u6e08\u307f\u30a2\u30a4\u30c6\u30e0";
    private static final String DEFAULT_EXCHANGE_SENDINGBOX_PATH_ELEMENT = "\u9001\u4fe1\u30c8\u30ec\u30a4";
    private IFolderIndex inboxElement = new Exch2kFolderIndex("\u53d7\u4fe1\u30c8\u30ec\u30a4");
    private IFolderIndex oldInboxElement = new Exch2kFolderIndex("\u53d7\u4fe1\uff84\uff9a\uff72");
    private IFolderIndex sentboxElement = new Exch2kFolderIndex("\u9001\u4fe1\u6e08\u307f\u30a2\u30a4\u30c6\u30e0");
    private IFolderIndex sendingboxElement = new Exch2kFolderIndex("\u9001\u4fe1\u30c8\u30ec\u30a4");
    public static final IStoreID storeID;
    public static final String storeName = "Exchange2K mail store";
    protected static Exch2kMailStoreImpl store;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        Exch2kMailStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(Exch2kMailStoreImpl.class.getName());
        store = null;
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new Exch2kServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteMail(acc, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getMailsByDate(acc, dest, new Date());
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getMailFolders(acc, dest);
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getMail(acc, dest, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        throw new UnsupportedOperationException("IStore.search is not yet supported.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date startDate) throws Exception {
        return this.getMailsByDate(acc, dest, startDate);
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        return this.sendMail(acc, (IMailDTO)data);
    }

    public static Exch2kMailStoreImpl getInstance() {
        store = new Exch2kMailStoreImpl();
        return store;
    }

    private Exch2kMailDTO populateHeaderDTO(HashMap<String, Object> itemList) throws ServerDown, DataNotFound {
        HeaderDTO l_headerDTOObj = new HeaderDTO();
        l_headerDTOObj.setHeaderUIDL((String)itemList.get("id"));
        l_headerDTOObj.setOid((IObjectIndex)new Exch2kObjectIndex(itemList.get("permanenturl")));
        l_headerDTOObj.setHeaderFrom((String)itemList.get("from"));
        l_headerDTOObj.setHeaderSubject((String)itemList.get("subject"));
        int pri = 0;
        String priStr = (String)itemList.get("importance");
        try {
            pri = Integer.parseInt(priStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        l_headerDTOObj.setHeaderPriority(pri);
        l_headerDTOObj.setHeaderReplyTo((String)itemList.get("reply-to"));
        int length = 0;
        String strLength = (String)itemList.get("getcontentlength");
        try {
            length = Integer.parseInt(strLength);
        }
        catch (Exception exception) {
            // empty catch block
        }
        l_headerDTOObj.setHeaderSize(length);
        String strDate = (String)itemList.get("date");
        l_headerDTOObj.setHeaderSendDate(this.davDateStr2JavaDate(strDate));
        strDate = (String)itemList.get("datereceived");
        l_headerDTOObj.setHeaderReceivedDate(this.davDateStr2JavaDate(strDate));
        String CCs = (String)itemList.get("cc");
        l_headerDTOObj.setHeaderCC(this.parseAddresses(CCs));
        String TOs = (String)itemList.get("to");
        l_headerDTOObj.setHeaderTo(this.parseAddresses(TOs));
        String BCCs = (String)itemList.get("bcc");
        l_headerDTOObj.setHeaderBCC(this.parseAddresses(BCCs));
        Exch2kMailDTO rc = new Exch2kMailDTO(l_headerDTOObj);
        rc.setNew(false);
        String hasAttachment = (String)itemList.get("hasattachment");
        String string = "hasattachment=" + hasAttachment;
        Exch2kMailStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        if (hasAttachment == null) {
            return rc;
        }
        if ("1".equals(hasAttachment)) {
            AttachmentDTO[] atts = new AttachmentDTO[]{new AttachmentDTO()};
            rc.setAttachments(atts);
        }
        return rc;
    }

    private MailAddress[] parseAddresses(String src) {
        MailAddress[] ret = null;
        try {
            ret = MailAddress.parseAddressLine((String)MimeUtility.decodeText((String)src));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private Exch2kMailDTO setExch2kElements(Exch2kMailDTO src, HashMap<String, Object> itemList) {
        Class<?> c = ((Object)((Object)src)).getClass();
        Method[] f = c.getDeclaredMethods();
        int i = 0;
        while (i < f.length) {
            String valueType;
            Object o;
            String fieldName = f[i].getName();
            if (fieldName.startsWith("set") && (o = itemList.get(fieldName = fieldName.substring(3).toLowerCase().replaceAll("_", "-"))) != null && !"".equals(o) && "java.lang.String".equalsIgnoreCase(valueType = o.getClass().getName())) {
                String fieldType = f[i].getParameterTypes()[0].getName();
                Object[] oa = new Object[1];
                if ("java.lang.String".equalsIgnoreCase(fieldType)) {
                    oa[0] = (String)o;
                } else if ("long".equalsIgnoreCase(fieldType)) {
                    oa[0] = new Long((String)o);
                } else if ("int".equalsIgnoreCase(fieldType)) {
                    oa[0] = new Integer((String)o);
                } else if ("boolean".equalsIgnoreCase(fieldType)) {
                    boolean b = false;
                    if ("1".equals(o)) {
                        b = true;
                    } else if ("true".equals(o)) {
                        b = true;
                    }
                    oa[0] = new Boolean(b);
                } else if ("java.util.Date".equalsIgnoreCase(fieldType)) {
                    oa[0] = this.davDateStr2JavaDate((String)o);
                }
                try {
                    f[i].invoke((Object)src, oa);
                }
                catch (Exception e) {
                    Log.error((String)"", (Throwable)e);
                }
            }
            ++i;
        }
        return src;
    }

    private IMailDTO populateMailDTO(HashMap<String, Object> itemList) throws ServerDown, StoreNotFound, DataNotFound, HandleException {
        Exch2kMailDTO l_IMailDTOObj = this.populateHeaderDTO(itemList);
        l_IMailDTOObj.setBody((String)itemList.get("textdescription"));
        HashMap files = null;
        try {
            Object o = itemList.get("attachmentfile");
            if (o instanceof HashMap) {
                files = (HashMap)o;
            }
        }
        catch (ClassCastException o) {
            // empty catch block
        }
        if (files != null) {
            AttachmentDTO[] atts = new AttachmentDTO[files.size()];
            String[] keys = new String[]{};
            keys = files.keySet().toArray(keys);
            int i = 0;
            while (i < files.size()) {
                atts[i] = new AttachmentDTO();
                atts[i].setFileName(keys[i]);
                atts[i].setFileBody((byte[])files.get(keys[i]));
                ++i;
            }
            l_IMailDTOObj.setAttachments(atts);
        }
        return this.setExch2kElements(l_IMailDTOObj, itemList);
    }

    private MimeMessage populateMail(IMailDTO dto) throws NoSuchRights, HandleException, IncorrectData {
        MimeMessage mail = super.getMessageInstance();
        HeaderDTO header = dto.getHeader();
        try {
            MailAddress[] bccAddress;
            MailAddress[] ccAddress;
            MailAddress[] toAddress;
            mail.setSubject(header.getHeaderSubject(), "ISO-2022-JP");
            mail.setFrom((Address)new InternetAddress(super.getMailAddress()));
            MailAddress replyTo = dto.getHeader().getHeaderReplyTo();
            if (replyTo != null) {
                String string = "replyTo:" + replyTo;
                Exch2kMailStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
                if (replyTo.getRawAddress().length() > 0) {
                    Address[] replyAddress = new Address[]{this.populateAddress(replyTo)};
                    mail.setReplyTo(replyAddress);
                }
            }
            if ((toAddress = header.getHeaderTo()) != null && toAddress.length > 0) {
                Address[] to = new Address[toAddress.length];
                int i = 0;
                while (i < to.length) {
                    to[i] = this.populateAddress(toAddress[i]);
                    ++i;
                }
                mail.setRecipients(Message.RecipientType.TO, to);
            }
            if ((ccAddress = header.getHeaderCC()) != null && ccAddress.length > 0) {
                Address[] cc = new Address[ccAddress.length];
                int i = 0;
                while (i < cc.length) {
                    cc[i] = this.populateAddress(ccAddress[i]);
                    ++i;
                }
                mail.setRecipients(Message.RecipientType.CC, cc);
            }
            if ((bccAddress = header.getHeaderBCC()) != null && bccAddress.length > 0) {
                Address[] bcc = new Address[bccAddress.length];
                int i = 0;
                while (i < bcc.length) {
                    bcc[i] = this.populateAddress(bccAddress[i]);
                    ++i;
                }
                mail.setRecipients(Message.RecipientType.BCC, bcc);
            }
            if (dto.getNumberOfAttachments() > 0) {
                String string = "having attachments";
                Exch2kMailStoreImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
                MimeMultipart part1 = new MimeMultipart();
                MimeBodyPart body1 = new MimeBodyPart();
                body1.setText(dto.getBody(), "ISO-2022-JP");
                part1.addBodyPart((BodyPart)body1);
                int i = 0;
                while (i < dto.getNumberOfAttachments()) {
                    AttachmentDTO att = dto.getAttachment(i);
                    MimeBodyPart attach = new MimeBodyPart();
                    attach.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(att)));
                    String attName = att.getFileName();
                    try {
                        attName = MimeUtility.encodeText((String)attName, (String)"ISO-2022-JP", (String)"B");
                    }
                    catch (Exception e) {
                        Log.error((String)"Exception on encoding Japanese Filename", (Throwable)e);
                    }
                    String string2 = "attName=" + attName;
                    Exch2kMailStoreImpl.debug_aroundBody7$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_3);
                    attach.setFileName(attName);
                    part1.addBodyPart((BodyPart)attach);
                    ++i;
                }
                mail.setContent((Multipart)part1);
            } else {
                try {
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    OutputStream out = MimeUtility.encode((OutputStream)bao, (String)"base64");
                    out.write(dto.getBody().getBytes("ISO-2022-JP"));
                    out.close();
                    mail.setText(bao.toString(), "ISO-2022-JP");
                }
                catch (Exception e) {
                    Log.error((String)"Exception on encoding Japanese Body", (Throwable)e);
                }
                mail.setHeader("Content-transfer-encoding", "base64");
            }
            mail.saveChanges();
        }
        catch (MessagingException e) {
            Log.error((String)"", (Throwable)e);
        }
        return mail;
    }

    public FolderMetadata[] getMailFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        Vector<Object> lists;
        FolderMetadata[] l_strFolderlist = new FolderMetadata[]{};
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex path = null;
        if (dest != null) {
            path = dest.getFolder();
        }
        if (path == null) {
            path = this.inboxElement;
        }
        if ((lists = super.getAllSubFolders((String)path.getIndex())) == null) {
            return null;
        }
        if (lists.size() == 0) {
            return null;
        }
        String root = (String)lists.get(0);
        root = root.substring(0, root.length() - 1);
        ArrayList<FolderMetadata> arrFolderlist = this.populateFolderList(0, root, lists);
        l_strFolderlist = arrFolderlist.toArray(l_strFolderlist);
        int i = 0;
        while (i < l_strFolderlist.length) {
            if (l_strFolderlist[i].getFolderName().length() == 0) {
                l_strFolderlist[i].setFolderName((String)path.getIndex());
            }
            ++i;
        }
        return l_strFolderlist;
    }

    public int getNumberOfMessages(IAccountData acc, IFolderIndex folder) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        throw new UnsupportedOperationException("getNumberOfMessages is not yet supported.");
    }

    public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IMailDTO[] headers = null;
        IFolderIndex folder = dest.getFolder();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.getList(folder, this.makeItemList());
        int len = col.size();
        headers = new IMailDTO[len];
        int i = 0;
        while (i < len) {
            headers[i] = this.populateHeaderDTO(col.elementAt(i));
            ++i;
        }
        return headers;
    }

    public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IMailDTO[] headers = null;
        IFolderIndex folder = dest.getFolder();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.exGetListByDate(1, folder, this.makeItemList(), date, "urn:schemas:httpmail:datereceived");
        int len = col.size();
        headers = new IMailDTO[len];
        int i = 0;
        while (i < len) {
            headers[i] = this.populateHeaderDTO(col.elementAt(i));
            ++i;
        }
        return headers;
    }

    public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IMailDTO l_IMailDTOObj = null;
        String string = "getMail::oid=" + oid;
        Exch2kMailStoreImpl.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        HashMap<String, Object> mail = super.getProps((String)oid.getIndex(), this.makeItemList());
        l_IMailDTOObj = this.populateMailDTO(mail);
        return l_IMailDTOObj;
    }

    public IObjectIndex[] getUIDLsByDate(IAccountData arg0, ISearchDestination arg1, Date arg2) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("getUIDLsByDate is not yet supported.");
    }

    public IObjectIndex[] getUIDLs(IAccountData arg0, ISearchDestination arg1) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("getUIDLs is not yet supported.");
    }

    private Vector<String> makeItemList() {
        Vector<String> v = new Vector<String>();
        v.add("DAV:id");
        v.add("DAV:href");
        v.add("DAV:getcontentlength");
        v.add("urn:schemas:httpmail:attachmentfilename");
        v.add("urn:schemas:httpmail:bcc");
        v.add("urn:schemas:httpmail:calendar");
        v.add("urn:schemas:httpmail:cc");
        v.add("urn:schemas:httpmail:contacts");
        v.add("urn:schemas:httpmail:content-disposition-type");
        v.add("urn:schemas:httpmail:content-media-type");
        v.add("urn:schemas:httpmail:date");
        v.add("urn:schemas:httpmail:datereceived");
        v.add("urn:schemas:httpmail:deleteditems");
        v.add("urn:schemas:httpmail:displaycc");
        v.add("urn:schemas:httpmail:displayto");
        v.add("urn:schemas:httpmail:drafts");
        v.add("urn:schemas:httpmail:expiry_date");
        v.add("urn:schemas:httpmail:flagcompleted");
        v.add("urn:schemas:httpmail:from");
        v.add("urn:schemas:httpmail:fromemail");
        v.add("urn:schemas:httpmail:fromname");
        v.add("urn:schemas:httpmail:hasattachment");
        v.add("urn:schemas:httpmail:htmldescription");
        v.add("urn:schemas:httpmail:importance");
        v.add("urn:schemas:httpmail:inbox");
        v.add("urn:schemas:httpmail:journal");
        v.add("urn:schemas:httpmail:messageflag");
        v.add("urn:schemas:httpmail:msgfolderroot");
        v.add("urn:schemas:httpmail:normalizedsubject");
        v.add("urn:schemas:httpmail:notes");
        v.add("urn:schemas:httpmail:outbox");
        v.add("urn:schemas:httpmail:priority");
        v.add("urn:schemas:httpmail:read");
        v.add("urn:schemas:httpmail:reply-by");
        v.add("urn:schemas:httpmail:reply-to");
        v.add("urn:schemas:httpmail:savedestination");
        v.add("urn:schemas:httpmail:saveinsent");
        v.add("urn:schemas:httpmail:sender");
        v.add("urn:schemas:httpmail:senderemail");
        v.add("urn:schemas:httpmail:sendername");
        v.add("urn:schemas:httpmail:sendmsg");
        v.add("urn:schemas:httpmail:sentitems");
        v.add("urn:schemas:httpmail:subject");
        v.add("urn:schemas:httpmail:submitted");
        v.add("urn:schemas:httpmail:tasks");
        v.add("urn:schemas:httpmail:textdescription");
        v.add("urn:schemas:httpmail:thread_topic");
        v.add("urn:schemas:httpmail:to");
        v.add("urn:schemas:httpmail:unreadcount");
        v.add("http://schemas.microsoft.com/exchange/permanenturl");
        return v;
    }

    public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IMailDTO[] l_mailArray = null;
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.exGetListByDate(1, dest.getFolder(), this.makeItemList(), date, "urn:schemas:httpmail:datereceived");
        int len = col.size();
        l_mailArray = new IMailDTO[len];
        int i = 0;
        while (i < len) {
            l_mailArray[i] = this.populateMailDTO(col.elementAt(i));
            ++i;
        }
        return l_mailArray;
    }

    private Hashtable<String, String> populateMailProps(Exch2kMailDTO src) {
        Hashtable<String, String> rc = new Hashtable<String, String>();
        String prefix = "urn:schemas:httpmail:";
        Class<?> c = ((Object)((Object)src)).getClass();
        Method[] f = c.getDeclaredMethods();
        int i = 0;
        while (i < f.length) {
            String fieldName = f[i].getName();
            if (fieldName.startsWith("get")) {
                fieldName = fieldName.substring(3).toLowerCase().replaceAll("_", "-");
                String string = "fieldName:" + fieldName;
                Exch2kMailStoreImpl.debug_aroundBody11$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_5);
                if (!("htmldescription".equals(fieldName) || "from".equals(fieldName) || "unreadcount".equals(fieldName) || "reply-to".equals(fieldName))) {
                    String fieldType = f[i].getReturnType().getName();
                    String string2 = "fieldType:" + fieldType;
                    Exch2kMailStoreImpl.debug_aroundBody13$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_6);
                    Object value = null;
                    try {
                        value = f[i].invoke((Object)src, null);
                    }
                    catch (Exception e) {
                        Log.error((String)"", (Throwable)e);
                    }
                    if (value != null) {
                        Object v2;
                        if ("java.lang.String".equalsIgnoreCase(fieldType)) {
                            v2 = (String)value;
                            if (((String)v2).length() != 0) {
                                rc.put("urn:schemas:httpmail:" + fieldName, (String)v2);
                            }
                        } else if ("long".equalsIgnoreCase(fieldType)) {
                            v2 = (Long)value;
                            rc.put("urn:schemas:httpmail:" + fieldName, ((Long)v2).toString());
                        } else if ("int".equalsIgnoreCase(fieldType)) {
                            v2 = (Integer)value;
                            rc.put("urn:schemas:httpmail:" + fieldName, ((Integer)v2).toString());
                        } else if ("boolean".equalsIgnoreCase(fieldType)) {
                            v2 = (Boolean)value;
                            if (((Boolean)v2).booleanValue()) {
                                rc.put("urn:schemas:httpmail:" + fieldName, "1");
                            } else {
                                rc.put("urn:schemas:httpmail:" + fieldName, "0");
                            }
                        } else if ("java.util.Date".equalsIgnoreCase(fieldType)) {
                            v2 = (Date)value;
                            rc.put("urn:schemas:httpmail:" + fieldName, super.javaDate2MSDavDateStr((Date)v2));
                        }
                    }
                }
            }
            ++i;
        }
        return rc;
    }

    public IObjectIndex sendMail(IAccountData acc, IMailDTO IMailDTOobj) throws NoSuchRights, ServerDown, IncorrectData, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        IObjectIndex oid = null;
        if (IMailDTOobj instanceof Exch2kMailDTO) {
            Exch2kMailDTO dto = (Exch2kMailDTO)IMailDTOobj;
            dto.copyExch2kElements2Header();
            oid = super.saveData(this.sendingboxElement.getIndex().toString(), this.populateMail(IMailDTOobj));
            Hashtable<String, String> table = this.populateMailProps(dto);
            super.saveData((String)oid.getIndex(), table);
        } else {
            oid = super.saveData(this.sendingboxElement.getIndex().toString(), this.populateMail(IMailDTOobj));
        }
        super.sendSavedMsg((String)oid.getIndex());
        return oid;
    }

    public IMailDTO[] getSentMails(IAccountData acc) throws ServerDown, HandleException {
        return this.getMailsByDate(acc, this.getPresetDestination(acc, 2), new Date());
    }

    public IMailDTO[] getSentMailsByDate(IAccountData acc, Date dateObj) throws ServerDown, HandleException {
        return this.getMailsByDate(acc, this.getPresetDestination(acc, 2), dateObj);
    }

    public void deleteMail(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        super.delete(oid);
    }

    @Override
    protected DavSearchCondition convertCondition(SearchCondition src) throws HandleException {
        throw new HandleException("Not yet implemented");
    }

    @Override
    protected String getElmentName() {
        return DEFAULT_EXCHANGE_INBOX_PATH_ELEMENT;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        switch (type) {
            case 1: {
                folder = (IFolderIndex)this.populateFolder(this.inboxElement).getOid();
                break;
            }
            case 11: {
                folder = (IFolderIndex)this.populateFolder(this.oldInboxElement).getOid();
                break;
            }
            case 2: {
                folder = (IFolderIndex)this.populateFolder(this.sentboxElement).getOid();
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    private static final /* synthetic */ void debug_aroundBody0(Exch2kMailStoreImpl exch2kMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(Exch2kMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(Exch2kMailStoreImpl exch2kMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(Exch2kMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(Exch2kMailStoreImpl exch2kMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(Exch2kMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(Exch2kMailStoreImpl exch2kMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(Exch2kMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(Exch2kMailStoreImpl exch2kMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(Exch2kMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(Exch2kMailStoreImpl exch2kMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(Exch2kMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody12(Exch2kMailStoreImpl exch2kMailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody13$advice(Exch2kMailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Exch2kMailStoreImpl.java", Class.forName("jp.co.connectone.eai.exch2k.store.Exch2kMailStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 168);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 285);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 323);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 343);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 438);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 546);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 554);
    }
}

