/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exch2k.store;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import jp.co.connectone.common.ADTool;
import jp.co.connectone.common.DNSTool;
import jp.co.connectone.eai.exch2k.dav.DavDateFormat;
import jp.co.connectone.eai.exch2k.dav.DavSearchCondition;
import jp.co.connectone.eai.exch2k.dav.DavSearchOperator;
import jp.co.connectone.eai.exch2k.dav.DavSearchType;
import jp.co.connectone.eai.exch2k.dav.ExWebdavResource;
import jp.co.connectone.eai.exch2k.log.LogAspect;
import jp.co.connectone.eai.exch2k.store.Exch2kFolderIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kObjectIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchCondition;
import jp.co.connectone.store.ISearchConditionElement;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchCondition;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.client.AddressBookSearchCondition;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class EAIExch2kBase {
    private static int HTTP_FILE_NOT_FOUND;
    protected static final String DEFAULT_EXCHANGE_BASE_PATH_ELEMENT = "/exchange/";
    private String exchageBasePathElement = "/exchange/";
    protected static final String DEFAULT_PROTOCOL_PREFIX = "http://";
    protected static final String SSL_PROTOCOL_PREFIX = "https://";
    protected String protocolPrefix = "http://";
    public static final int DEPTH_0 = 0;
    public static final int DEPTH_1 = 1;
    public static final int DEPTH_INFINITY = 2;
    private static final int URL_TYPE_NULL = 0;
    private static final int URL_TYPE_MAIL_ACCOUNT_NAME_PART = 1;
    private static final int URL_TYPE_MAIL_ADDRESS = 2;
    private static int urlType;
    private String adAddress;
    private String adAddress2;
    private String serverAddress;
    private String mbkServerAddress;
    private String path;
    private String userID;
    private String password;
    private String domain;
    private String mailAddress;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;

    static {
        EAIExch2kBase.ajc$preClinit();
        HTTP_FILE_NOT_FOUND = 404;
        urlType = 0;
    }

    protected abstract DavSearchCondition convertCondition(SearchCondition var1) throws HandleException;

    protected abstract String getElmentName();

    protected int setUrlType() throws NoSuchRights {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        int type = 0;
        if (urlType != type) {
            return urlType;
        }
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        String url = null;
        try {
            url = String.valueOf(this.protocolPrefix) + this.serverAddress + this.exchageBasePathElement + this.mailAddress + "/";
            ExWebdavResource davClient = new ExWebdavResource(url, cred);
            type = 2;
        }
        catch (Exception e) {
            String codeStr = "";
            if (e instanceof HttpException) {
                HttpException he = (HttpException)e;
                int code = he.getReasonCode();
                codeStr = "" + code;
            }
            String string = "access with url " + url + " failed. message is(" + e.getMessage() + ":" + codeStr + ")";
            EAIExch2kBase.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            try {
                url = String.valueOf(this.protocolPrefix) + this.serverAddress + this.exchageBasePathElement + this.mailAddress.substring(0, this.mailAddress.indexOf(64)) + "/";
                ExWebdavResource davClient = new ExWebdavResource(url, cred);
                davClient.getExistence();
                type = 1;
            }
            catch (Exception e2) {
                codeStr = "";
                if (e2 instanceof HttpException) {
                    HttpException he = (HttpException)e2;
                    int code = he.getReasonCode();
                    codeStr = "" + code;
                    if (code == 401) {
                        throw new NoSuchRights("access with url " + url + " failed. message is(" + e2.getMessage() + ":401)");
                    }
                }
                String string2 = "access with url " + url + " failed. message is(" + e2.getMessage() + ":" + codeStr + ")";
                EAIExch2kBase.debug_aroundBody3$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_1);
            }
        }
        urlType = type;
        return type;
    }

    protected String generateBaseURL() throws HandleException {
        if (urlType == 0) {
            this.setUrlType();
        }
        switch (urlType) {
            case 1: {
                return String.valueOf(this.protocolPrefix) + this.serverAddress + this.exchageBasePathElement + this.mailAddress.substring(0, this.mailAddress.indexOf(64)) + "/";
            }
            case 2: {
                return String.valueOf(this.protocolPrefix) + this.serverAddress + this.exchageBasePathElement + this.mailAddress + "/";
            }
        }
        throw new HandleException("Illegal urlType detected.");
    }

    protected String generateBaseURL(String strStore) {
        return String.valueOf(this.protocolPrefix) + this.serverAddress + this.exchageBasePathElement + strStore + "/";
    }

    protected String getDomainName(String ADAddress, String ADAddress2) throws ServerDown, HandleException {
        SearchResult result;
        NamingEnumeration results;
        String string = "getDomainName:ADAddress=" + ADAddress + ",ADAddress2=" + ADAddress2;
        EAIExch2kBase.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
        String domainName = null;
        ADTool tool = new ADTool();
        try {
            results = tool.getRootDSE(ADAddress, ADAddress2);
        }
        catch (NoSuchRights nsr) {
            throw nsr;
        }
        catch (AuthenticationException ae) {
            Log.error((String)("getDomainName:Authentication failed(" + ae.getMessage() + ")"), (Throwable)ae);
            throw new NoSuchRights("getDomainName:Authentication failed(" + ae.getMessage() + ")");
        }
        catch (Exception e) {
            Log.error((String)("getDomainName:error getting rootDSN(" + e.getMessage() + ")"), (Throwable)e);
            throw new ServerDown("getDomainName:error getting rootDSN(" + e.getMessage() + ")");
        }
        try {
            result = (SearchResult)results.next();
        }
        catch (NamingException e) {
            Log.error((String)("getDomainName:error getting rootDSN(" + e.getMessage() + ")"), (Throwable)e);
            throw new HandleException("getDomainName:error getting rootDSN(" + e.getMessage() + ")");
        }
        Attribute attr = result.getAttributes().get("defaultNamingContext");
        try {
            domainName = (String)attr.get(0);
        }
        catch (NamingException e) {
            Log.error((String)("getDomainName:error getting defaultNamingContext, assume server is not AD(" + e.getMessage() + ")"), (Throwable)e);
            throw new HandleException("getDomainName:error getting defaultNamingContext, assume server is not AD(" + e.getMessage() + ")");
        }
        domainName = domainName.replaceAll(",DC=", ".").substring(3);
        String string2 = "getDomainName:domainName=" + domainName;
        EAIExch2kBase.debug_aroundBody7$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_3);
        return domainName;
    }

    protected String getFirstExch2kServer(String userID, String paassword, String ADAddress, String ADAddress2, String domain) throws ServerDown, HandleException {
        SearchResult result;
        NamingEnumeration results;
        String string = "getFirstExch2kServer:ADAddress=" + ADAddress;
        EAIExch2kBase.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        String exchAddress = null;
        ADTool tool = new ADTool();
        try {
            results = tool.getUserDetail(userID, this.password, ADAddress, ADAddress2, domain);
        }
        catch (NoSuchRights nsr) {
            throw nsr;
        }
        catch (AuthenticationException ae) {
            Log.error((String)("getFirstExch2kServer:Authentication failed(" + ae.getMessage() + ")"), (Throwable)ae);
            throw new NoSuchRights("getFirstExch2kServer:Authentication failed(" + ae.getMessage() + ")");
        }
        catch (Exception e) {
            Log.error((String)("getFirstExch2kServer:error getting user record(" + e.getMessage() + ")"), (Throwable)e);
            throw new ServerDown("getFirstExch2kServer:error getting user record(" + e.getMessage() + ")");
        }
        try {
            if (!results.hasMore()) {
                throw new ServerDown("getFirstExch2kServer:LDAP returns no result of userDetail. assume auth error");
            }
            result = (SearchResult)results.next();
        }
        catch (AuthenticationException ae) {
            Log.error((String)("getFirstExch2kServer:Authentication failed(" + ae.getMessage() + ")"), (Throwable)ae);
            throw new NoSuchRights("getFirstExch2kServer:Authentication failed(" + ae.getMessage() + ")");
        }
        catch (NamingException e) {
            Log.error((String)("getFirstExch2kServer:error getting user record(" + e.getMessage() + ")"), (Throwable)e);
            throw new HandleException("getFirstExch2kServer:error getting user record(" + e.getMessage() + ")");
        }
        Attribute attr = result.getAttributes().get("mail");
        try {
            this.mailAddress = (String)attr.get(0);
        }
        catch (Exception e) {
            Log.error((String)"getFirstExch2kServer:error getting mail", (Throwable)e);
            throw new HandleException("getFirstExch2kServer:error getting mail, assume server is not AD(" + e.getMessage() + ")");
        }
        attr = result.getAttributes().get("msExchHomeServerName");
        try {
            exchAddress = (String)attr.get(0);
            String string2 = "getFirstExch2kServer:msExchHomeServerName=" + exchAddress;
            EAIExch2kBase.debug_aroundBody11$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_5);
        }
        catch (Exception e) {
            Log.error((String)"getFirstExch2kServer:error getting msExchHomeServerName", (Throwable)e);
            throw new HandleException("getFirstExch2kServer:error getting msExchExchangeServer, assume server is not AD(" + e.getMessage() + ")");
        }
        exchAddress = exchAddress.substring(exchAddress.lastIndexOf("cn=") + 3);
        String string3 = "getFirstExch2kServer:exchAddress=" + exchAddress;
        EAIExch2kBase.debug_aroundBody13$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_6);
        return exchAddress;
    }

    protected String exGetFirstExch2kServer(String idToSee, String userID, String paassword, String ADAddress, String ADAddress2, String domain) throws ServerDown, HandleException {
        SearchResult result;
        NamingEnumeration results;
        String string = "exGetFirstExch2kServer:ADAddress=" + ADAddress;
        EAIExch2kBase.debug_aroundBody15$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_7);
        String exchAddress = null;
        ADTool tool = new ADTool();
        try {
            results = tool.getOtherUserDetail(idToSee, userID, this.password, ADAddress, ADAddress2, domain);
        }
        catch (NoSuchRights nsr) {
            throw nsr;
        }
        catch (AuthenticationException ae) {
            Log.error((String)("exGetFirstExch2kServer:Authentication failed(" + ae.getMessage() + ")"), (Throwable)ae);
            throw new NoSuchRights("exGetFirstExch2kServer:Authentication failed(" + ae.getMessage() + ")");
        }
        catch (Exception e) {
            Log.error((String)("exGetFirstExch2kServer:error getting user record(" + e.getMessage() + ")"), (Throwable)e);
            throw new ServerDown("exGetFirstExch2kServer:error getting user record(" + e.getMessage() + ")");
        }
        try {
            if (!results.hasMore()) {
                throw new ServerDown("getFirstExch2kServer:LDAP returns no result of userDetail. assume auth error");
            }
            result = (SearchResult)results.next();
        }
        catch (NamingException e) {
            Log.error((String)("exGetFirstExch2kServer:error getting user record(" + e.getMessage() + ")"), (Throwable)e);
            throw new HandleException("exGetFirstExch2kServer:error getting user record(" + e.getMessage() + ")");
        }
        Attribute attr = result.getAttributes().get("mail");
        try {
            this.mailAddress = (String)attr.get(0);
        }
        catch (NamingException e) {
            Log.error((String)"exGetFirstExch2kServer:error getting mail.", (Throwable)e);
            throw new HandleException("exGetFirstExch2kServer:error getting mail, assume server is not AD(" + e.getMessage() + ")");
        }
        attr = result.getAttributes().get("msExchHomeServerName");
        try {
            exchAddress = (String)attr.get(0);
        }
        catch (NamingException e) {
            Log.error((String)"exGetFirstExch2kServer:error getting mail", (Throwable)e);
            throw new HandleException("exGetFirstExch2kServer:error getting msExchExchangeServer, assume server is not AD(" + e.getMessage() + ")");
        }
        exchAddress = exchAddress.substring(exchAddress.lastIndexOf("cn=") + 3);
        String string2 = "exGetFirstExch2kServer:exchAddress=" + exchAddress;
        EAIExch2kBase.debug_aroundBody17$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_8);
        return exchAddress;
    }

    protected void setServerAddress(Exch2kServiceInfo si) throws ServerDown, HandleException {
        if (si.protocolPrefix != null && si.protocolPrefix.length() > 0) {
            this.protocolPrefix = si.protocolPrefix;
        }
        String serverAddress = si.getServerAddress();
        String serverAddress2 = si.getStandbyADAddress();
        this.adAddress = serverAddress;
        this.adAddress2 = serverAddress2;
        this.setDomain(this.getDomainName(serverAddress, serverAddress2));
        String firstMDB = this.getFirstExch2kServer(this.userID, this.password, serverAddress, serverAddress2, this.domain);
        this.serverAddress = this.mbkServerAddress = si.getCasAddress();
        if (this.mbkServerAddress == null || "".equalsIgnoreCase(this.mbkServerAddress)) {
            this.mbkServerAddress = firstMDB;
            DNSTool dns = new DNSTool(serverAddress, serverAddress2);
            this.serverAddress = dns.getIPAddress(String.valueOf(this.mbkServerAddress) + "." + this.domain);
        }
    }

    protected void exSetServerAddress(String idToSee, Exch2kServiceInfo si) throws ServerDown, HandleException {
        if (si.protocolPrefix != null && si.protocolPrefix.length() > 0) {
            this.protocolPrefix = si.protocolPrefix;
        }
        String serverAddress = si.getServerAddress();
        String serverAddress2 = si.getStandbyADAddress();
        this.adAddress = serverAddress;
        this.adAddress2 = serverAddress2;
        this.setDomain(this.getDomainName(serverAddress, serverAddress2));
        String firstMDB = this.exGetFirstExch2kServer(idToSee, this.userID, this.password, serverAddress, serverAddress2, this.domain);
        this.serverAddress = this.mbkServerAddress = si.getCasAddress();
        if (this.mbkServerAddress == null || "".equalsIgnoreCase(this.mbkServerAddress)) {
            this.mbkServerAddress = firstMDB;
            DNSTool dns = new DNSTool(serverAddress, serverAddress2);
            this.serverAddress = dns.getIPAddress(String.valueOf(this.mbkServerAddress) + "." + this.domain);
        }
    }

    protected IObjectIndex saveData(String escapedUrl, Hashtable<String, String> itemList) throws ServerDown, HandleException {
        ExWebdavResource davClient;
        if (itemList == null) {
            return null;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        String baseURL = escapedUrl.substring(0, escapedUrl.lastIndexOf("/") + 1);
        try {
            baseURL = URIUtil.decode((String)baseURL, (String)"UTF-8");
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        String string = "baseURL=" + baseURL;
        EAIExch2kBase.debug_aroundBody19$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_9);
        try {
            davClient = new ExWebdavResource(baseURL, cred);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        try {
            davClient.propPatchMethod(this.generateBaseURL(), escapedUrl, itemList);
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        String oid = davClient.getHttpURL().getEscapedURI();
        return new Exch2kObjectIndex(oid);
    }

    protected List<HashMap<String, String>> searchUserFromActiveDirectory(SearchConditionCollection conds) throws NullPointerException, ServerDown, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.adAddress == null) {
            throw new NullPointerException("set adAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        Iterator it = conds.iterator();
        ISearchCondition cond = null;
        String whereStr = "";
        while (it.hasNext()) {
            ISearchConditionElement elem = (ISearchConditionElement)it.next();
            cond = (ISearchCondition)elem;
            String string = "condition:" + cond.getType() + ":" + cond.getValue();
            EAIExch2kBase.debug_aroundBody21$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_10);
        }
        if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME) {
            whereStr = " (displayName=" + cond.getValue() + "*) ";
        } else if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME) {
            whereStr = " (sn=*" + cond.getValue() + "*) ";
        } else if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_LASTNAME) {
            whereStr = " (givenName=*" + cond.getValue() + "*) ";
        } else if (cond.getType() == AddressBookSearchCondition.CONDITION.TYPE_ACCOUNTNAME) {
            whereStr = " (sAMAccountName=" + cond.getValue() + ") ";
        } else {
            throw new HandleException("Illegal search type");
        }
        String string = "whereStr:" + whereStr;
        EAIExch2kBase.debug_aroundBody23$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_11);
        ADTool ad = new ADTool();
        NamingEnumeration results = null;
        ArrayList<HashMap<String, String>> lists = new ArrayList<HashMap<String, String>>();
        try {
            results = ad.getUserDatas(this.userID, this.password, this.adAddress, this.adAddress2, this.domain, whereStr);
            while (results.hasMoreElements()) {
                String string2 = "LOOP FIRST LINE";
                EAIExch2kBase.debug_aroundBody25$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_12);
                SearchResult aResult = (SearchResult)results.nextElement();
                String string3 = "name: " + aResult.getName();
                EAIExch2kBase.debug_aroundBody27$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_13);
                Attributes attrs = aResult.getAttributes();
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                HashMap<String, String> list = new HashMap<String, String>();
                String string4 = "loop IN";
                EAIExch2kBase.debug_aroundBody29$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_14);
                while (ae.hasMoreElements()) {
                    Attribute attr = (Attribute)ae.nextElement();
                    String strAttrID = attr.getID();
                    NamingEnumeration<?> e = attr.getAll();
                    String value = "";
                    while (e.hasMoreElements()) {
                        Object o = e.nextElement();
                        String string5 = "class of object(" + strAttrID + "):" + o.getClass();
                        EAIExch2kBase.trace_aroundBody31$advice(this, string5, LogAspect.aspectOf(), string5, null, ajc$tjp_15);
                        if (!(o instanceof String)) continue;
                        value = (String)o;
                    }
                    String string6 = String.valueOf(strAttrID) + ": " + value;
                    EAIExch2kBase.trace_aroundBody33$advice(this, string6, LogAspect.aspectOf(), string6, null, ajc$tjp_16);
                    list.put(strAttrID, value);
                }
                String string7 = "loop OUT";
                EAIExch2kBase.debug_aroundBody35$advice(this, string7, LogAspect.aspectOf(), string7, null, ajc$tjp_17);
                lists.add(list);
                list = null;
                String string8 = "LOOP LAST LINE";
                EAIExch2kBase.debug_aroundBody37$advice(this, string8, LogAspect.aspectOf(), string8, null, ajc$tjp_18);
            }
            String string9 = "no of accounts:" + lists.size();
            EAIExch2kBase.debug_aroundBody39$advice(this, string9, LogAspect.aspectOf(), string9, null, ajc$tjp_19);
            results.close();
        }
        catch (AuthenticationException ae) {
            Log.error((String)("searchUserFromActiveDirectory:Authentication failed(" + ae.getMessage() + ")"), (Throwable)ae);
            throw new NoSuchRights("searchUserFromActiveDirectory:Authentication failed(" + ae.getMessage() + ")");
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new ServerDown(e.getMessage());
        }
        return lists;
    }

    protected boolean sendSavedMsg(String oid) throws HandleException, ServerDown, DataNotFound {
        if (oid == null) {
            return false;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        ExWebdavResource davClient = null;
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        String string = "oid=" + oid;
        EAIExch2kBase.debug_aroundBody41$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_20);
        try {
            davClient = new ExWebdavResource(this.generateBaseURL(), cred);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        String escapedUrl = this.escapeURL(String.valueOf(this.generateBaseURL()) + "##DavMailSubmissionURI##/");
        String url = null;
        try {
            url = URIUtil.decode((String)oid, (String)"UTF-8");
            escapedUrl = URIUtil.decode((String)escapedUrl, (String)"UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            davClient.moveMethod(url, escapedUrl);
        }
        catch (HttpException he) {
            int code = 0;
            if (davClient != null && (code = davClient.getStatusCode()) == HTTP_FILE_NOT_FOUND) {
                throw new DataNotFound(oid);
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + code + ") " + he.getMessage());
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        int status = davClient.getStatusCode();
        String string2 = "code=" + status;
        EAIExch2kBase.debug_aroundBody43$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_21);
        return true;
    }

    protected String generateStoreURL(String src) throws HandleException {
        String rc = src;
        if (src == null) {
            return null;
        }
        if (!rc.startsWith(this.protocolPrefix)) {
            rc = String.valueOf(this.generateBaseURL()) + rc;
        }
        if (!rc.endsWith("/")) {
            rc = String.valueOf(rc) + "/";
        }
        return rc;
    }

    protected IObjectIndex saveData(String storeName, MimeMessage msg) throws ServerDown, HandleException {
        ExWebdavResource davClient;
        if (msg == null) {
            return null;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        String storeUrl = this.generateStoreURL(storeName);
        String string = "storeURL=" + storeUrl;
        EAIExch2kBase.debug_aroundBody45$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_22);
        try {
            davClient = new ExWebdavResource(storeUrl, cred);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        String BCC = "";
        try {
            Address[] recipients = msg.getRecipients(Message.RecipientType.BCC);
            if (recipients != null) {
                int i = 0;
                while (i < recipients.length) {
                    String tmp = recipients[i].toString();
                    tmp = String.valueOf(tmp.substring(tmp.indexOf(60) + 1, tmp.indexOf(62))) + ",";
                    BCC = String.valueOf(BCC) + tmp;
                    ++i;
                }
                msg.setRecipients(Message.RecipientType.BCC, null);
            }
            if (BCC.length() > 1) {
                BCC = BCC.substring(0, BCC.length() - 1);
            }
        }
        catch (MessagingException me) {
            String string2 = "error on getting BCC addresses (" + me.getMessage() + ")";
            EAIExch2kBase.debug_aroundBody47$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_23);
        }
        String string3 = "BCC=" + BCC;
        EAIExch2kBase.debug_aroundBody49$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_24);
        Hashtable<String, String> BCCProp = null;
        try {
            if (BCC.length() != 0) {
                BCCProp = new Hashtable<String, String>();
                BCCProp.put("urn:schemas:mailheader:bcc", BCC);
            }
        }
        catch (NullPointerException i) {
            // empty catch block
        }
        String msgStr = this.getStringFromMessage(msg);
        String escapedUrl = this.escapeURL(String.valueOf(storeUrl) + new Date().getTime() + ".EML");
        try {
            davClient.putMethod(escapedUrl, msgStr);
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        String oid = davClient.getHttpURL().getEscapedURI();
        try {
            if (BCCProp != null) {
                davClient.propPatchMethod(this.generateBaseURL(), escapedUrl, BCCProp);
            }
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        return new Exch2kObjectIndex(oid);
    }

    protected Vector<HashMap<String, String>> search(String storeURL, Vector<String> itemList, SearchConditionCollection conds) throws NullPointerException, ServerDown, HandleException {
        Enumeration em;
        ExWebdavResource davClient;
        if (itemList == null) {
            return null;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        String storeUrl = this.generateStoreURL(storeURL);
        String string = "storeURL=" + storeUrl;
        EAIExch2kBase.debug_aroundBody51$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_25);
        try {
            davClient = new ExWebdavResource(storeUrl, cred);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        try {
            Vector<DavSearchCondition> conditions = new Vector<DavSearchCondition>();
            Iterator it = conds.iterator();
            while (it.hasNext()) {
                conditions.add(this.convertCondition((SearchCondition)it.next()));
            }
            em = davClient.searchPropMethod(1, itemList, conditions);
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        Vector<HashMap<String, String>> lists = new Vector<HashMap<String, String>>();
        while (em.hasMoreElements()) {
            Enumeration em2 = (Enumeration)em.nextElement();
            HashMap<String, String> list = new HashMap<String, String>();
            while (em2.hasMoreElements()) {
                BaseProperty o = (BaseProperty)em2.nextElement();
                list.put(o.getName(), o.getPropertyAsString());
                String string2 = String.valueOf(o.getName()) + "::" + o.getPropertyAsString();
                EAIExch2kBase.trace_aroundBody53$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_26);
            }
            lists.add(list);
        }
        try {
            davClient.close();
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        return lists;
    }

    protected Vector<HashMap<String, Object>> exGetListByDate(int depth, IFolderIndex folder, Vector<String> itemList, Date date, String dateColumnName) throws NullPointerException, ServerDown, HandleException {
        Enumeration em;
        ExWebdavResource davClient;
        block35: {
            if (itemList == null) {
                return null;
            }
            if (this.userID == null) {
                throw new NullPointerException("set userID first");
            }
            if (this.password == null) {
                throw new NullPointerException("set password first");
            }
            if (this.serverAddress == null) {
                throw new NullPointerException("set serverAddress first");
            }
            if (this.domain == null) {
                throw new NullPointerException("set domain first");
            }
            NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
            ArrayList<String> splitPath = this.dividePathInSharp(this.generateStoreURL((String)folder.getIndex()));
            String storeUrl = splitPath.get(0);
            String addPath = splitPath.get(1);
            String string = "storeURL=" + storeUrl + " addPath=" + addPath;
            EAIExch2kBase.debug_aroundBody55$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_27);
            String string2 = "date=" + date;
            EAIExch2kBase.debug_aroundBody57$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_28);
            try {
                davClient = new ExWebdavResource(storeUrl, cred);
            }
            catch (HttpException he) {
                Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
                if (he.getReasonCode() == 401) {
                    throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
                }
                throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
            }
            catch (IOException ie) {
                Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
                throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
            }
            catch (IllegalArgumentException iae) {
                Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
                throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
            }
            String string3 = "depth=" + depth;
            EAIExch2kBase.debug_aroundBody59$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_29);
            int d = Integer.MAX_VALUE;
            switch (depth) {
                case 0: {
                    d = 0;
                    break;
                }
                case 1: {
                    d = 1;
                }
            }
            try {
                if (date == null) {
                    em = davClient.searchPropMethod(addPath, d, itemList);
                    break block35;
                }
                Vector<DavSearchCondition> conds = new Vector<DavSearchCondition>();
                Date tmpDate = date;
                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
                String tmpStr = String.valueOf(df.format(date)) + " 00:00:00";
                try {
                    tmpDate = df2.parse(tmpStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                conds.add(new DavSearchCondition(dateColumnName, DavSearchType.TYPE_DATETIME_SZ, tmpDate, DavSearchOperator.OP_BIG_EQUAL));
                tmpStr = String.valueOf(df.format(date)) + " 23:59:59";
                try {
                    tmpDate = df2.parse(tmpStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                conds.add(new DavSearchCondition(dateColumnName, DavSearchType.TYPE_DATETIME_SZ, tmpDate, DavSearchOperator.OP_NOT_BIG));
                em = davClient.searchPropMethod(addPath, d, itemList, conds);
            }
            catch (HttpException he) {
                Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
                throw new ServerDown("WebdavResource:searchPropMethod:HttpException(" + he.getMessage() + ")");
            }
            catch (IOException ie) {
                Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
                throw new ServerDown("WebdavResource:searchPropMethod:IOException(" + ie.getMessage() + ")");
            }
        }
        Vector<HashMap<String, Object>> lists = new Vector<HashMap<String, Object>>();
        while (em.hasMoreElements()) {
            Enumeration em2 = (Enumeration)em.nextElement();
            HashMap<String, Object> list = new HashMap<String, Object>();
            while (em2.hasMoreElements()) {
                try {
                    BaseProperty o = (BaseProperty)em2.nextElement();
                    String propName = o.getName();
                    String value = o.getPropertyAsString();
                    list.put(propName, value);
                    String string = String.valueOf(propName) + "::" + value;
                    EAIExch2kBase.trace_aroundBody61$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_30);
                }
                catch (Exception e) {
                    Log.error((String)"error on getting property element.continue..", (Throwable)e);
                }
            }
            if (itemList.contains("urn:schemas:httpmail:attachmentfilename")) {
                String hasattachment = (String)list.get("hasattachment");
                String string = "hasattachment:" + hasattachment;
                EAIExch2kBase.debug_aroundBody63$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_31);
                if ("1".equals(hasattachment)) {
                    HashMap<String, Object> m = null;
                    try {
                        m = this.getAllAttachments(this.getRealEscapedURL((String)list.get("href")));
                    }
                    catch (Exception e) {
                        Log.error((String)"unexpected exception on getAllAttachments. ignore attachment information.", (Throwable)e);
                        try {
                            m = new HashMap();
                            m.put("file get error", "unexpected exception on getAllAttachments. ignore attachment information.".getBytes());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    list.put("attachmentfile", m);
                }
            }
            lists.add(list);
        }
        try {
            davClient.close();
        }
        catch (HttpException he) {
            Log.error((String)"error on closing davClient", (Throwable)he);
        }
        catch (IOException ie) {
            Log.error((String)"error on closing davClient", (Throwable)ie);
        }
        return lists;
    }

    private HashMap<String, byte[]> getAllAttachments(String encodedPath) throws NullPointerException, ServerDown, NoSuchRights {
        ExWebdavResource davClient;
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        String storeUrl = encodedPath;
        String addPath = "";
        try {
            ArrayList<String> splitPath = this.dividePathInSharp(URIUtil.decode((String)encodedPath, (String)"UTF-8"));
            storeUrl = splitPath.get(0);
            addPath = splitPath.get(1);
        }
        catch (Exception splitPath) {
            // empty catch block
        }
        String string = "getAllAttachments::storeURL=" + storeUrl + " addPath=" + addPath;
        EAIExch2kBase.debug_aroundBody65$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_32);
        try {
            davClient = new ExWebdavResource(storeUrl, cred);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        HashMap attachments = null;
        try {
            attachments = davClient.xmsEnumAttsMethod(addPath);
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        if (attachments == null) {
            return null;
        }
        Set keys = attachments.keySet();
        Iterator it = keys.iterator();
        HashMap<String, byte[]> list = new HashMap<String, byte[]>();
        while (it.hasNext()) {
            String url = (String)it.next();
            String string2 = "url:" + url;
            EAIExch2kBase.debug_aroundBody67$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_33);
            Enumeration em2 = (Enumeration)attachments.get(url);
            String fileName = null;
            while (em2.hasMoreElements()) {
                BaseProperty o = (BaseProperty)em2.nextElement();
                String propName = o.getName();
                String value = o.getPropertyAsString();
                String string3 = String.valueOf(propName) + "::" + value;
                EAIExch2kBase.trace_aroundBody69$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_34);
                if (propName.indexOf("attachmentfilename") >= 0) {
                    fileName = value;
                    break;
                }
                if (propName.indexOf("cn") < 0 || fileName != null) continue;
                fileName = String.valueOf(value) + ".eml";
            }
            url = this.getRealEscapedURL(url);
            String string4 = "url (after solve exchange encode bug):" + url;
            EAIExch2kBase.debug_aroundBody71$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_35);
            try {
                list.put(fileName, this.getFileBody(url));
            }
            catch (Exception e) {
                Log.error((String)("error on getting attachment body of file " + fileName + ", fill dummy into body"), (Throwable)e);
                list.put(fileName, "error on getting attachment body".getBytes());
            }
        }
        try {
            davClient.close();
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:close:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:close:IOException(" + ie.getMessage() + ")");
        }
        return list;
    }

    protected byte[] getFileBody(String fileName) throws ServerDown, NoSuchRights, NullPointerException {
        if (fileName == null) {
            return null;
        }
        String encodedURL = fileName;
        String string = "get the message stream of file " + encodedURL;
        EAIExch2kBase.debug_aroundBody73$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_36);
        InputStream is = this.getFileData(encodedURL);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int i;
            byte[] buf = new byte[8192];
            while ((i = is.read(buf)) > 0) {
                os.write(buf, 0, i);
            }
        }
        catch (IOException ie) {
            Log.error((String)"", (Throwable)ie);
            throw new ServerDown(ie.getMessage());
        }
        byte[] rc = os.toByteArray();
        return rc;
    }

    private Vector<String> getFirstChildlen(String path) throws ServerDown, NoSuchRights {
        Enumeration em;
        ExWebdavResource davClient;
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        ArrayList<String> splitPath = this.dividePathInSharp(path);
        String storeUrl = splitPath.get(0);
        String addPath = splitPath.get(1);
        String string = "storeURL=" + storeUrl + " addPath=" + addPath;
        EAIExch2kBase.debug_aroundBody75$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_37);
        try {
            davClient = new ExWebdavResource(storeUrl, cred);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        Vector<String> itemList = new Vector<String>();
        itemList.add("DAV:id");
        itemList.add("DAV:href");
        itemList.add("DAV:getcontentlength");
        try {
            em = davClient.searchFolderMethod(addPath, 1, itemList);
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        Vector<String> lists = new Vector<String>();
        while (em.hasMoreElements()) {
            Enumeration em2 = (Enumeration)em.nextElement();
            while (em2.hasMoreElements()) {
                BaseProperty o = (BaseProperty)em2.nextElement();
                try {
                    String string2 = String.valueOf(o.getName()) + "::" + URIUtil.decode((String)o.getPropertyAsString(), (String)"UTF-8");
                    EAIExch2kBase.trace_aroundBody77$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_38);
                    if (!o.getName().equals("href")) continue;
                    lists.add(URIUtil.decode((String)o.getPropertyAsString(), (String)"UTF-8"));
                }
                catch (URIException uRIException) {
                    // empty catch block
                }
            }
        }
        return lists;
    }

    protected Vector<Object> getAllSubFolders(String parentFolder) throws ServerDown, HandleException {
        String storeUrl = parentFolder.startsWith("http") ? parentFolder : this.generateStoreURL(parentFolder);
        Vector<Object> v = new Vector<Object>();
        String string = "getAllSubFolders:enter " + storeUrl;
        EAIExch2kBase.debug_aroundBody79$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_39);
        Vector<String> thisFolder = null;
        try {
            thisFolder = this.getFirstChildlen(storeUrl);
        }
        catch (NoSuchRights ne) {
            throw ne;
        }
        catch (Exception e) {
            String string2 = "getAllSubFolders:could not get subfolder of " + storeUrl;
            EAIExch2kBase.debug_aroundBody81$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_40);
            return v;
        }
        Enumeration<String> e = thisFolder.elements();
        while (e.hasMoreElements()) {
            String path = e.nextElement();
            if (path == null) continue;
            String string3 = "adding path to vector :" + path;
            EAIExch2kBase.debug_aroundBody83$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_41);
            Vector<Object> child = this.getAllSubFolders(path);
            v.add(child);
        }
        v.add(0, storeUrl);
        return v;
    }

    protected Vector<HashMap<String, Object>> getListByDate(IFolderIndex storeURL, Vector<String> itemList, Date date, String dateColumnName) throws NullPointerException, ServerDown, HandleException {
        Enumeration em;
        ExWebdavResource davClient;
        block23: {
            if (itemList == null) {
                return null;
            }
            if (this.userID == null) {
                throw new NullPointerException("set userID first");
            }
            if (this.password == null) {
                throw new NullPointerException("set password first");
            }
            if (this.serverAddress == null) {
                throw new NullPointerException("set serverAddress first");
            }
            if (this.domain == null) {
                throw new NullPointerException("set domain first");
            }
            NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
            String storeUrl = this.generateStoreURL((String)storeURL.getIndex());
            String string = "storeURL=" + storeUrl;
            EAIExch2kBase.debug_aroundBody85$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_42);
            try {
                davClient = new ExWebdavResource(storeUrl, cred);
            }
            catch (HttpException he) {
                if (he.getReasonCode() == 401) {
                    throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
                }
                Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
                throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
            }
            catch (IOException ie) {
                Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
                throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
            }
            catch (IllegalArgumentException iae) {
                Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
                throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
            }
            try {
                if (date == null) {
                    em = davClient.searchPropMethod(1, itemList);
                    break block23;
                }
                Vector<DavSearchCondition> conds = new Vector<DavSearchCondition>();
                Date tmpDate = date;
                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
                String tmpStr = String.valueOf(df.format(date)) + " 00:00:00";
                try {
                    tmpDate = df2.parse(tmpStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                conds.add(new DavSearchCondition(dateColumnName, DavSearchType.TYPE_DATETIME_SZ, tmpDate, DavSearchOperator.OP_BIG_EQUAL));
                tmpStr = String.valueOf(df.format(date)) + " 23:59:59";
                try {
                    tmpDate = df2.parse(tmpStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                conds.add(new DavSearchCondition(dateColumnName, DavSearchType.TYPE_DATETIME_SZ, tmpDate, DavSearchOperator.OP_NOT_BIG));
                em = davClient.searchPropMethod(1, itemList, conds);
            }
            catch (HttpException he) {
                Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
                throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
            }
            catch (IOException ie) {
                Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
                throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
            }
        }
        Vector<HashMap<String, Object>> lists = new Vector<HashMap<String, Object>>();
        while (em.hasMoreElements()) {
            Enumeration em2 = (Enumeration)em.nextElement();
            HashMap<String, String> list = new HashMap<String, String>();
            while (em2.hasMoreElements()) {
                BaseProperty o = (BaseProperty)em2.nextElement();
                list.put(o.getName(), o.getPropertyAsString());
                String string = String.valueOf(o.getName()) + "::" + o.getPropertyAsString();
                EAIExch2kBase.trace_aroundBody87$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_43);
            }
            lists.add(list);
        }
        try {
            davClient.close();
        }
        catch (HttpException he) {
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        return lists;
    }

    protected Vector<HashMap<String, Object>> getList(IFolderIndex storeURL, Vector<String> itemList) throws NullPointerException, ServerDown, HandleException {
        return this.getListByDate(storeURL, itemList, null, null);
    }

    public String getAdAddress() {
        return this.adAddress;
    }

    public void setAdAddress(String adAddress) {
        this.adAddress = adAddress;
    }

    public String getDomain() {
        return this.domain;
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getUserID() {
        return this.userID;
    }

    protected void setUserID(String userID) {
        this.userID = userID;
    }

    protected void setAccountData(PasswordBasedAccountDataImpl acc) throws HandleException {
        Exch2kServiceInfo si = (Exch2kServiceInfo)acc.getServiceInfo();
        this.setUserID(acc.getUserID());
        this.setPassword(acc.getPassword());
        this.setServerAddress(si);
    }

    protected void exSetAccountData(PasswordBasedAccountDataImpl acc, String idToSee) throws HandleException {
        Exch2kServiceInfo si = (Exch2kServiceInfo)acc.getServiceInfo();
        this.setUserID(acc.getUserID());
        this.setPassword(acc.getPassword());
        this.exSetServerAddress(idToSee, si);
    }

    protected Date davDateStr2JavaDate(String strDate) {
        Date date = null;
        try {
            if (strDate != null) {
                DavDateFormat sdf = new DavDateFormat();
                date = sdf.parse(strDate);
            }
        }
        catch (ParseException e) {
            String string = "Err\uff1a" + e.getMessage();
            EAIExch2kBase.debug_aroundBody89$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_44);
        }
        return date;
    }

    protected String javaDate2DavDateStr(Date date) {
        if (date == null) {
            return null;
        }
        DavDateFormat sdf = new DavDateFormat();
        return sdf.format(date);
    }

    protected String javaDate2MSDavDateStr(Date date) {
        if (date == null) {
            return null;
        }
        DavDateFormat sdf = new DavDateFormat(2);
        return sdf.format(date);
    }

    protected String escapeURL(String originalUrl) {
        try {
            return URIUtil.encodePath((String)originalUrl);
        }
        catch (URIException e) {
            return originalUrl;
        }
    }

    protected String getStringFromMessage(MimeMessage mmsg) {
        if (mmsg == null) {
            return null;
        }
        String msg = "";
        try {
            String tmp;
            Enumeration lines = mmsg.getAllHeaderLines();
            while (lines.hasMoreElements()) {
                msg = String.valueOf(msg) + (String)lines.nextElement() + "\r\n";
            }
            String string = msg = String.valueOf(msg) + "\r\n";
            EAIExch2kBase.debug_aroundBody91$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_45);
            InputStream is = mmsg.getInputStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(is), 1024);
            StringBuilder builder = new StringBuilder();
            builder.append(msg);
            while ((tmp = b.readLine()) != null) {
                builder.append(tmp);
                builder.append("\r\n");
            }
            msg = builder.toString();
        }
        catch (Exception e) {
            Log.error((String)"Exception on creating MimeMessage", (Throwable)e);
        }
        return msg;
    }

    protected String populateMessageFile(Hashtable<String, String> itemList) {
        String msg = "";
        String subject = itemList.get("urn:schemas:httpmail:subject");
        String body = itemList.get("urn:schemas:httpmail:textdescription");
        String from = itemList.get("urn:schemas:httpmail:sendername");
        if (from == null) {
            from = itemList.get("urn:schemas:httpmail:from");
        }
        try {
            MimeMessage mmsg = new MimeMessage(null);
            MimeMultipart part = new MimeMultipart();
            MimeBodyPart pbody = new MimeBodyPart();
            pbody.setText(body, "UTF-8");
            part.addBodyPart((BodyPart)pbody);
            mmsg.setSubject(subject, "UTF-8");
            if (from != null) {
                String name;
                MailAddress add = new MailAddress(from);
                String address = add.getAddressPart();
                if (address.equals(name = add.getNamePart())) {
                    mmsg.setFrom((Address)new InternetAddress(address, name, "UTF-8"));
                } else {
                    mmsg.setFrom((Address)new InternetAddress(address));
                }
            }
            mmsg.setContent((Multipart)part);
            mmsg.saveChanges();
            msg = this.getStringFromMessage(mmsg);
        }
        catch (Exception e) {
            Log.error((String)"Exception on creating MimeMessage", (Throwable)e);
        }
        return msg;
    }

    protected int delete(IObjectIndex oid) throws NullPointerException, ServerDown, NoSuchRights {
        ExWebdavResource davClient;
        String encodedurl;
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        String url = encodedurl = (String)oid.getIndex();
        try {
            url = URIUtil.decode((String)encodedurl, (String)"UTF-8");
            String string = "delete:encodedurl=" + encodedurl + ":delodedurl=" + url;
            EAIExch2kBase.debug_aroundBody93$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_46);
        }
        catch (Exception exception) {
            // empty catch block
        }
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        try {
            davClient = new ExWebdavResource(this.generateBaseURL(), cred);
            davClient.deleteMethod(url);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        int code = davClient.getStatusCode();
        return code;
    }

    protected MimeMessage getMessageInstance() {
        Properties env = new Properties();
        env.put("mail.smtp.host", this.getServerAddress());
        Session session = Session.getDefaultInstance((Properties)env);
        MimeMessage msg = new MimeMessage(session);
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    protected HashMap<String, Object> getFile(String encodedurl) throws NullPointerException, ServerDown, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        em2 = null;
        url = encodedurl;
        try {
            url = URIUtil.decode((String)encodedurl, (String)"UTF-8");
        }
        catch (Exception var6_4) {
            // empty catch block
        }
        var13_6 = "decoded url=" + url;
        EAIExch2kBase.debug_aroundBody95$advice(this, var13_6, LogAspect.aspectOf(), var13_6, null, EAIExch2kBase.ajc$tjp_47);
        cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        msg = new HashMap<String, Object>();
        try {
            davClient = new ExWebdavResource(this.generateBaseURL(), cred);
            em = davClient.propfindMethod(url, 0);
            if (em != null && em.hasMoreElements()) {
                r = (ResponseEntity)em.nextElement();
                em2 = r.getProperties();
            }
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        code = davClient.getStatusCode();
        if (em2 != null) ** GOTO lbl51
        throw new HandleException("Server doesn't return proper mail data:code=" + code);
lbl-1000:
        // 1 sources

        {
            o = (BaseProperty)em2.nextElement();
            propName = o.getName();
            old = msg.put(propName = propName.substring(propName.indexOf(58) + 1), value = o.getPropertyAsString());
            if (old != null) {
                msg.put(propName, old);
                msg.put(o.getName(), value);
            }
            var14_19 = String.valueOf(propName) + "::" + value;
            EAIExch2kBase.trace_aroundBody97$advice(this, var14_19, LogAspect.aspectOf(), var14_19, null, EAIExch2kBase.ajc$tjp_48);
lbl51:
            // 2 sources

            ** while (em2.hasMoreElements())
        }
lbl52:
        // 1 sources

        hasattachment = (String)msg.get("hasattachment");
        var15_20 = "hasattachment:" + hasattachment;
        EAIExch2kBase.debug_aroundBody99$advice(this, var15_20, LogAspect.aspectOf(), var15_20, null, EAIExch2kBase.ajc$tjp_49);
        if ("1".equals(hasattachment)) {
            m = this.getAllAttachments(this.getRealEscapedURL((String)msg.get("href")));
            msg.put("attachmentfile", m);
        }
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    protected HashMap<String, Object> getProps(String encodedurl, Vector<String> itemList) throws NullPointerException, ServerDown, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        em2 = null;
        url = encodedurl;
        try {
            url = URIUtil.decode((String)encodedurl, (String)"UTF-8");
        }
        catch (Exception var7_5) {
            // empty catch block
        }
        var14_7 = "decoded url=" + url;
        EAIExch2kBase.debug_aroundBody101$advice(this, var14_7, LogAspect.aspectOf(), var14_7, null, EAIExch2kBase.ajc$tjp_50);
        cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        msg = new HashMap<String, Object>();
        try {
            davClient = new ExWebdavResource(this.generateBaseURL(), cred);
            em = davClient.propfindMethod(url, 0, itemList);
            if (em != null && em.hasMoreElements()) {
                r = (ResponseEntity)em.nextElement();
                em2 = r.getProperties();
            }
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        code = davClient.getStatusCode();
        if (em2 != null) ** GOTO lbl51
        throw new HandleException("Server doesn't return proper mail data:code=" + code);
lbl-1000:
        // 1 sources

        {
            o = (BaseProperty)em2.nextElement();
            propName = o.getName();
            old = msg.put(propName = propName.substring(propName.indexOf(58) + 1), value = o.getPropertyAsString());
            if (old != null) {
                msg.put(propName, old);
                msg.put(o.getName(), value);
            }
            var15_20 = String.valueOf(propName) + "::" + value;
            EAIExch2kBase.trace_aroundBody103$advice(this, var15_20, LogAspect.aspectOf(), var15_20, null, EAIExch2kBase.ajc$tjp_51);
lbl51:
            // 2 sources

            ** while (em2.hasMoreElements())
        }
lbl52:
        // 1 sources

        hasattachment = (String)msg.get("hasattachment");
        var16_21 = "hasattachment:" + hasattachment;
        EAIExch2kBase.debug_aroundBody105$advice(this, var16_21, LogAspect.aspectOf(), var16_21, null, EAIExch2kBase.ajc$tjp_52);
        if ("1".equals(hasattachment)) {
            m = this.getAllAttachments(this.getRealEscapedURL((String)msg.get("href")));
            msg.put("attachmentfile", m);
        }
        return msg;
    }

    protected String getRealEscapedURL(String srcUrl) {
        try {
            return URIUtil.encodePath((String)URIUtil.decode((String)srcUrl, (String)"UTF-8"), (String)"UTF-8");
        }
        catch (Exception exception) {
            return srcUrl;
        }
    }

    protected InputStream getFileData(String encodedurl) throws NullPointerException, ServerDown, NoSuchRights {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        if (this.domain == null) {
            throw new NullPointerException("set domain first");
        }
        String string = "url=" + encodedurl;
        EAIExch2kBase.debug_aroundBody107$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_53);
        String url = encodedurl;
        try {
            url = URIUtil.decode((String)encodedurl, (String)"UTF-8");
            url = url.substring(0, url.lastIndexOf(47));
            ArrayList<String> splitPath = this.dividePathInSharp(this.generateStoreURL(url));
            url = splitPath.get(0);
        }
        catch (Exception splitPath) {
            // empty catch block
        }
        String string2 = "decoded url=" + url;
        EAIExch2kBase.debug_aroundBody109$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_54);
        NTCredentials cred = new NTCredentials(this.userID, this.password, this.serverAddress, this.domain);
        InputStream is = null;
        try {
            ExWebdavResource davClient = new ExWebdavResource(url, cred);
            is = davClient.getMethodData(encodedurl);
        }
        catch (HttpException he) {
            if (he.getReasonCode() == 401) {
                throw new NoSuchRights("WebdavResource:Authentication failed(" + he.getMessage() + ")");
            }
            Log.error((String)("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")"), (Throwable)he);
            throw new ServerDown("WebdavResource:HttpException(" + he.getMessage() + " : " + he.getReasonCode() + ")");
        }
        catch (IOException ie) {
            Log.error((String)("WebdavResource:IOException(" + ie.getMessage() + ")"), (Throwable)ie);
            throw new ServerDown("WebdavResource:IOException(" + ie.getMessage() + ")");
        }
        catch (IllegalArgumentException iae) {
            Log.error((String)("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ")"), (Throwable)iae);
            throw new ServerDown("WebdavResource:IllegalArgumentException(" + iae.getMessage() + ") check serverAddress/domain");
        }
        return is;
    }

    public String getMailAddress() {
        return this.mailAddress;
    }

    protected Address populateAddress(MailAddress src) {
        InternetAddress add = null;
        if (src == null) {
            return add;
        }
        try {
            String address = src.getAddressPart();
            if (address == null) {
                address = src.getRawAddress();
            }
            String name = src.getNamePart();
            String raw = src.getRawAddress();
            if (address.equalsIgnoreCase(raw)) {
                if (address.indexOf(64) < 1) {
                    address = String.valueOf(address) + "@" + this.getDomain();
                }
                add = new InternetAddress(address, name, "ISO-2022-JP");
            } else {
                if (raw.indexOf(64) < 1) {
                    raw = String.valueOf(raw) + "@" + this.getDomain();
                }
                add = new InternetAddress(raw);
            }
        }
        catch (UnsupportedEncodingException ue) {
            Log.error((String)"", (Throwable)ue);
        }
        catch (AddressException ae) {
            Log.error((String)"", (Throwable)ae);
        }
        return add;
    }

    public IRecordObject getFolderIndexFromString(String folderName) throws IncorrectData {
        if (folderName == null) {
            folderName = this.getElmentName();
        }
        BasicRecordObject rc = new BasicRecordObject();
        rc.setOid((IObjectIndex)new Exch2kFolderIndex(folderName));
        HashMap<String, IObjectIndex> h = new HashMap<String, IObjectIndex>();
        h.put("IFolderIndex", rc.getOid());
        try {
            rc.setFieldSet(h);
        }
        catch (IllegalAccessException e) {
            Log.error((String)"getFolderIndexFromString:error on setting IFolderIndex", (Throwable)e);
            throw new IncorrectData("getFolderIndexFromString:error on setting IFolderIndex");
        }
        return rc;
    }

    protected FolderMetadata populateFolder(IFolderIndex idx) {
        FolderMetadata folder = new FolderMetadata();
        folder.setOid((IObjectIndex)idx);
        HashMap<String, IFolderIndex> h = new HashMap<String, IFolderIndex>();
        h.put("oid", idx);
        folder.setFieldSet(h);
        folder.setFolderName(idx.getIndex().toString());
        return folder;
    }

    protected ArrayList<FolderMetadata> populateFolderList(int layer, String root, Vector<Object> src) throws HandleException {
        if (src == null) {
            return null;
        }
        if (src.size() == 0) {
            return null;
        }
        Enumeration<Object> em = src.elements();
        ArrayList<FolderMetadata> dst = new ArrayList<FolderMetadata>();
        String path = null;
        String sub = null;
        String layerStr = "";
        int i = 0;
        while (i < layer) {
            layerStr = String.valueOf(layerStr) + "-";
            ++i;
        }
        while (em.hasMoreElements()) {
            Object o = em.nextElement();
            try {
                Class<?> c = o.getClass();
                if (c.equals(Class.forName("java.lang.String"))) {
                    String string = "raw data of foldername:" + (String)o;
                    EAIExch2kBase.debug_aroundBody111$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_55);
                    FolderMetadata folder = new FolderMetadata();
                    path = (String)o;
                    sub = path.substring(path.indexOf(root) + root.length());
                    String string2 = "substring:" + sub;
                    EAIExch2kBase.debug_aroundBody113$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_56);
                    Exch2kFolderIndex oid = new Exch2kFolderIndex(path);
                    folder.setOid((IObjectIndex)oid);
                    String string3 = "oid:" + (String)oid.getIndex();
                    EAIExch2kBase.debug_aroundBody115$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_57);
                    HashMap<String, Exch2kFolderIndex> h = new HashMap<String, Exch2kFolderIndex>();
                    h.put("oid", oid);
                    folder.setFieldSet(h);
                    String string4 = "layerStr:" + layerStr;
                    EAIExch2kBase.debug_aroundBody117$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_58);
                    folder.setFolderName(String.valueOf(layerStr) + sub.replaceAll("/", ""));
                    String string5 = "folderName:" + folder.getFolderName();
                    EAIExch2kBase.debug_aroundBody119$advice(this, string5, LogAspect.aspectOf(), string5, null, ajc$tjp_59);
                    dst.add(folder);
                    continue;
                }
                if (!c.equals(Class.forName("java.util.Vector"))) continue;
                Vector v = (Vector)o;
                dst.addAll(this.populateFolderList(layer + 1, path, v));
            }
            catch (ClassNotFoundException e) {
                throw new HandleException(e.getMessage());
            }
        }
        return dst;
    }

    protected IRecordObject makeIDObject(Object o) throws HandleException {
        BasicObjectIndex idx = new BasicObjectIndex(o);
        BasicRecordObject ro = new BasicRecordObject();
        HashMap<String, BasicObjectIndex> h = new HashMap<String, BasicObjectIndex>();
        h.put("UNID", idx);
        try {
            ro.setFieldSet(h);
            ro.setOid((IObjectIndex)idx);
        }
        catch (IllegalAccessException iae) {
            Log.error((String)"error setting HashMap with IObjectIndex to BasicRecordObject.", (Throwable)iae);
            throw new HandleException("error setting HashMap with IObjectIndex to BasicRecordObject.");
        }
        return ro;
    }

    public IServiceInfo getServiceInfo(IStoreID storeID, String storeName, IServiceInfoRawData serviceData) throws Exception {
        String tmp;
        HashMap h = serviceData.getFieldSet();
        Exch2kServiceInfo info = new Exch2kServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        if ((tmp = (String)h.get("casAddress")) != null) {
            info.setCasAddress(tmp);
        }
        if ((tmp = (String)h.get("protocolPrefix")) != null) {
            info.setProtocolPrefix(tmp);
        }
        if ((tmp = (String)h.get("standbyADAddress")) != null) {
            info.setStandbyADAddress(tmp);
        }
        return info;
    }

    private ArrayList<String> dividePathInSharp(String url) {
        ArrayList<String> al = new ArrayList<String>(2);
        String storeUrl = url;
        String addPath = "";
        String[] splitPath = storeUrl.split("/");
        int i = 0;
        while (i < splitPath.length) {
            if (splitPath[i].indexOf("#") > -1) {
                storeUrl = "";
                int j = 0;
                while (j < i) {
                    storeUrl = String.valueOf(storeUrl) + splitPath[j] + "/";
                    ++j;
                }
                j = i;
                while (j < splitPath.length) {
                    addPath = String.valueOf(addPath) + this.escapeURL(splitPath[j]) + "/";
                    ++j;
                }
                break;
            }
            ++i;
        }
        al.add(0, storeUrl);
        al.add(1, addPath);
        return al;
    }

    public String getAdAddress2() {
        return this.adAddress2;
    }

    public void setAdAddress2(String adAddress2) {
        this.adAddress2 = adAddress2;
    }

    private static final /* synthetic */ void debug_aroundBody0(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody12(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody13$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody14(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody15$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody16(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody17$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody18(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody19$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody20(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody21$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody22(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody23$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody24(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody25$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody26(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody27$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody28(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody29$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody30(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody31$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody32(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody33$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody34(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody35$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody36(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody37$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody38(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody39$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody40(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody41$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody42(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody43$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody44(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody45$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody46(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody47$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody48(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody49$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody50(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody51$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody52(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody53$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody54(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody55$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody56(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody57$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody58(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody59$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody60(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody61$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody62(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody63$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody64(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody65$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody66(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody67$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody68(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody69$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody70(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody71$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody72(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody73$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody74(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody75$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody76(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody77$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody78(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody79$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody80(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody81$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody82(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody83$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody84(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody85$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody86(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody87$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody88(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody89$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody90(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody91$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody92(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody93$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody94(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody95$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody96(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody97$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody98(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody99$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody100(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody101$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody102(EAIExch2kBase eAIExch2kBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody103$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody104(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody105$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody106(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody107$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody108(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody109$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody110(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody111$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody112(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody113$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody114(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody115$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody116(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody117$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody118(EAIExch2kBase eAIExch2kBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody119$advice(EAIExch2kBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EAIExch2kBase.java", Class.forName("jp.co.connectone.eai.exch2k.store.EAIExch2kBase"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 81);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 98);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 390);
        ajc$tjp_11 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 407);
        ajc$tjp_12 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 414);
        ajc$tjp_13 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 416);
        ajc$tjp_14 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 420);
        ajc$tjp_15 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 428);
        ajc$tjp_16 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 433);
        ajc$tjp_17 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 436);
        ajc$tjp_18 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 439);
        ajc$tjp_19 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 441);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 127);
        ajc$tjp_20 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 465);
        ajc$tjp_21 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 519);
        ajc$tjp_22 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 547);
        ajc$tjp_23 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 584);
        ajc$tjp_24 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 586);
        ajc$tjp_25 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 650);
        ajc$tjp_26 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 696);
        ajc$tjp_27 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 731);
        ajc$tjp_28 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 732);
        ajc$tjp_29 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 753);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 162);
        ajc$tjp_30 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 811);
        ajc$tjp_31 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 819);
        ajc$tjp_32 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 871);
        ajc$tjp_33 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 912);
        ajc$tjp_34 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 919);
        ajc$tjp_35 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 939);
        ajc$tjp_36 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 967);
        ajc$tjp_37 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 996);
        ajc$tjp_38 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1039);
        ajc$tjp_39 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1063);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 168);
        ajc$tjp_40 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1072);
        ajc$tjp_41 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1079);
        ajc$tjp_42 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1100);
        ajc$tjp_43 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1166);
        ajc$tjp_44 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1328);
        ajc$tjp_45 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1368);
        ajc$tjp_46 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1445);
        ajc$tjp_47 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1504);
        ajc$tjp_48 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1547);
        ajc$tjp_49 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1550);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 212);
        ajc$tjp_50 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1577);
        ajc$tjp_51 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1620);
        ajc$tjp_52 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1623);
        ajc$tjp_53 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1650);
        ajc$tjp_54 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1661);
        ajc$tjp_55 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1773);
        ajc$tjp_56 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1777);
        ajc$tjp_57 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1780);
        ajc$tjp_58 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1784);
        ajc$tjp_59 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 1786);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 219);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 225);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 271);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 336);
    }
}

