/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exch2k.dav;

import java.util.Date;
import jp.co.connectone.eai.exch2k.dav.DavDateFormat;
import jp.co.connectone.eai.exch2k.dav.DavSearchOperator;
import jp.co.connectone.eai.exch2k.dav.DavSearchType;

public class DavSearchCondition {
    private String name;
    private Object value;
    private DavSearchType type;
    private DavSearchOperator operator;

    protected String buildOpString(String namePart, DavSearchOperator operator, String valuePart) {
        namePart = "\"" + namePart + "\"";
        if (operator.equals(DavSearchOperator.OP_NOT_EQUAL)) {
            return "NOT(" + namePart + " = " + valuePart + ")";
        }
        if (operator.equals(DavSearchOperator.OP_BIG_EQUAL)) {
            return String.valueOf(namePart) + " >= " + valuePart;
        }
        if (operator.equals(DavSearchOperator.OP_BIG)) {
            return String.valueOf(namePart) + " > " + valuePart;
        }
        if (operator.equals(DavSearchOperator.OP_NOT_BIG_EQUAL)) {
            return "NOT(" + namePart + " >= " + valuePart + ")";
        }
        if (operator.equals(DavSearchOperator.OP_NOT_BIG)) {
            return "NOT(" + namePart + " > " + valuePart + ")";
        }
        if (operator.equals(DavSearchOperator.OP_SMALL_EQUAL)) {
            return String.valueOf(namePart) + " <= " + valuePart;
        }
        if (operator.equals(DavSearchOperator.OP_SMALL)) {
            return String.valueOf(namePart) + " < " + valuePart;
        }
        if (operator.equals(DavSearchOperator.OP_NOT_SMALL_EQUAL)) {
            return "NOT(" + namePart + " <= " + valuePart + ")";
        }
        if (operator.equals(DavSearchOperator.OP_NOT_SMALL)) {
            return "NOT(" + namePart + " < " + valuePart + ")";
        }
        if (operator.equals(DavSearchOperator.OP_LIKE)) {
            return String.valueOf(namePart) + " LIKE " + valuePart;
        }
        if (operator.equals(DavSearchOperator.OP_FORWARD_LIKE)) {
            return String.valueOf(namePart) + " LIKE " + valuePart;
        }
        return String.valueOf(namePart) + "=" + valuePart;
    }

    protected String buildCast(DavSearchType type, Object value, DavSearchOperator operator) {
        DavDateFormat sdf = new DavDateFormat();
        if (type.equals(DavSearchType.TYPE_INTEGER)) {
            return "\"" + (String)value + "\"";
        }
        if (type.equals(DavSearchType.TYPE_DATETIME_SZ)) {
            return "CAST(\"" + sdf.format((Date)value) + "\" AS \"dateTime\")";
        }
        String rc = "'" + (String)value + "'";
        if (type.equals(DavSearchType.TYPE_STRING)) {
            if (operator.equals(DavSearchOperator.OP_LIKE)) {
                rc = "'%" + (String)value + "%'";
            } else if (operator.equals(DavSearchOperator.OP_FORWARD_LIKE)) {
                rc = "'" + (String)value + "%'";
            }
        }
        return rc;
    }

    public String getDavSQLWhereClause() {
        String clause = null;
        clause = this.buildOpString(this.name, this.operator, this.buildCast(this.type, this.value, this.operator));
        return clause;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DavSearchOperator getOperator() {
        return this.operator;
    }

    public void setOperator(DavSearchOperator operator) {
        this.operator = operator;
    }

    public DavSearchType getType() {
        return this.type;
    }

    public void setType(DavSearchType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value != null && !(value instanceof String) && !(value instanceof Date)) {
            throw new IllegalArgumentException("value must be an instance of String/Date");
        }
        this.value = value;
    }

    public DavSearchCondition(String name, DavSearchType type, Object value, DavSearchOperator operator) throws IllegalArgumentException {
        this.setName(name);
        this.setType(type);
        this.setValue(value);
        this.setOperator(operator);
    }
}

