/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.webapps.helpers;

import java.net.URLEncoder;
import jp.co.connectone.store.pim.IMemoDTO;
import jp.co.connectone.store.pim.MemoParseHelper;
import jp.co.connectone.webapps.helpers.WebParserAggregationBase;

public class WebMemoParseHelper
extends MemoParseHelper {
    private static final long serialVersionUID = 1L;
    protected WebParserAggregationBase extention = new WebParserAggregationBase();

    public void setMemoDTO(IMemoDTO arg0) {
        this.copy(arg0);
        this.setBody(this.extention.formatBody(this.getBody()));
    }

    public int getPrevPage() {
        return this.extention.getPrevPage();
    }

    public int getNextPage() {
        return this.extention.getNextPage();
    }

    public String getBodyHtml() {
        String rc = super.getBody();
        if (rc == null) {
            return rc;
        }
        rc.replaceAll("\n", "<BR>\n");
        rc = this.extention.pagingString(rc);
        rc = this.extention.escapeTags(rc);
        rc = this.extention.formatBody(rc);
        return rc;
    }

    public String getSubject() {
        String rc = super.getSubject();
        if (rc == null) {
            return "\u7121\u984c";
        }
        if (rc.length() == 0) {
            return "\u7121\u984c";
        }
        return rc;
    }

    public String getEscapedId() {
        String rc = this.getTid();
        try {
            rc = URLEncoder.encode(this.getTid(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    public int getBodyLength() {
        return this.extention.getBodyLength();
    }

    public void setBodyLength(int bodyLength) {
        this.extention.setBodyLength(bodyLength);
    }

    public int getCurrentPage() {
        return this.extention.getCurrentPage();
    }

    public void setCurrentPage(int currentPage) {
        this.extention.setCurrentPage(currentPage);
    }

    public WebMemoParseHelper(MemoParseHelper org) {
        super(org.getMemoDTO());
        super.setTid("" + this.extention.getNextID());
    }

    public int getLastPage() {
        return this.extention.getLastPage(super.getBody());
    }

    public void escapeTags() {
        super.setSubject(this.extention.escapeTags(super.getSubject()));
        super.setBody(this.extention.escapeTags(super.getBody()));
    }
}

