/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.pim;

import java.util.Comparator;
import java.util.Date;
import jp.co.connectone.store.pim.ITaskDTO;

public class ITaskDTOComparator
implements Comparator<ITaskDTO> {
    public static final int SUBJECT = 0;
    public static final int BODY = 1;
    public static final int TASKDATE = 2;
    private int sortKey = 0;
    private boolean reverce = false;

    public ITaskDTOComparator(int sortKey, boolean isReverce) {
        this.sortKey = sortKey;
        this.reverce = isReverce;
    }

    @Override
    public int compare(ITaskDTO o1, ITaskDTO o2) {
        if (o1 == null) {
            return 0;
        }
        if (o2 == null) {
            return 0;
        }
        ITaskDTO src = o1;
        ITaskDTO dst = o2;
        switch (this.sortKey) {
            case 0: {
                String s1 = src.getSubject();
                String s2 = dst.getSubject();
                if (this.reverce) {
                    return s2.compareTo(s1);
                }
                return s1.compareTo(s2);
            }
            case 1: {
                String s1 = src.getBody();
                String s2 = dst.getBody();
                if (this.reverce) {
                    return s2.compareTo(s1);
                }
                return s1.compareTo(s2);
            }
            case 2: {
                Date d1 = src.getDate();
                Date d2 = dst.getDate();
                if (this.reverce) {
                    return d2.compareTo(d1);
                }
                return d1.compareTo(d2);
            }
        }
        return 0;
    }
}

