﻿using System;
using System.Collections.Generic;

namespace CompleteEraser
{
    class ProgressingEventArgs : EventArgs
    {
        public string fileName;
        public ProgressingEventArgs(string filename)
        {
            this.fileName = filename;
        }
    }
    class ProgressedEventArgs : EventArgs
    {
        public string fileName;
        public bool breaked;
        public bool retry;
        public Exception ex;
        public ProgressedEventArgs(string filename, Exception ex)
        {
            this.fileName = filename;
            this.ex = ex;
            this.breaked = false;
            this.retry = false;
        }
    }

    delegate void ProgressingEventHandler(object sender, ProgressingEventArgs e);
    delegate void ProgressedEventHandler(object sender, ProgressedEventArgs e);
    
    interface IOperation
    {
        event ProgressingEventHandler Progressing;
        event ProgressedEventHandler Progressed;
        void Execute(IEnumerable<string> targets);
    }
}
