﻿using System;
using System.IO;
using System.Collections.Generic;

namespace CompleteEraser
{
    class RecyleBinCollection : IEnumerable<string>
    {
        public IEnumerator<string> GetEnumerator()
        {
            string[] rootDirectory = new string[] {
					    "$RECYCLE.BIN",
					    "RECYCLER"
				    };
            string userSid = System.Security.Principal.WindowsIdentity.GetCurrent().
                User.ToString();

            List<string> result = new List<string>();

            foreach (DriveInfo drive in DriveInfo.GetDrives())
            {
                foreach (string rootDir in rootDirectory)
                {
                    string dir = Path.Combine(Path.Combine(drive.Name, rootDir), userSid);
                    if (Directory.Exists(dir) == false)
                        continue;

                    foreach (string file in Directory.GetFiles(dir, "*.*",SearchOption.AllDirectories))
                    {
                        if (file.IndexOf("desktop.ini") == -1)
                            yield return file;
                    }
                    foreach (string file in Directory.GetDirectories(dir,"*.*"))
                    {
                        yield return file;
                    }
                }
            }
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }
    }
}
