#include "ContextMenu.h"
#include "resource.h"

#define EXEPATH L"CompleteEraser.EXE"

HANDLE CContextMenu::m_hMapping;

CContextMenu::CContextMenu()
{
	m_cRef = 1;

	WCHAR wszLocale[MAX_PATH];
	GetLocaleInfoW(GetThreadLocale(),
				LOCALE_SABBREVLANGNAME,wszLocale,MAX_PATH);
	_wsetlocale(LC_ALL,wszLocale);

	LockModule(TRUE);
}

CContextMenu::~CContextMenu()
{
	LockModule(FALSE);
}

STDMETHODIMP_(ULONG) CContextMenu::AddRef()
{
	return InterlockedIncrement(&m_cRef);
}

STDMETHODIMP_(ULONG) CContextMenu::Release()
{
	if (InterlockedDecrement(&m_cRef) == 0) {	
		delete this;
		return 0;
	}

	return m_cRef;
}

STDMETHODIMP CContextMenu::QueryInterface(REFIID riid, void **ppvObject)
{
	*ppvObject = NULL;

	if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IContextMenu))
		*ppvObject = static_cast<IContextMenu *>(this);
	else if (IsEqualIID(riid, IID_IShellExtInit))
		*ppvObject = static_cast<IShellExtInit *>(this);
	else
		return E_NOINTERFACE;

	AddRef();

	return S_OK;
}

STDMETHODIMP CContextMenu::Initialize(PCIDLIST_ABSOLUTE pidlFolder, IDataObject *pdtobj, HKEY hkeyProgID)
{
	WCHAR* temp;
	DWORD size;
	::RegQueryValueEx(hkeyProgID,L"",NULL,NULL,NULL,&size);
	temp = new WCHAR[size];
	::RegQueryValueEx(hkeyProgID,L"",NULL,NULL,(LPBYTE)temp,&size);
	std::wstring value(temp);

	if(value == L"Recycle Bin")
	{
		menutype = ClearRecyleBin;
		return S_OK;
	}

	FORMATETC fetc = {CF_HDROP, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL };

	STGMEDIUM medium;
	HRESULT hr = pdtobj->GetData(&fetc, &medium);
	if(FAILED(hr))
		return hr;

	HDROP DropData = (HDROP)GlobalLock(medium.hGlobal);	//bNȂƗ邱Ƃ

	UINT count = DragQueryFile(DropData,0xFFFFFFFF,NULL,0);

	for(UINT i = 0; i < count; i++)
	{
		WCHAR file[_MAX_PATH];
		DragQueryFile((HDROP)medium.hGlobal, i, file, sizeof(file));
		this->strs.append(file);
		this->strs.append(L"\n");
	}

	GlobalUnlock(DropData);

	ReleaseStgMedium(&medium);

	menutype = ClearFileNames;

	return S_OK;
}

STDMETHODIMP CContextMenu::QueryContextMenu(HMENU hmenu, UINT indexMenu, UINT idCmdFirst, UINT idCmdLast, UINT uFlags)
{
	MENUITEMINFO mii;
	
	if (uFlags & CMF_DEFAULTONLY)
		return MAKE_SCODE(SEVERITY_SUCCESS, FACILITY_NULL, 0);

	mii.cbSize     = sizeof(MENUITEMINFO);
	mii.fMask      = MIIM_ID | MIIM_TYPE;
	mii.fType      = MFT_STRING;
	mii.wID        = idCmdFirst;

	if(menutype == ClearFileNames)
	{
		std::wstring str;
		MyLoadString(str,MENUITEMNAME);
		mii.dwTypeData = const_cast<LPWSTR>(str.c_str());
		InsertMenuItem(hmenu, indexMenu, TRUE, &mii);
	}else if(menutype == ClearRecyleBin){
		std::wstring str;
		MyLoadString(str,MENUITEMNAME_RECYLEBIN);
		mii.dwTypeData = const_cast<LPWSTR>(str.c_str());

		SHQUERYRBINFO sqrbi;
		ZeroMemory(&sqrbi, sizeof(sqrbi));
		sqrbi.cbSize = sizeof(sqrbi);
		if(SUCCEEDED(SHQueryRecycleBin(NULL, &sqrbi)))
		{
			mii.fState |= (sqrbi.i64NumItems != 0) ? MFS_ENABLED : MFS_DISABLED;
		}

		InsertMenuItem(hmenu, indexMenu, TRUE, &mii);
	}
	
	return MAKE_SCODE(SEVERITY_SUCCESS, FACILITY_NULL, 2);
}

STDMETHODIMP CContextMenu::InvokeCommand(LPCMINVOKECOMMANDINFO pici)
{
	UINT idCmd = LOWORD(pici->lpVerb);

	if (HIWORD(pici->lpVerb) != 0)
		return E_INVALIDARG;

	if (idCmd != 0)
		return S_OK;

	std::wstring str;
	MyLoadString(str,CONFIRMDELETE);
	if(MessageBoxW(NULL,str.c_str(),NULL,MB_YESNO) == IDNO)
		return S_OK;

	if (menutype == ClearFileNames)
	{
		UINT mapSize = this->strs.length() * 2;

		m_hMapping = ::CreateFileMappingW(INVALID_HANDLE_VALUE,
			NULL,
			PAGE_READWRITE,
			0,
			mapSize,
			L"CompleteEraser.MemMap");
		if(m_hMapping == NULL)
			return E_FAIL;

		void *m_pMappingView = MapViewOfFile(m_hMapping, FILE_MAP_ALL_ACCESS, 0, 0, 0);
		if(m_pMappingView == NULL)
			return E_FAIL;

		::wcscat_s((LPWSTR)m_pMappingView,mapSize,this->strs.c_str());

		UnmapViewOfFile(m_pMappingView);

		DWORD dwID;
		CreateThread(NULL , 0 , ThreadFunc , (LPVOID)this , 0 , &dwID);
	}
	else if (menutype == ClearRecyleBin)
	{
		RunCompleteEraer(L"/recylebin");
	}

	return S_OK;
}

STDMETHODIMP CContextMenu::GetCommandString(UINT_PTR idCmd, UINT uFlags, UINT *pwReserved, LPSTR pszName, UINT cchMax)
{
	if (idCmd == 0) {
		std::wstring str;
		if (uFlags == GCS_HELPTEXTW)
		{
			MyLoadString(str,MENUHELPMSG);
			::wcscpy_s((LPWSTR)pszName,cchMax,str.c_str());
		}
		else if (uFlags == GCS_VERBW)
		{
			MyLoadString(str,MENUITEMNAME);
			::wcscpy_s((LPWSTR)pszName,cchMax,str.c_str());
		}
	}
	else
		return E_FAIL;

	return S_OK;
}

DWORD WINAPI CContextMenu::ThreadFunc(LPVOID pParam)
{
	HANDLE hProcess = RunCompleteEraer(L"");

	WaitForSingleObject(hProcess,INFINITE);

	CloseHandle(m_hMapping);

	return 0;
}

HANDLE CContextMenu::RunCompleteEraer(LPTSTR cmdline)
{
	WCHAR modPath[_MAX_PATH];
	GetModulePath(modPath,_MAX_PATH);

	SHELLEXECUTEINFO info = {0};
	info.cbSize = sizeof(info);
	info.hwnd = NULL;
	info.nShow = SW_SHOWNORMAL;
	info.fMask = SEE_MASK_NOCLOSEPROCESS;
	info.lpDirectory = modPath;
	info.lpFile = EXEPATH;
	info.lpParameters = cmdline;
	ShellExecuteEx(&info);

	return info.hProcess;
}
