﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Threading;
using System.Threading.Tasks;

namespace CompleteEraser
{
    class ShrredFiles : IOperation
    {
        public event ProgressingEventHandler Progressing;
        public event ProgressedEventHandler Progressed;
        public event EventHandler Complete;

        public async void ExecuteAsync(IEnumerable<string> files, CancellationToken cancelToken)
        {
            foreach (string file in files)
            {
                Progressing(this, new ProgressingEventArgs(file));

            RETRY:
                ProgressedEventArgs e = new ProgressedEventArgs(file, null);

                try
                {
                    await Task.Factory.StartNew(() =>
                    {
                        FileBreaker.BreakFileOrFolder(file);
                    }, cancelToken);
                }
                catch (OperationCanceledException)
                {
                    break;
                }
                catch (UnauthorizedAccessException uae)
                {
                    e.ex = uae;
                }
                catch (IOException ie)
                {
                    e.ex = ie;
                }
                Progressed(this, e);
                if (e.retry)
                    goto RETRY;
                if (e.breaked)
                    break;
            }
            this.Complete(this, null);
        }
    }
}
