#include <string.h>
#include "turing.h"

int
turingRuleRead(FILE* fpt, turingRule rule[])
{
	int i;
	char s[MAXTAPE];
	char* stmp;

	for(i=0; i<MAXRULE; i++) {
		stmp = fgets(s, MAXTAPE, fpt);
		if(stmp==NULL) {
			break;
		}
		/* Input */
		strncpy(rule[i].currentStatus, strtok(s,    " "), MAXSTATUS);
		stmp = strtok(NULL, " ");
		rule[i].inputData          = stmp[0];
		/* output */
		stmp = strtok(NULL, " ");
		rule[i].outputData         = stmp[0];
		stmp = strtok(NULL, " ");
		rule[i].movement           = stmp[0];
		strncpy(rule[i].nextStatus,    strtok(NULL, " \n"), MAXSTATUS);

	}

	//turingRulePrint(stderr, rule, i);
	return i;
} 

int
turingRulePrint0(FILE* fpt, turingRule rule)
{
	fprintf(fpt, "%s %c %c %c %s\n", 
		rule.currentStatus, 
		rule.inputData, 
		rule.outputData, 
		rule.movement,
		rule.nextStatus 
		);
}


int
turingRulePrint(FILE* fpt, turingRule rule[], int max)
{
	int i;
	
	for(i=0; i<max; i++) {
		turingRulePrint0(fpt, rule[i]);
	}
}


