#include "turing.h"
#include <string.h>

#define RULE 1
#define TAPE 2 
#define POS  3 
#define START  4 

int
main(int argc, char* argv[])
{
	turingMachine TM;
	turingTape    Tape;
	FILE* fptRule;
	FILE* fptTape;

	if(argc!=5) {
		fprintf(stderr, "Usage: %s rules tapes current startStatus\n", argv[0]);
		exit(EXIT_FAILURE);
	}
	fptRule = fopen(argv[RULE], "r");
	if(fptRule == NULL) {
		fprintf(stderr, "%s not opened\n", argv[RULE]);
		exit(EXIT_FAILURE);
	}
	TM.maxRule = turingRuleRead(fptRule, TM.rule);
	//fprintf(stderr, "RuleNumber: %d\n", TM.maxRule);

	
	fptTape = fopen(argv[TAPE], "r");
	if(fptRule == NULL) {
		fprintf(stderr, "%s not opened\n", argv[TAPE]);
		exit(EXIT_FAILURE);
	}
	turingTapeRead(fptTape, &Tape);
	//fprintf(stderr, "TapeLength: %d\n", Tape.lastPosition);
	
	TM.currentPosition = atoi(argv[POS]);		
	if(TM.currentPosition<=0) {
		fprintf(stderr, "too left: %d\n", TM.currentPosition);
		exit(EXIT_FAILURE);
	}
	strncpy(TM.status, argv[START], MAXSTATUS);

	TM.currentRule = -1;
	
	turingMachineRun(&TM, &Tape, stdout, 1);
}
