package coboled.editors;

class CobolElementType implements Comparable<CobolElementType> {
	
	public static final CobolElementType ROOT = new CobolElementType(0);
	
	public static final CobolElementType DIVISION = new CobolElementType(1);
	
	public static final CobolElementType SECTION = new CobolElementType(2);
	
	public static final CobolElementType PARAGRAPH = new CobolElementType(3);
	
	public static final CobolElementType DATA = new CobolElementType(4);
	
	private int lebel;
	
	private CobolElementType(int lebel) {
		this.lebel = lebel;
	}

	public int getLebel() {
		return lebel;
	}

	public void setLebel(int lebel) {
		this.lebel = lebel;
	}
	
	public int compareTo(CobolElementType o) {
		if(this.lebel < o.getLebel()) {
			return 1;
		} else if(this.lebel == o.getLebel()) {
			return 0;
		}
		return -1;
	}
}
