package coboled.editors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import coboled.editors.CobolElement.CobolElementType;

public class CobolParser {

	public CobolElement parse(String source) {
		CobolElement root = new CobolElement("root", CobolElementType.OTHER);
		try {
			BufferedReader reader = new BufferedReader(new StringReader(source));
			int offset = 0;
			String line = null;
			while ((line = reader.readLine()) != null) {

				// 部の記述があった場合
				Pattern pattern = Pattern.compile("^.{6}\\s(\\s{0,3}[^\\s].*?DIVISION)\\.",
						Pattern.CASE_INSENSITIVE);
				Matcher matcher = pattern.matcher(line);
				boolean match = matcher.matches();
				if (match) {
					CobolElement divisionElement = new CobolElement(matcher
							.group(1).trim(), CobolElementType.DIVISION);
					divisionElement.setParent(root);
					divisionElement.setOffset(offset);
					root.appendChild(divisionElement);
					offset = offset + line.length() + 1;
					continue;
				}

				// 節の記述があった場合
				Pattern pattern2 = Pattern.compile("^.{6}\\s(\\s{0,3}[^\\s].*?SECTION)\\.",
						Pattern.CASE_INSENSITIVE);
				Matcher matcher2 = pattern2.matcher(line);
				boolean match2 = matcher2.matches();
				if (match2) {
					CobolElement sectionElement = new CobolElement(matcher2
							.group(1).trim(), CobolElementType.SECTION);
					CobolElement parent = getLastElement(root);
					sectionElement.setParent(parent);
					sectionElement.setOffset(offset);
					parent.appendChild(sectionElement);
					offset = offset + line.length() + 1;
					continue;
				}

				// その他
				Pattern pattern3 = Pattern.compile("^.{6}\\s(\\s{0,3}[^\\s].*)",
						Pattern.CASE_INSENSITIVE);
				Matcher matcher3 = pattern3.matcher(line);
				boolean match3 = matcher3.matches();
				if (match3) {
					CobolElement sectionElement = new CobolElement(matcher3
							.group(1), CobolElementType.OTHER);
					CobolElement parent = getLastElement(root);
					sectionElement.setParent(parent);
					sectionElement.setOffset(offset);
					parent.appendChild(sectionElement);
					offset = offset + line.length() + 1;
					continue;
				}

				offset = offset + line.length() + 1;

			}
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		return root;
	}

	private static CobolElement getLastElement(CobolElement element) {
		if (element.getChildren() != null && element.getChildren().length != 0) {
			int lastIndex = element.getChildren().length - 1;
			return element.getChildren()[lastIndex];
		}
		return element;
	}
}
