package coboled.editors;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import coboled.Activator;

public class CobolLabelProvider extends LabelProvider {

	private Image divisionImage = Activator.getImageDescriptor(
			"icons/public_co.gif").createImage();

	private Image sectionImage = Activator.getImageDescriptor(
			"icons/protected_co.gif").createImage();

	private Image otherImage = Activator.getImageDescriptor(
			"icons/private_co.gif").createImage();

	@Override
	public Image getImage(Object element) {
		if (element instanceof CobolElement) {
			switch (((CobolElement) element).getType()) {
			case DIVISION:
				return divisionImage;
			case SECTION:
				return sectionImage;
			case OTHER:
				return otherImage;
			default:
				return null;
			}
		}
		return null;
	}

	@Override
	public String getText(Object element) {
		if (element instanceof CobolElement) {
			return ((CobolElement) element).getName();
		}
		return super.getText(element);
	}

	@Override
	public void dispose() {
		divisionImage.dispose();
		sectionImage.dispose();
		otherImage.dispose();
		super.dispose();
	}
}
