package coboled.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CobolElement {
	
	public enum CobolElementType {DIVISION, SECTION, OTHER}; 

	private String name = null;

	private CobolElement parent = null;
	
	private int offset = -1;
	
	private CobolElementType type;

	private List<CobolElement> children = new ArrayList<CobolElement>();

	public CobolElement(String name, CobolElementType type) {
		this.name = name;
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void appendChild(CobolElement element) {
		children.add(element);
	}

	public CobolElement[] getChildren() {
		return children.toArray(new CobolElement[children.size()]);
	}

	public CobolElement getParent() {
		return parent;
	}

	public void setParent(CobolElement parent) {
		this.parent = parent;
	}

	public int getOffset() {
		return offset;
	}

	public void setOffset(int offset) {
		this.offset = offset;
	}

	public CobolElementType getType() {
		return type;
	}

	public void setType(CobolElementType type) {
		this.type = type;
	}
	
	public CobolElement getElementByOffset(int offset) {
		List<CobolElement> results = toList();
		CobolElement element1 = null;
		CobolElement element2 = null;
		Iterator<CobolElement> iterator = results.iterator();
		while(iterator.hasNext()) {
			element2 = iterator.next();
			if((element1 != null && element1.getOffset() <= offset) 
					&& (element2.getOffset() > offset)) {
				return element1;
			} else {
				element1 = element2;
			}
		}
		return element2;
	}
	
	public List<CobolElement> toList() {
		List<CobolElement> results = new ArrayList<CobolElement>();
		results.add(this);
		Iterator<CobolElement> iterator = this.children.iterator();
		while(iterator.hasNext()) {
			CobolElement element = iterator.next();
			results.addAll(element.toList());
		}
		return results;
	}
}
