/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ 㳰ǽ                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"
#include "knl_sys.h"


/* 㳰׵ */
ER ras_tex(
		ID     tskid,		/* ׵оݤΥIDֹ */
		TEXPTN rasptn)		/* ׵᤹륿㳰Υ㳰װ */
{
	T_KERNEL_TCB_RAM   *tcb_ram;
	T_KERNEL_TEXCB_RAM *texcb;

	/* ID ϰϥå */
	if ( tskid == TSK_SELF )
	{
		/* ƥȥå */
#ifdef HOS_ERCHK_E_ID
		if ( sns_ctx() )
		{
			return E_ID;	/* IDֹ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
		texcb = tcb_ram->texcb;
		
		mknl_loc_sys();	/* ƥΥå */
	}
	else
	{
		/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
		if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
		{
			return  E_ID;	/* IDֹ */
		}
#endif
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		mknl_loc_sys();	/* ƥΥå */
	
		/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* ƥΥå */
			return E_NOEXS;		/* ֥̤ */
		}
#endif
		
		texcb = tcb_ram->texcb;
		
		/* ֥Ⱦ֥å */
#ifdef HOS_ERCHK_E_OBJ
		if ( texcb == NULL || mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )
		{
			mknl_unl_sys();		/* ƥΥå */
			return E_OBJ;		/* ֥Ⱦ */
		}
#endif
	}

	/* 㳰׵ */
	texcb->rasptn = (TEXPTN)(texcb->rasptn | rasptn);
	mknl_ras_tex(&tcb_ram->mtcb);

	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
